/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.datatool;

import com.dickimawbooks.texparserlib.Command;
import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.TeXFloatingPoint;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import java.io.IOException;

public class CurrencyContentCommand
extends Command
implements TeXNumber {
    private TeXObject symbol;
    private double value;

    public CurrencyContentCommand(String string, TeXObject teXObject, double d) {
        super(string);
        this.symbol = teXObject;
        this.value = d;
    }

    @Override
    public Object clone() {
        return new CurrencyContentCommand(this.name, (TeXObject)this.symbol.clone(), this.value);
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public int getValue() {
        return (int)this.value;
    }

    public void setValue(double d) {
        this.value = d;
    }

    @Override
    public int number(TeXParser teXParser) throws TeXSyntaxException {
        return this.getValue();
    }

    @Override
    public void multiply(int n) {
        this.value *= (double)n;
    }

    @Override
    public void divide(int n) {
        this.value /= (double)n;
    }

    @Override
    public void advance(TeXParser teXParser, Numerical numerical) throws TeXSyntaxException {
        this.value += (double)numerical.number(teXParser);
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObjectList teXObjectList2 = teXParser.getListener().createStack();
        teXObjectList2.add((TeXObject)this.symbol.clone(), true);
        teXObjectList2.add(new TeXFloatingPoint(this.value));
        return teXObjectList2;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObjectList teXObjectList2 = teXParser.getListener().createStack();
        teXObjectList2.add((TeXObject)this.symbol.clone(), true);
        teXObjectList2.addAll(teXParser.getListener().createString("" + this.value));
        return teXObjectList2;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return this.expandfully(teXParser, teXParser);
    }

    @Override
    public String toString() {
        return String.format("%s[name=%s,symbol=%s,value=%f]", this.getName(), this.symbol.toString(), this.value);
    }
}

