# ***** BEGIN GPL LICENSE BLOCK *****
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#
# ***** END GPL LICENSE BLOCK *****

# <pep8 compliant>

# Update "languages" text file used by Blender at runtime to build translations menu.


import os


OK = 0
MISSING = 1
TOOLOW = 2
FORBIDDEN = 3
FLAG_MESSAGES = {
    OK: "",
    MISSING: "No translation yet!",
    TOOLOW: "Not enough advanced to be included...",
    FORBIDDEN: "Explicitly forbidden!",
}

def gen_menu_file(stats, settings):
    # Generate languages file used by Blender's i18n system.
    # First, match all entries in LANGUAGES to a lang in stats, if possible!
    tmp = []
    for uid_num, label, uid, in settings.LANGUAGES:
        if uid in stats:
            if uid in settings.IMPORT_LANGUAGES_SKIP:
                tmp.append((stats[uid], uid_num, label, uid, FORBIDDEN))
            else:
                tmp.append((stats[uid], uid_num, label, uid, OK))
        else:
            tmp.append((0.0, uid_num, label, uid, MISSING))
    stats = tmp
    limits = sorted(settings.LANGUAGES_CATEGORIES, key=lambda it: it[0], reverse=True)
    idx = 0
    stats = sorted(stats, key=lambda it: it[0], reverse=True)
    langs_cats = [[] for i in range(len(limits))]
    highest_uid = 0
    for lvl, uid_num, label, uid, flag in stats:
        if lvl < limits[idx][0]:
            # Sub-sort languages by iso-codes.
            langs_cats[idx].sort(key=lambda it: it[2])
            idx += 1
        if lvl < settings.IMPORT_MIN_LEVEL and flag == OK:
            flag = TOOLOW
        langs_cats[idx].append((uid_num, label, uid, flag))
        if abs(uid_num) > highest_uid:
            highest_uid = abs(uid_num)
    # Sub-sort last group of languages by iso-codes!
    langs_cats[idx].sort(key=lambda it: it[2])
    data_lines = [
        "# File used by Blender to know which languages (translations) are available, ",
        "# and to generate translation menu.",
        "#",
        "# File format:",
        "# ID:MENULABEL:ISOCODE",
        "# ID must be unique, except for 0 value (marks categories for menu).",
        "# Line starting with a # are comments!",
        "#",
        "# Automatically generated by bl_i18n_utils/update_languages_menu.py script.",
        "# Highest ID currently in use: {}".format(highest_uid),
    ]
    for cat, langs_cat in zip(limits, langs_cats):
        data_lines.append("#")
        # Write "category menu label"...
        if langs_cat:
            data_lines.append("0:{}:".format(cat[1]))
        else:
            # Do not write the category if it has no language!
            data_lines.append("# Void category! #0:{}:".format(cat[1]))
        # ...and all matching language entries!
        for uid_num, label, uid, flag in langs_cat:
            if flag == OK:
                data_lines.append("{}:{}:{}".format(uid_num, label, uid))
            else:
                # Non-existing, commented entry!
                data_lines.append("# {} #{}:{}:{}".format(FLAG_MESSAGES[flag], uid_num, label, uid))
    with open(os.path.join(settings.TRUNK_MO_DIR, settings.LANGUAGES_FILE), 'w') as f:
        f.write("\n".join(data_lines))
