/*
    Copyright (C) 2013-2023 Nicola L.C. Talbot
    www.dickimaw-books.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package com.dickimawbooks.texparserlib.html;

import java.io.IOException;
import java.util.Vector;

import com.dickimawbooks.texparserlib.*;

public class L2HMathGroup extends MathGroup
{
   public L2HMathGroup()
   {
      super();
   }

   public L2HMathGroup(int capacity)
   {
      super(capacity);
   }

   public TeXObjectList createList()
   {
      L2HMathGroup math = new L2HMathGroup(capacity());
      math.setInLine(isInLine());
      return math;
   }

   @Override
   public boolean processList(TeXParser parser, StackMarker marker)
    throws IOException
   {
      L2HConverter listener = (L2HConverter)parser.getListener();
      boolean markerFound = false;

      while (size() > 0)
      {
         if (get(0).equals(marker))
         {
            markerFound = true;
            remove(0);
            break;
         }

         TeXObject object = expandedPopStack(parser);

         if (object == null)
         {
            break;
         }

         object.process(parser, this);
      }

      return markerFound;
   }

   public void startGroup(TeXParser parser)
    throws IOException
   {
      L2HConverter listener = (L2HConverter)parser.getListener();

      parser.startGroup();

      if (!isInLine())
      {
         listener.endParagraph();

         parser.getSettings().setMode(TeXMode.DISPLAY_MATH);

         listener.writeliteral("<div class=\"displaymath\">");

         listener.setCurrentBlockType(DocumentBlockType.BLOCK);
      }
      else
      {
         parser.getSettings().setMode(TeXMode.INLINE_MATH);
      }

      if (listener.useMathJax())
      {
         if (isInLine())
         {
            listener.writeliteral(listener.mathJaxStartInline());
         }
         else
         {
            listener.writeliteral(listener.mathJaxStartDisplay());
         }
      }
   }

   public void endGroup(TeXParser parser)
    throws IOException
   {
      L2HConverter listener = (L2HConverter)parser.getListener();

      if (listener.useMathJax())
      {
         if (isInLine())
         {
            listener.writeliteral(listener.mathJaxEndInline());
         }
         else
         {
            listener.writeliteral(listener.mathJaxEndDisplay());
         }
      }

      if (!isInLine())
      {
         listener.writeliteral("</div>");
         listener.setCurrentBlockType(DocumentBlockType.BODY);
      }

      if (parser.isDebugMode(TeXParser.DEBUG_SETTINGS))
      {
         parser.logMessage("GROUP END " + toString());
      }

      parser.endGroup();
   }
}
