/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.properties;

import java.io.File;
import java.util.Locale;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.builder.BuilderChooser;
import net.sourceforge.texlipse.properties.TexlipsePreferencePage;
import net.sourceforge.texlipse.properties.TexlipseProperties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.AutoCompleteField;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class TexlipseProjectPropertyPage
extends PropertyPage {
    private Text sourceFileField;
    private Text outFileField;
    private Text tempDirField;
    private Text bibRefDirField;
    private Button derivedTempCheckbox;
    private Button derivedOutputCheckbox;
    private BuilderChooser builderChooser;
    private Text indexStyleField;
    private Text languageField;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(256));
        TexlipsePreferencePage.addSeparator(1, composite);
        this.addMainSection(composite);
        TexlipsePreferencePage.addSeparator(1, composite);
        this.addOutSection(composite);
        TexlipsePreferencePage.addSeparator(1, composite);
        this.addTempDirSection(composite);
        TexlipsePreferencePage.addSeparator(1, composite);
        this.addDerivedSection(composite);
        TexlipsePreferencePage.addSeparator(1, composite);
        this.addFormatSection(composite);
        TexlipsePreferencePage.addSeparator(1, composite);
        this.addIndexStyleSection(composite);
        TexlipsePreferencePage.addSeparator(1, composite);
        this.addLangSection(composite);
        this.performDefaults();
        return composite;
    }

    private void addMainSection(Composite parent) {
        Composite composite = this.createDefaultComposite(parent, 2);
        Label pathLabel = new Label(composite, 0);
        pathLabel.setText(TexlipsePlugin.getResourceString("propertiesMainFileLabel"));
        pathLabel.setLayoutData((Object)new GridData());
        pathLabel.setToolTipText(TexlipsePlugin.getResourceString("propertiesMainFileTooltip"));
        this.sourceFileField = new Text(composite, 2116);
        this.sourceFileField.setLayoutData((Object)new GridData(768));
        this.sourceFileField.setToolTipText(TexlipsePlugin.getResourceString("propertiesMainFileTooltip"));
        this.sourceFileField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TexlipseProjectPropertyPage.this.validateSourceFileField();
            }
        });
    }

    private void validateSourceFileField() {
        String text = this.sourceFileField.getText();
        if (text == null) {
            this.setValid(true);
            return;
        }
        if ((text = text.trim()).length() == 0) {
            this.setValid(true);
            return;
        }
        if (text.indexOf(58) >= 0 || text.indexOf(59) >= 0) {
            this.setValid(false);
            return;
        }
        String dir = null;
        String file = "";
        int index = text.lastIndexOf(47);
        if (index < 0) {
            file = text;
        } else {
            dir = text.substring(0, index);
            file = text.substring(index + 1);
        }
        if (dir != null && !this.projectFileExists(dir)) {
            this.setValid(false);
            return;
        }
        this.setValid(this.projectFileExists(text) && (file.endsWith(".tex") || file.endsWith(".ltx")));
    }

    private void addOutSection(Composite parent) {
        Composite composite = this.createDefaultComposite(parent, 2);
        Label pathLabel = new Label(composite, 0);
        pathLabel.setText(TexlipsePlugin.getResourceString("propertiesOutFileLabel"));
        pathLabel.setLayoutData((Object)new GridData());
        pathLabel.setToolTipText(TexlipsePlugin.getResourceString("propertiesOutFileTooltip"));
        this.outFileField = new Text(composite, 2116);
        this.outFileField.setLayoutData((Object)new GridData(768));
        this.outFileField.setToolTipText(TexlipsePlugin.getResourceString("propertiesOutFileTooltip"));
        this.outFileField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TexlipseProjectPropertyPage.this.validateOutputFileField();
            }
        });
    }

    private void validateOutputFileField() {
        String text = this.outFileField.getText();
        if (text == null) {
            this.setValid(true);
            return;
        }
        if ((text = text.trim()).length() == 0) {
            this.setValid(true);
            return;
        }
        if (text.indexOf(58) >= 0 || text.indexOf(59) >= 0) {
            this.setValid(false);
            return;
        }
        String dir = null;
        String file = "";
        int index = text.lastIndexOf(47);
        if (index < 0) {
            file = text;
        } else {
            dir = text.substring(0, index);
            file = text.substring(index + 1);
        }
        if (dir != null && !this.projectFileExists(dir)) {
            this.setValid(false);
            return;
        }
        String format = this.builderChooser.getSelectedFormat();
        if (format != null) {
            this.setValid(file.endsWith(format));
        }
    }

    private void addTempDirSection(Composite parent) {
        Composite composite = this.createDefaultComposite(parent, 3);
        Label label = new Label(composite, 0);
        label.setText(TexlipsePlugin.getResourceString("propertiesTempDirLabel"));
        label.setLayoutData((Object)new GridData());
        label.setToolTipText(TexlipsePlugin.getResourceString("propertiesTempDirTooltip"));
        this.tempDirField = new Text(composite, 2116);
        this.tempDirField.setLayoutData((Object)new GridData(768));
        this.tempDirField.setToolTipText(TexlipsePlugin.getResourceString("propertiesTempDirTooltip"));
        this.tempDirField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TexlipseProjectPropertyPage.this.validateTempFileField();
            }
        });
    }

    private void validateTempFileField() {
        String text = this.tempDirField.getText();
        if (text != null && text.length() > 0) {
            if (text.indexOf(58) >= 0 || text.indexOf(59) >= 0) {
                this.setValid(false);
            } else {
                boolean exists = this.projectFileExists(text);
                this.setValid(exists);
            }
        } else {
            this.setValid(true);
        }
    }

    private void addBibRefDirSection(Composite parent) {
        Composite composite = this.createDefaultComposite(parent, 3);
        Label label = new Label(composite, 0);
        label.setText(TexlipsePlugin.getResourceString("propertiesBibRefDirLabel"));
        label.setLayoutData((Object)new GridData());
        label.setToolTipText(TexlipsePlugin.getResourceString("propertiesBibRefDirTooltip"));
        this.bibRefDirField = new Text(composite, 2116);
        this.bibRefDirField.setLayoutData((Object)new GridData(768));
        this.bibRefDirField.setToolTipText(TexlipsePlugin.getResourceString("propertiesBibRefDirTooltip"));
        this.bibRefDirField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TexlipseProjectPropertyPage.this.validateBibRefFileField();
            }
        });
    }

    private void validateBibRefFileField() {
        String text = this.bibRefDirField.getText();
        if (text != null && text.length() > 0) {
            if (text.indexOf(59) >= 0) {
                this.setValid(false);
            } else {
                boolean exists = this.projectFileExists(text);
                if (!exists) {
                    File f = new File(text);
                    this.setValid(f.exists());
                } else {
                    this.setValid(exists);
                }
            }
        } else {
            this.setValid(true);
        }
    }

    private void addDerivedSection(Composite parent) {
        this.derivedTempCheckbox = new Button(parent, 16416);
        this.derivedTempCheckbox.setLayoutData((Object)new GridData());
        this.derivedTempCheckbox.setText(TexlipsePlugin.getResourceString("propertiesDerivedTempFiles"));
        this.derivedTempCheckbox.setToolTipText(TexlipsePlugin.getResourceString("propertiesDerivedFilesTooltip"));
        this.derivedOutputCheckbox = new Button(parent, 16416);
        this.derivedOutputCheckbox.setLayoutData((Object)new GridData());
        this.derivedOutputCheckbox.setText(TexlipsePlugin.getResourceString("propertiesDerivedOutputFiles"));
        this.derivedOutputCheckbox.setToolTipText(TexlipsePlugin.getResourceString("propertiesDerivedFilesTooltip"));
    }

    private void addFormatSection(Composite parent) {
        this.builderChooser = new BuilderChooser(parent);
        this.builderChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String fmt = TexlipseProjectPropertyPage.this.builderChooser.getSelectedFormat();
                if (fmt != null) {
                    TexlipseProjectPropertyPage.this.setOutputExtension(fmt);
                }
            }
        });
    }

    private void addIndexStyleSection(Composite parent) {
        Composite composite = this.createDefaultComposite(parent, 2);
        Label label = new Label(composite, 16448);
        label.setLayoutData((Object)new GridData());
        label.setText(TexlipsePlugin.getResourceString("propertiesMakeindexStyle"));
        this.indexStyleField = new Text(composite, 2052);
        this.indexStyleField.setLayoutData((Object)new GridData(768));
    }

    private void addLangSection(Composite parent) {
        Label descr = new Label(parent, 16448);
        descr.setLayoutData((Object)new GridData());
        descr.setText(TexlipsePlugin.getResourceString("propertiesLanguageDescription"));
        Composite composite = this.createDefaultComposite(parent, 2);
        Label label = new Label(composite, 16384);
        label.setLayoutData((Object)new GridData());
        label.setText(TexlipsePlugin.getResourceString("propertiesLanguage"));
        this.languageField = new Text(composite, 2052);
        this.languageField.setLayoutData((Object)new GridData(768));
        this.languageField.setTextLimit(2);
        new AutoCompleteField((Control)this.languageField, (IControlContentAdapter)new TextContentAdapter(), Locale.getISOLanguages());
    }

    private void setOutputExtension(String ext) {
        int index;
        String text = this.outFileField.getText();
        if (text == null) {
            return;
        }
        if ((text = text.trim()).length() == 0) {
            text = this.sourceFileField.getText();
            if (text == null) {
                return;
            }
            if ((text = text.trim()).length() == 0) {
                return;
            }
        }
        if ((index = text.lastIndexOf(46)) < 0) {
            this.outFileField.setText(String.valueOf(text) + "." + ext);
        } else {
            String base = text.substring(0, index + 1);
            this.outFileField.setText(String.valueOf(base) + ext);
        }
    }

    private Composite createDefaultComposite(Composite parent, int columns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = columns;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        return composite;
    }

    protected void performDefaults() {
        super.performDefaults();
        IResource project = (IResource)this.getElement();
        if (project.getType() == 4 && TexlipseProperties.isProjectPropertiesFileChanged((IProject)project)) {
            TexlipseProperties.loadProjectProperties((IProject)project);
        }
        String derivTmp = TexlipseProperties.getProjectProperty(project, "markTmpDer");
        this.derivedTempCheckbox.setSelection("true".equals(derivTmp));
        String derivOut = TexlipseProperties.getProjectProperty(project, "markDer");
        this.derivedOutputCheckbox.setSelection("true".equals(derivOut));
        String lang = TexlipseProperties.getProjectProperty(project, "langSpell");
        this.languageField.setText(lang != null ? lang : "");
        String sty = TexlipseProperties.getProjectProperty(project, "makeIndSty");
        this.indexStyleField.setText(sty != null ? sty : "");
        String srcDir = TexlipseProperties.getProjectProperty(project, "srcDir");
        if (srcDir == null) {
            srcDir = "";
        } else if (srcDir.length() > 0 && !srcDir.endsWith("/")) {
            srcDir = String.valueOf(srcDir) + '/';
        }
        String srcFile = TexlipseProperties.getProjectProperty(project, "mainTexFile");
        this.sourceFileField.setText(srcFile != null ? String.valueOf(srcDir) + srcFile : "");
        String temp = TexlipseProperties.getProjectProperty(project, "tempDir");
        this.tempDirField.setText(temp != null ? temp : "");
        String str = TexlipseProperties.getProjectProperty(project, "builderNum");
        int num = 0;
        if (str == null) {
            str = TexlipsePlugin.getPreference("builderNum");
        }
        try {
            num = Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {}
        this.builderChooser.setSelectedBuilder(num);
        String outDir = TexlipseProperties.getProjectProperty(project, "outputDir");
        if (outDir == null) {
            outDir = "";
        } else if (outDir.length() > 0 && !outDir.endsWith("/")) {
            outDir = String.valueOf(outDir) + '/';
        }
        String outFile = TexlipseProperties.getProjectProperty(project, "outputFile");
        this.outFileField.setText(outFile != null ? String.valueOf(outDir) + outFile : "");
        this.validateSourceFileField();
        this.validateOutputFileField();
        this.validateTempFileField();
    }

    public boolean performOk() {
        int num;
        int index;
        String outFile;
        String format;
        String tmpDir;
        int index2;
        IResource project = (IResource)this.getElement();
        String srcDir = "";
        String outDir = "";
        String srcFile = this.sourceFileField.getText();
        if (srcFile != null && (index2 = (srcFile = srcFile.trim()).lastIndexOf(47)) > 0) {
            srcDir = srcFile.substring(0, index2 + 1);
            srcFile = srcFile.substring(index2 + 1);
        }
        if ((tmpDir = this.tempDirField.getText()) != null) {
            tmpDir = tmpDir.trim();
        }
        if ((format = this.builderChooser.getSelectedFormat()) == null) {
            format = "dvi";
        }
        if ((outFile = this.outFileField.getText()) != null && (index = (outFile = outFile.trim()).lastIndexOf(47)) > 0) {
            outDir = outFile.substring(0, index + 1);
            outFile = outFile.substring(index + 1);
        }
        if ((outFile == null || outFile.length() == 0) && srcFile != null && srcFile.length() > 0) {
            outFile = String.valueOf(srcFile.substring(0, srcFile.lastIndexOf(46) + 1)) + format;
            outDir = srcDir;
        }
        if ((num = this.builderChooser.getSelectedBuilder()) == -1) {
            num = 0;
        }
        TexlipseProperties.setProjectProperty(project, "builderNum", String.valueOf(num));
        TexlipseProperties.setProjectProperty(project, "markTmpDer", String.valueOf(this.derivedTempCheckbox.getSelection()));
        TexlipseProperties.setProjectProperty(project, "markDer", String.valueOf(this.derivedOutputCheckbox.getSelection()));
        TexlipseProperties.setProjectProperty(project, "langSpell", this.languageField.getText());
        TexlipseProperties.setProjectProperty(project, "makeIndSty", this.indexStyleField.getText());
        TexlipseProperties.setProjectProperty(project, "mainTexFile", srcFile);
        TexlipseProperties.setProjectProperty(project, "srcDir", srcDir);
        TexlipseProperties.setProjectProperty(project, "outputFile", outFile);
        TexlipseProperties.setProjectProperty(project, "outputDir", outDir);
        TexlipseProperties.setProjectProperty(project, "tempDir", tmpDir);
        TexlipseProperties.setProjectProperty(project, "bibrefDir", "");
        TexlipseProperties.setProjectProperty(project, "outputFormat", format);
        if (project.getType() == 4) {
            IFile settingsFile = ((IProject)project).getFile(".texlipse");
            if (!settingsFile.isReadOnly()) {
                TexlipseProperties.saveProjectProperties((IProject)project);
            } else {
                MessageDialog.openWarning((Shell)this.getShell(), (String)"Warning", (String)TexlipsePlugin.getResourceString("projectSettingsReadOnly"));
            }
        }
        return true;
    }

    private boolean projectFileExists(String filename) {
        IResource res = (IResource)this.getElement();
        IProject project = res.getProject();
        IResource file = project.findMember(filename);
        return file != null && file.exists();
    }
}

