/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.spelling;

import com.swabunga.spell.engine.SpellDictionaryASpell;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TexSpellDictionary
extends SpellDictionaryASpell {
    private static final int INITIAL_CAPACITY = 32768;
    private static final char SEP_CHAR = ';';
    protected Map<Integer, StringBuilder> mainDictionary = new HashMap<Integer, StringBuilder>(32768);
    private File dictFile = null;

    public TexSpellDictionary(Reader wordList) throws IOException {
        super(null);
        this.createDictionary(new BufferedReader(wordList));
    }

    public TexSpellDictionary(Reader wordList, Reader phonetic) throws IOException {
        super(phonetic);
        this.createDictionary(new BufferedReader(wordList));
    }

    public void addDictionary(File wordList) throws FileNotFoundException, IOException {
        this.addDictionaryHelper(new BufferedReader(new FileReader(wordList)));
    }

    public void setUserDict(File userDict) {
        this.dictFile = userDict;
        try {
            this.addDictionary(userDict);
        }
        catch (IOException iOException) {}
    }

    public void addWord(String word) {
        this.putWordUnique(word);
        if (this.dictFile == null) {
            return;
        }
        try {
            boolean succ;
            if (!this.dictFile.exists() && !(succ = this.dictFile.createNewFile())) {
                return;
            }
            FileWriter w = new FileWriter(this.dictFile.toString(), true);
            w.write(word);
            w.write("\n");
            ((Writer)w).close();
        }
        catch (IOException iOException) {}
    }

    protected void createDictionary(BufferedReader in) throws IOException {
        String line;
        while ((line = in.readLine()) != null) {
            if (line.length() <= 0) continue;
            this.putWord(line.trim());
        }
    }

    public void addDictionaryHelper(BufferedReader in) throws IOException {
        String line;
        while ((line = in.readLine()) != null) {
            if (line.length() <= 0) continue;
            this.putWordUnique(line.trim());
        }
    }

    protected void putWord(String word) {
        int code = this.getCode(word).hashCode();
        StringBuilder words = this.mainDictionary.get(code);
        if (words != null) {
            words.append(word);
            words.append(';');
        } else {
            words = new StringBuilder();
            words.append(';');
            words.append(word);
            words.append(';');
            this.mainDictionary.put(code, words);
        }
    }

    protected void putWordUnique(String word) {
        int code = this.getCode(word).hashCode();
        StringBuilder words = this.mainDictionary.get(code);
        if (words != null) {
            if (words.indexOf(String.valueOf(';') + word + ';') == -1) {
                words.append(word);
                words.append(';');
            }
        } else {
            words = new StringBuilder();
            words.append(';');
            words.append(word);
            words.append(';');
            this.mainDictionary.put(code, words);
        }
    }

    public void compress() {
        Collection<StringBuilder> c = this.mainDictionary.values();
        for (StringBuilder st : c) {
            st.trimToSize();
        }
    }

    public List<String> getWords(String code) {
        StringBuilder mainDictResult = this.mainDictionary.get(code.hashCode());
        if (mainDictResult == null) {
            return new ArrayList<String>(1);
        }
        StringTokenizer stk = new StringTokenizer(mainDictResult.toString(), ";");
        ArrayList<String> list = new ArrayList<String>(1);
        while (stk.hasMoreTokens()) {
            list.add(stk.nextToken());
        }
        return list;
    }

    public boolean isCorrect(String word) {
        StringBuilder words = this.mainDictionary.get(this.getCode(word).hashCode());
        if (words == null) {
            return false;
        }
        if (words.indexOf(String.valueOf(';') + word + ';') >= 0) {
            return true;
        }
        return words.indexOf(String.valueOf(';') + word.toLowerCase() + ';') >= 0;
    }
}

