            title   MF_arith

; arithmetic subroutines for METAFONT and MetaPost
; Copyright (C) 1991,96 by Peter Breitenlohner
; Distributed under terms of GNU General Public License

DATA        segment word
            extrn   aritherror:byte
DATA        ends

CODE        segment word
            assume  cs:CODE, ds:DATA

; subroutine doarg
;            |arg1| => si:bx
;            |arg2| => di:ax
;            sign of result => carry flag on stack

doarg       proc    near
            pop     cx           ; return address

arg1_hi     equ     word ptr [bp+12]
arg1_lo     equ     word ptr [bp+10]
arg2_hi     equ     word ptr [bp+8]
arg2_lo     equ     word ptr [bp+6]

            mov     bx,arg1_lo
            mov     si,arg1_hi   ; si:bx = arg1
            or      si,si
            clc
            jns     arg1pos
            neg     si
            neg     bx
            sbb     si,0         ; si:bx = |arg1|
            stc
arg1pos:    pushf
            mov     ax,arg2_lo
            mov     di,arg2_hi   ; di:ax = arg2
            or      di,di
            jns     arg2pos
            popf
            cmc
            pushf
            neg     di
            neg     ax
            sbb     di,0         ; di:ax = |arg2|
arg2pos:    jmp     cx           ; return
doarg       endp

; subroutine domult
;            |q*f|/2^16 => dx:ax:bx
;     input: si:bx = |q| , di:cx = |f| , dx:ax = q_lo*f_lo

domult      proc   near
            mov     ax,bx
            mov     bx,dx        ; bx = q_lo*f_lo/2^16
            mul     di
            add     bx,ax
            adc     dx,0
            mov     ax,cx
            mov     cx,dx        ; cx:bx = q_lo*|f|/2^16
            mul     si
            add     bx,ax
            adc     cx,dx        ; cx:bx = (q_lo*|f|+q_hi*f_lo)/2^16
            mov     ax,di
            mul     si
            add     ax,cx
            adc     dx,0         ; dx:ax:bx = |q|*|f|/2^16
            ret
domult      endp

; function  take_fraction(q:integer;f:fraction):integer;
;           computes q*f/2^28+1/2

            public takefraction
takefraction proc   far
            push    bp
            mov     bp,sp
            call    doarg        ; q = si:bx , f = di:ax
            mov     cx,ax
            mul     bx           ; dx:ax = q_lo*f_lo
            call    domult       ; dx:ax:bx = |q|*|f|/2^16
            add     bh,08h       ; add 2^27
            adc     ax,0
            adc     dx,0
            test    dh,0f8h
            jnz     short error  ; result will be > 2^31-1
            mov     cx,4         ; shift
doleft:     shl     bh,1         ;   dx:ax:bh
            rcl     ax,1         ;     left
            rcl     dx,1         ;       four
            loop    doleft       ;         bits
            jmp     short dores  ; dx:ax = |result|
takefraction endp

; function  take_scaled(q:integer;f:scaled):integer;
;           computes q*f/2^16+1/2

            public takescaled
takescaled  proc   far
            push    bp
            mov     bp,sp
            call    doarg        ; q = si:bx , f = di:ax
            mov     cx,ax
            mul     bx           ; dx:ax = q_lo*f_lo
            add     ah,80h       ; add 2^15
            adc     dx,0
            call    domult       ; dx:ax:bx = |q|*|f|/2^16
            jnz     error        ; result is > 2^32-1
            or      dx,ax
            js      error        ; result is > 2^31-1
            mov     ax,bx
dores:      popf                 ; dx:ax = |result|
            jnc     done
            neg     dx
            neg     ax
            sbb     dx,0
done:       pop     bp
            ret     8

            extrn   slashconfusi:near
divzero:    call    slashconfusi
error:      mov     aritherror,1 ; indicate overflow
            mov     dx,07fffh
            mov     ax,0ffffh    ; dx:ax = el_gordo = 2^31-1
            jmp     dores
takescaled  endp

; function  make_fraction(p,q:integer):fraction;
;           computes 2^28*p/q+1/2

            public makefraction
makefraction proc   far
            push    bp
            mov     bp,sp
            call    doarg        ; p = si:bx , q = di:ax
            xor     dx,dx
            mov     cx,3         ; shift
doright:    shr     si,1         ;   si:bx:dx
            rcr     bx,1         ;     right
            rcr     dx,1         ;       four
            loop    doright      ;         bits
                                 ; 2^13*p = si:bx:dx
dodivide:                        ; divide si:bx:dx:0 by di:ax
            or      ax,ax
            jnz     notzero
            or      di,di
            jz      divzero      ; q= 0
notzero:    add     dx,di
            adc     bx,0
            adc     si,0         ; round
            sub     bx,ax
            sbb     si,di
            jnc     error        ; result is > 2^31-1
            add     bx,ax
            adc     si,di
            mov     bp,ax
            shl     ax,1
            rcl     dx,1
            mov     cx,31
divloop:    rcl     bx,1
            rcl     si,1
            sub     bx,bp
            sbb     si,di
            jnc     bitzero
            add     bx,bp
            adc     si,di
bitzero:    cmc
            rcl     ax,1
            rcl     dx,1
            loop    divloop
            jmp     dores
makefraction endp

; function  make_scaled(p,q:integer):scaled;
;           computes 2^16*p/q+1/2

            public makescaled
makescaled  proc   far
            push    bp
            mov     bp,sp
            call    doarg        ; p = si:bx , q = di:ax
            mov     dx,bx
            mov     bx,si
            xor     si,si
            shl     dx,1
            rcl     bx,1
            rcl     si,1         ; 2*p = si:bx:dx
            jmp     dodivide     ; divide si:bx:dx:0 by di:ax
makescaled  endp

; subroutine testnext
;            test next arg at dword ptr [bp+si-2] and decrement si
;            if  arg<0  then  complement arg and cx
;            if  arg=0  then clear cx
;     input: dx=0

next_hi     equ     word ptr [bp+si]
next_lo     equ     word ptr [bp+si-2]

testnext    proc    near
            cmp     next_hi,dx
            jg      nextdone     ; arg > 0
            jl      nextneg      ; arg < 0
            cmp     next_lo,dx
            jne     nextdone     ; arg > 0
            xor     cx,cx        ; arg = 0
            jmp     short nextdone
nextneg:    neg     cx           ; arg < 0
            neg     next_hi
            neg     next_lo
            sbb     next_hi,dx
nextdone:   sub     si,4
            ret
testnext    endp

; function  ab_vs_cd(a,b,c,d:integer):integer;
;           returns +1,0,-1 if a*b >,=,< c*d

            public abvscd
abvscd      proc    far
            push    bp
            mov     bp,sp

a_hi        equ     word ptr [bp+20]
a_lo        equ     word ptr [bp+18]
b_hi        equ     word ptr [bp+16]
b_lo        equ     word ptr [bp+14]
c_hi        equ     word ptr [bp+12]
c_lo        equ     word ptr [bp+10]
d_hi        equ     word ptr [bp+8]
d_lo        equ     word ptr [bp+6]

            xor     dx,dx
            mov     si,20
            mov     cx,1         ; test a*b
            call    testnext     ; test a
            call    testnext     ; test b
            mov     ax,cx
            mov     cx,-1        ; test -c*d
            call    testnext     ; test c
            call    testnext     ; test d
            cmp     ax,cx
            je      abvscddone   ; a*b and -c*d both >0, =0, or <0
            add     ax,cx
            jnz     abvscddone   ; of a*b and c*d one is =0, one is <>0
            push    cx           ; sign of -c*d, sign of a*b is opposite
            mov     bx,a_lo
            mov     di,a_hi      ; di:bx = |a|
            mov     si,b_lo
            mov     ax,si
            mul     bx
            push    ax
            mov     cx,dx        ; |a_lo*b_lo| = cx:ss
            mov     ax,si
            mul     di
            xor     si,si
            add     cx,ax
            adc     si,dx        ; |a*b_lo| = si:cx:ss
            mov     ax,bx
            mov     bx,b_hi
            mul     bx
            add     cx,ax
            adc     si,dx
            push    cx           ; |a*b - a_hi*b_hi| = si:ss:ss
            mov     ax,di
            mul     bx
            xor     di,di
            add     si,ax
            adc     di,dx        ; |a*b| = di:si:ss:ss
            mov     bx,c_hi
            mov     cx,d_hi
            mov     ax,cx
            mul     bx
            sub     si,ax
            sbb     di,dx        ; |a*b| - |c_hi*d_hi| = di:si:ss:ss
            mov     ax,cx
            mul     c_lo
            pop     cx
            sub     cx,ax
            sbb     si,dx
            sbb     di,0         ; |a*b| - |c*d_hi| = di:si:cx:ss
            mov     ax,bx
            mov     bx,d_lo
            mul     bx
            sub     cx,ax
            sbb     si,dx
            sbb     di,0         ; |a*b| - |c*d - c_lo*d_lo| = di:si:cx:ss
            mov     ax,c_lo
            mul     bx
            pop     bx
            sub     bx,ax
            sbb     cx,dx
            sbb     si,0
            sbb     di,0         ; |a*b| - |c*d| = di:si:cx:bx
            pop     ax
            jl      abvscddone   ; |a*b| - |c*d| < 0
            jz      testzero     ; 0 <= |a*b| - |c*d| < 2^48
abvscdneg:  neg     ax           ; |a*b| - |c*d| > 0
abvscddone: cwd
            pop     bp
            ret     16
testzero:   or      si,cx
            or      si,bx
            jnz     abvscdneg    ; |a*b| - |c*d| > 0
            xor     ax,ax        ; |a*b| - |c*d| = 0
            jmp     abvscddone
abvscd      endp

CODE        ends
            end
