/* mfdebug.c -- debug METAFONT-Talk.

   Copyright (C) 1994 Ralph Schleicher  */

/* This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <getopt.h>
#include <fcntl.h>
#include <io.h>
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <unistd.h>
#include <mftalk.h>


int height = 1664;
int width = 1200;
int input = -1;
int output = -1;
int parent = 0;


void
tee (FILE *stream, const char *format, ...)
{
  va_list ap;

  if (format)
    {
      va_start (ap, format);
      vfprintf (stdout, format, ap);
      if (stream)
	vfprintf (stream, format, ap);
      va_end (ap);
    }
  else
    {
      fflush (stdout);
      if (stream)
	fflush (stream);
    }
}


int
main (int argc, char **argv)
{
  FILE *log;
  char *prog;
  int size, num, *col;
  int *buffer, alloc;
  struct stat st;
  int c, ack = MF_ACK;

  prog = argv[0];
  opterr = 0;

  while (1)
    {
      c = getopt (argc, argv, "w:h:i:o:p:");
      if (c == -1)
	break;
      switch (c)
	{
	case 'w':
	  if (sscanf (optarg, "%d", &width) != 1 || width < 2)
	    return 1;
	  break;
	case 'h':
	  if (sscanf (optarg, "%d", &height) != 1 || height < 2)
	    return 1;
	  break;
	case 'i':
	  if (sscanf (optarg, "%d", &input) != 1 || input < 0)
	    return 1;
	  break;
	case 'o':
	  if (sscanf (optarg, "%d", &output) != 1 || output < 0)
	    return 1;
	  break;
	case 'p':
	  if (sscanf (optarg, "%d", &parent) != 1 || parent < 1)
	    return 1;
	  break;
	default:
	  return 1;
	}
    }

  if (input < 0)
    input = STDIN_FILENO;
  if (output < 0)
    output = STDOUT_FILENO;

  if (fstat (input, &st) == -1 || (st.st_mode & S_IREAD) == 0)
    return 1;
  if (fstat (output, &st) == -1 || (st.st_mode & S_IWRITE) == 0)
    return 1;

  log = fopen ("mfdebug.log", "w");
  if (!log)
    return 1;

  tee (log, "-w %d\n", width);
  tee (log, "-h %d\n", height);
  tee (log, "-i %d\n", input);
  tee (log, "-o %d\n", output);
  tee (log, "-p %d\n", parent);

  alloc = 256;
  buffer = malloc (alloc);
  if (!buffer)
    return 1;

  if (write (output, &ack, sizeof (int)) != sizeof (int))
    return 1;

  while (1)				/* Get the commands. */
    {
      if (read (input, &c, sizeof (int)) == sizeof (int))
        switch (c)
	  {
	  case MF_LINE:
	    size = 4 * sizeof (int);
	    if (read (input, buffer, size) != size)
	      return 1;
	    tee (log, "%c: %d (%d,%d)", c, buffer[0], buffer[1], buffer[2]);
	    num = buffer[3];
	    size = num * sizeof (int);
	    if (size > alloc)
	      {
		buffer = realloc (buffer, size);
		if (!buffer)
		  return 1;
		alloc = size;
	      }
	    if (read (input, buffer, size) != size)
	      return 1;
	    for (col = buffer; num; --num)
	      tee (log, " %d", *col++);
	    tee (log, "\n");
	    break;
	  case MF_RECT:
	    size = 5 * sizeof (int);
	    if (read (input, buffer, size) != size)
	      return 1;
	    tee (log, "%c: %d (%d,%d) (%d,%d)\n", c,
	      buffer[0], buffer[1], buffer[2], buffer[3], buffer[4]);
	    break;
	  case MF_FLUSH:
	    tee (log, "%c:\n", MF_FLUSH);
	    tee (log, NULL);
	    break;
	  case MF_EXIT:
	    tee (log, "%c:\n", MF_EXIT);
	    exit (0);
	  default:
	    tee (log, "%d: Unknown opcode", c);
	    return 1;
	  }
    }

  return 1;
}
