/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.fordiac.ide.model.data.UsintType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.eval.value.AnyMagnitudeValue;
import org.eclipse.fordiac.ide.model.eval.value.AnyUnsignedValue;
import org.eclipse.fordiac.ide.model.value.NumericValueConverter;

public final class USIntValue
implements AnyUnsignedValue {
    public static final USIntValue DEFAULT = new USIntValue(0);
    private final byte value;

    private USIntValue(byte value) {
        this.value = value;
    }

    public static USIntValue toUSIntValue(byte value) {
        return new USIntValue(value);
    }

    public static USIntValue toUSIntValue(Number value) {
        return new USIntValue(value.byteValue());
    }

    public static USIntValue toUSIntValue(String value) {
        return USIntValue.toUSIntValue((Number)NumericValueConverter.INSTANCE.toValue(value));
    }

    public static USIntValue toUSIntValue(AnyMagnitudeValue value) {
        return USIntValue.toUSIntValue(value.byteValue());
    }

    public UsintType getType() {
        return IecTypes.ElementaryTypes.USINT;
    }

    @Override
    public byte byteValue() {
        return this.value;
    }

    @Override
    public short shortValue() {
        return (short)Byte.toUnsignedInt(this.value);
    }

    @Override
    public int intValue() {
        return Byte.toUnsignedInt(this.value);
    }

    @Override
    public long longValue() {
        return Byte.toUnsignedLong(this.value);
    }

    @Override
    public double doubleValue() {
        return this.intValue();
    }

    @Override
    public float floatValue() {
        return this.intValue();
    }

    @Override
    public BigInteger bigIntegerValue() {
        return BigInteger.valueOf(this.longValue());
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return BigDecimal.valueOf(this.longValue());
    }

    public int hashCode() {
        return Byte.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        USIntValue other = (USIntValue)obj;
        return this.value == other.value;
    }

    public String toString() {
        return Integer.toUnsignedString(this.intValue());
    }
}

