/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.variable;

import java.lang.runtime.SwitchBootstraps;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.fordiac.ide.model.data.AnyDerivedType;
import org.eclipse.fordiac.ide.model.data.AnyElementaryType;
import org.eclipse.fordiac.ide.model.data.AnyType;
import org.eclipse.fordiac.ide.model.data.ArrayType;
import org.eclipse.fordiac.ide.model.data.DataFactory;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.DirectlyDerivedType;
import org.eclipse.fordiac.ide.model.data.EnumeratedType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.datatype.helper.InternalAttributeDeclarations;
import org.eclipse.fordiac.ide.model.datatype.helper.TypeDeclarationParser;
import org.eclipse.fordiac.ide.model.eval.Evaluator;
import org.eclipse.fordiac.ide.model.eval.EvaluatorCache;
import org.eclipse.fordiac.ide.model.eval.EvaluatorException;
import org.eclipse.fordiac.ide.model.eval.EvaluatorFactory;
import org.eclipse.fordiac.ide.model.eval.Messages;
import org.eclipse.fordiac.ide.model.eval.value.FBValue;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.variable.AbstractVariable;
import org.eclipse.fordiac.ide.model.eval.variable.ArrayVariable;
import org.eclipse.fordiac.ide.model.eval.variable.DirectlyDerivedVariable;
import org.eclipse.fordiac.ide.model.eval.variable.ElementaryVariable;
import org.eclipse.fordiac.ide.model.eval.variable.EnumVariable;
import org.eclipse.fordiac.ide.model.eval.variable.FBVariable;
import org.eclipse.fordiac.ide.model.eval.variable.GenericVariable;
import org.eclipse.fordiac.ide.model.eval.variable.StructVariable;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.eval.variable.VariableEvaluator;
import org.eclipse.fordiac.ide.model.helpers.ArraySizeHelper;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.ITypedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.value.TypedValueConverter;

public final class VariableOperations {
    public static Variable<?> newVariable(String name, INamedElement type) {
        AbstractVariable abstractVariable;
        INamedElement iNamedElement = type;
        int n = 0;
        block10: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AnyType.class, ArrayType.class, StructuredType.class, EnumeratedType.class, DirectlyDerivedType.class, AnyElementaryType.class, FBType.class}, (Object)iNamedElement, n)) {
                case 0: {
                    AnyType anyType = (AnyType)iNamedElement;
                    if (!IecTypes.GenericTypes.isAnyType((DataType)anyType)) {
                        n = 1;
                        continue block10;
                    }
                    abstractVariable = new GenericVariable(name, anyType);
                    break block10;
                }
                case 1: {
                    ArrayType arrayType = (ArrayType)iNamedElement;
                    abstractVariable = new ArrayVariable(name, arrayType);
                    break block10;
                }
                case 2: {
                    StructuredType structuredType = (StructuredType)iNamedElement;
                    abstractVariable = new StructVariable(name, structuredType);
                    break block10;
                }
                case 3: {
                    EnumeratedType enumeratedType = (EnumeratedType)iNamedElement;
                    abstractVariable = new EnumVariable(name, enumeratedType);
                    break block10;
                }
                case 4: {
                    DirectlyDerivedType directlyDerivedType = (DirectlyDerivedType)iNamedElement;
                    abstractVariable = new DirectlyDerivedVariable(name, directlyDerivedType);
                    break block10;
                }
                case 5: {
                    AnyElementaryType anyElementaryType = (AnyElementaryType)iNamedElement;
                    abstractVariable = new ElementaryVariable(name, anyElementaryType);
                    break block10;
                }
                case 6: {
                    FBType fbType = (FBType)iNamedElement;
                    abstractVariable = new FBVariable(name, fbType);
                    break block10;
                }
                case -1: {
                    throw new NullPointerException(Messages.VariableOperations_TypeMustNotBeNull);
                }
                default: {
                    throw new UnsupportedOperationException(MessageFormat.format(Messages.VariableOperations_UnsupportedType, name, type.getName()));
                }
            }
            break;
        }
        return abstractVariable;
    }

    public static Variable<?> newVariable(String name, INamedElement type, String value) {
        AbstractVariable abstractVariable;
        INamedElement iNamedElement = type;
        int n = 0;
        block10: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AnyType.class, ArrayType.class, StructuredType.class, EnumeratedType.class, DirectlyDerivedType.class, AnyElementaryType.class, FBType.class}, (Object)iNamedElement, n)) {
                case 0: {
                    AnyType anyType = (AnyType)iNamedElement;
                    if (!IecTypes.GenericTypes.isAnyType((DataType)anyType)) {
                        n = 1;
                        continue block10;
                    }
                    abstractVariable = new GenericVariable(name, anyType, value);
                    break block10;
                }
                case 1: {
                    ArrayType arrayType = (ArrayType)iNamedElement;
                    abstractVariable = new ArrayVariable(name, arrayType, value);
                    break block10;
                }
                case 2: {
                    StructuredType structuredType = (StructuredType)iNamedElement;
                    abstractVariable = new StructVariable(name, structuredType, value);
                    break block10;
                }
                case 3: {
                    EnumeratedType enumeratedType = (EnumeratedType)iNamedElement;
                    abstractVariable = new EnumVariable(name, enumeratedType, value);
                    break block10;
                }
                case 4: {
                    DirectlyDerivedType directlyDerivedType = (DirectlyDerivedType)iNamedElement;
                    abstractVariable = new DirectlyDerivedVariable(name, directlyDerivedType, value);
                    break block10;
                }
                case 5: {
                    AnyElementaryType anyElementaryType = (AnyElementaryType)iNamedElement;
                    abstractVariable = new ElementaryVariable(name, anyElementaryType, value);
                    break block10;
                }
                case 6: {
                    FBType fbType = (FBType)iNamedElement;
                    abstractVariable = new FBVariable(name, fbType, value);
                    break block10;
                }
                case -1: {
                    throw new NullPointerException(Messages.VariableOperations_TypeMustNotBeNull);
                }
                default: {
                    throw new UnsupportedOperationException(MessageFormat.format(Messages.VariableOperations_UnsupportedType, name, type.getName()));
                }
            }
            break;
        }
        return abstractVariable;
    }

    public static Variable<?> newVariable(String name, INamedElement type, Value value) {
        AbstractVariable abstractVariable;
        INamedElement iNamedElement = type;
        int n = 0;
        block10: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AnyType.class, ArrayType.class, StructuredType.class, EnumeratedType.class, DirectlyDerivedType.class, AnyElementaryType.class, FBType.class}, (Object)iNamedElement, n)) {
                case 0: {
                    AnyType anyType = (AnyType)iNamedElement;
                    if (!IecTypes.GenericTypes.isAnyType((DataType)anyType)) {
                        n = 1;
                        continue block10;
                    }
                    abstractVariable = new GenericVariable(name, anyType, value);
                    break block10;
                }
                case 1: {
                    ArrayType arrayType = (ArrayType)iNamedElement;
                    abstractVariable = new ArrayVariable(name, arrayType, value);
                    break block10;
                }
                case 2: {
                    StructuredType structuredType = (StructuredType)iNamedElement;
                    abstractVariable = new StructVariable(name, structuredType, value);
                    break block10;
                }
                case 3: {
                    EnumeratedType enumeratedType = (EnumeratedType)iNamedElement;
                    abstractVariable = new EnumVariable(name, enumeratedType, value);
                    break block10;
                }
                case 4: {
                    DirectlyDerivedType directlyDerivedType = (DirectlyDerivedType)iNamedElement;
                    abstractVariable = new DirectlyDerivedVariable(name, directlyDerivedType, value);
                    break block10;
                }
                case 5: {
                    AnyElementaryType anyElementaryType = (AnyElementaryType)iNamedElement;
                    abstractVariable = new ElementaryVariable(name, anyElementaryType, value);
                    break block10;
                }
                case 6: {
                    FBType fbType = (FBType)iNamedElement;
                    abstractVariable = new FBVariable(name, fbType, value);
                    break block10;
                }
                case -1: {
                    throw new NullPointerException(Messages.VariableOperations_TypeMustNotBeNull);
                }
                default: {
                    throw new UnsupportedOperationException(MessageFormat.format(Messages.VariableOperations_UnsupportedType, name, type.getName()));
                }
            }
            break;
        }
        return abstractVariable;
    }

    public static Variable<?> newVariable(String name, Value value) {
        INamedElement iNamedElement = value.getType();
        int n = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataType.class}, (Object)iNamedElement, n)) {
                case 0: {
                    DataType dataType = (DataType)iNamedElement;
                    if (!IecTypes.GenericTypes.isAnyType((DataType)dataType)) {
                        n = 1;
                        continue block4;
                    }
                    throw new UnsupportedOperationException(MessageFormat.format(Messages.VariableOperations_UnsupportedType, name, value.getType().getName()));
                }
                case -1: {
                    throw new NullPointerException(Messages.VariableOperations_TypeMustNotBeNull);
                }
            }
            break;
        }
        return VariableOperations.newVariable(name, value.getType(), value);
    }

    public static Variable<?> newVariable(Variable<?> variable) {
        return VariableOperations.newVariable(variable.getName(), variable.getType(), variable.getValue());
    }

    public static Variable<?> newVariable(ITypedElement element) throws EvaluatorException {
        ITypedElement iTypedElement = element;
        Objects.requireNonNull(iTypedElement);
        ITypedElement iTypedElement2 = iTypedElement;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{VarDeclaration.class, Attribute.class, DirectlyDerivedType.class, FB.class}, (Object)iTypedElement2, n)) {
            case 0 -> {
                VarDeclaration varDeclaration = (VarDeclaration)iTypedElement2;
                yield VariableOperations.newVariable(varDeclaration);
            }
            case 1 -> {
                Attribute attribute = (Attribute)iTypedElement2;
                yield VariableOperations.newVariable(attribute);
            }
            case 2 -> {
                DirectlyDerivedType directlyDerivedType = (DirectlyDerivedType)iTypedElement2;
                yield VariableOperations.newVariable(directlyDerivedType);
            }
            case 3 -> {
                FB fb = (FB)iTypedElement2;
                yield VariableOperations.newVariable(fb);
            }
            default -> throw new UnsupportedOperationException(MessageFormat.format(Messages.VariableOperations_UnsupportedType, element.getName(), element.getType() != null ? element.getType().getName() : null));
        };
    }

    public static Variable<?> newVariable(ITypedElement element, String value) throws EvaluatorException {
        ITypedElement iTypedElement = element;
        Objects.requireNonNull(iTypedElement);
        ITypedElement iTypedElement2 = iTypedElement;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{VarDeclaration.class, Attribute.class, DirectlyDerivedType.class}, (Object)iTypedElement2, n)) {
            case 0 -> {
                VarDeclaration varDeclaration = (VarDeclaration)iTypedElement2;
                yield VariableOperations.newVariable(varDeclaration, value);
            }
            case 1 -> {
                Attribute attribute = (Attribute)iTypedElement2;
                yield VariableOperations.newVariable(attribute, value);
            }
            case 2 -> {
                DirectlyDerivedType directlyDerivedType = (DirectlyDerivedType)iTypedElement2;
                yield VariableOperations.newVariable(directlyDerivedType, value);
            }
            default -> throw new UnsupportedOperationException(MessageFormat.format(Messages.VariableOperations_UnsupportedType, element.getName(), element.getType() != null ? element.getType().getName() : null));
        };
    }

    public static Variable<?> newVariable(VarDeclaration varDeclaration) throws EvaluatorException {
        if (VariableOperations.hasInitialValue(varDeclaration)) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (EvaluatorCache cache = EvaluatorCache.open();){
                    if (VariableOperations.hasDeclaredInitialValue(varDeclaration)) {
                        return VariableOperations.newVariable(varDeclaration.getName(), VariableOperations.evaluateResultType(varDeclaration), cache.computeInitialValueIfAbsent(varDeclaration, VariableOperations::doEvaluateValue));
                    }
                    if (VariableOperations.hasInheritedInitialValue(varDeclaration)) {
                        VarDeclaration typeVariable = VariableOperations.getTypeVariable(varDeclaration);
                        return VariableOperations.newVariable(varDeclaration.getName(), VariableOperations.evaluateResultType(varDeclaration), cache.computeInitialValueIfAbsent(typeVariable, VariableOperations::doEvaluateValue));
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return VariableOperations.newVariable(varDeclaration.getName(), VariableOperations.evaluateResultType(varDeclaration));
    }

    private static Value doEvaluateValue(VarDeclaration varDeclaration) throws EvaluatorException, InterruptedException {
        Evaluator evaluator = EvaluatorFactory.createEvaluator(varDeclaration, VarDeclaration.class, null, Collections.emptySet(), null);
        if (evaluator instanceof VariableEvaluator) {
            return evaluator.evaluate();
        }
        throw new UnsupportedOperationException(Messages.VariableOperations_NoEvaluatorForVarDeclaration);
    }

    public static Variable<?> newVariable(VarDeclaration varDeclaration, String initialValue) throws EvaluatorException {
        return VariableOperations.newVariable(VariableOperations.withValue(varDeclaration, initialValue));
    }

    public static Variable<?> newVariable(VarDeclaration varDeclaration, Value value) throws EvaluatorException {
        return VariableOperations.newVariable(varDeclaration.getName(), VariableOperations.evaluateResultType(varDeclaration), value);
    }

    public static FBVariable newVariable(FB fb) {
        return new FBVariable(fb.getName(), fb.getType(), new FBValue(fb));
    }

    public static Variable<?> newVariable(Attribute attribute) throws EvaluatorException {
        if (VariableOperations.hasValue(attribute)) {
            try {
                Evaluator evaluator = EvaluatorFactory.createEvaluator(attribute, Attribute.class, null, Collections.emptySet(), null);
                if (evaluator instanceof VariableEvaluator) {
                    VariableEvaluator variableEvaluator = (VariableEvaluator)evaluator;
                    return variableEvaluator.evaluateVariable();
                }
                throw new UnsupportedOperationException(Messages.VariableOperations_NoEvaluatorForAttribute);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return VariableOperations.newVariable(attribute.getName(), (INamedElement)attribute.getType());
    }

    public static Variable<?> newVariable(Attribute attribute, String initialValue) throws EvaluatorException {
        return VariableOperations.newVariable(VariableOperations.withValue(attribute, initialValue));
    }

    public static Variable<?> newVariable(DirectlyDerivedType type) throws EvaluatorException {
        if (VariableOperations.hasInitialValue(type)) {
            try {
                Evaluator evaluator = EvaluatorFactory.createEvaluator(type, DirectlyDerivedType.class, null, Collections.emptySet(), null);
                if (evaluator instanceof VariableEvaluator) {
                    VariableEvaluator variableEvaluator = (VariableEvaluator)evaluator;
                    return variableEvaluator.evaluateVariable();
                }
                throw new UnsupportedOperationException(Messages.VariableOperations_NoEvaluatorForDirectlyDerivedType);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return VariableOperations.newVariable(type.getName(), (INamedElement)type.getBaseType());
    }

    public static Variable<?> newVariable(DirectlyDerivedType type, String initialValue) throws EvaluatorException {
        return VariableOperations.newVariable(VariableOperations.withValue((DataType)type, initialValue));
    }

    public static INamedElement evaluateResultType(VarDeclaration decl) throws EvaluatorException {
        if (decl.isArray()) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (EvaluatorCache cache = EvaluatorCache.open();){
                    return cache.computeResultTypeIfAbsent(decl, VariableOperations::doEvaluateResultType);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return decl.getType();
    }

    private static INamedElement doEvaluateResultType(VarDeclaration varDeclaration) throws EvaluatorException, InterruptedException {
        if (TypeDeclarationParser.isSimpleTypeDeclaration((String)varDeclaration.getArraySize().getValue())) {
            return TypeDeclarationParser.parseSimpleTypeDeclaration((DataType)varDeclaration.getType(), (String)varDeclaration.getArraySize().getValue());
        }
        Evaluator evaluator = EvaluatorFactory.createEvaluator(varDeclaration, VarDeclaration.class, null, Collections.emptySet(), null);
        if (evaluator instanceof VariableEvaluator) {
            VariableEvaluator variableEvaluator = (VariableEvaluator)evaluator;
            return variableEvaluator.evaluateResultType();
        }
        throw new UnsupportedOperationException(Messages.VariableOperations_NoEvaluatorForVarDeclaration);
    }

    public static String validateValue(VarDeclaration varDeclaration) {
        if (VariableOperations.isSimpleInitialValue(varDeclaration)) {
            return "";
        }
        Evaluator evaluator = EvaluatorFactory.createEvaluator(varDeclaration, VarDeclaration.class, null, Collections.emptySet(), null);
        if (evaluator instanceof VariableEvaluator) {
            try {
                evaluator.prepare();
                return "";
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }
        return Messages.VariableOperations_NoEvaluatorForVarDeclaration;
    }

    public static String validateValue(DirectlyDerivedType type) {
        if (!VariableOperations.hasInitialValue(type)) {
            return "";
        }
        Evaluator evaluator = EvaluatorFactory.createEvaluator(type, DirectlyDerivedType.class, null, Collections.emptySet(), null);
        if (evaluator instanceof VariableEvaluator) {
            try {
                evaluator.prepare();
                return "";
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }
        return Messages.VariableOperations_NoEvaluatorForDirectlyDerivedType;
    }

    public static boolean validateValue(VarDeclaration varDeclaration, List<String> errors, List<String> warnings, List<String> infos) {
        if (VariableOperations.isSimpleInitialValue(varDeclaration)) {
            return true;
        }
        Evaluator evaluator = EvaluatorFactory.createEvaluator(varDeclaration, VarDeclaration.class, null, Collections.emptySet(), null);
        if (evaluator instanceof VariableEvaluator) {
            VariableEvaluator variableEvaluator = (VariableEvaluator)evaluator;
            try {
                return variableEvaluator.validateVariable(errors, warnings, infos);
            }
            catch (EvaluatorException e) {
                errors.add(e.getMessage());
                return false;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        errors.add(Messages.VariableOperations_NoEvaluatorForVarDeclaration);
        return false;
    }

    public static boolean validateType(VarDeclaration varDeclaration, List<String> errors, List<String> warnings, List<String> infos) {
        if (!varDeclaration.isArray() || TypeDeclarationParser.isSimpleTypeDeclaration((String)varDeclaration.getArraySize().getValue())) {
            return true;
        }
        Evaluator evaluator = EvaluatorFactory.createEvaluator(varDeclaration, VarDeclaration.class, null, Collections.emptySet(), null);
        if (evaluator instanceof VariableEvaluator) {
            VariableEvaluator variableEvaluator = (VariableEvaluator)evaluator;
            try {
                return variableEvaluator.validateResultType(errors, warnings, infos);
            }
            catch (EvaluatorException e) {
                errors.add(e.getMessage());
                return false;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        errors.add(Messages.VariableOperations_NoEvaluatorForVarDeclaration);
        return false;
    }

    public static boolean validateValue(Attribute attribute, List<String> errors, List<String> warnings, List<String> infos) {
        if (VariableOperations.isSimpleAttributeValue(attribute)) {
            return true;
        }
        Evaluator evaluator = EvaluatorFactory.createEvaluator(attribute, Attribute.class, null, Collections.emptySet(), null);
        if (evaluator instanceof VariableEvaluator) {
            VariableEvaluator variableEvaluator = (VariableEvaluator)evaluator;
            try {
                return variableEvaluator.validateVariable(errors, warnings, infos);
            }
            catch (EvaluatorException e) {
                errors.add(e.getMessage());
                return false;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        errors.add(Messages.VariableOperations_NoEvaluatorForVarDeclaration);
        return false;
    }

    public static String validateValue(VarDeclaration varDeclaration, String initialValue) {
        return VariableOperations.validateValue(VariableOperations.withValue(varDeclaration, initialValue));
    }

    public static String validateValue(DataType dataType, String initialValue) {
        return VariableOperations.validateValue(VariableOperations.withValue(dataType, initialValue));
    }

    public static Value evaluateValue(DataType dataType, String initialValue) throws EvaluatorException {
        return VariableOperations.newVariable(VariableOperations.withValue(dataType, initialValue)).getValue();
    }

    public static Set<String> getDependencies(VarDeclaration varDeclaration) {
        if (!VariableOperations.isSimpleInitialValue(varDeclaration) || varDeclaration.isArray() && !TypeDeclarationParser.isSimpleTypeDeclaration((String)varDeclaration.getArraySize().getValue())) {
            Evaluator evaluator = EvaluatorFactory.createEvaluator(varDeclaration, VarDeclaration.class, null, Collections.emptySet(), null);
            if (evaluator instanceof VariableEvaluator) {
                VariableEvaluator variableEvaluator = (VariableEvaluator)evaluator;
                return variableEvaluator.getDependencies();
            }
            throw new UnsupportedOperationException(Messages.VariableOperations_NoEvaluatorForVarDeclaration);
        }
        return Set.of(PackageNameHelper.getFullTypeName((LibraryElement)varDeclaration.getType()));
    }

    public static Set<String> getDependencies(Attribute attribute) {
        if (InternalAttributeDeclarations.isInternalAttribute((Attribute)attribute)) {
            return Set.of();
        }
        if (!VariableOperations.isSimpleAttributeValue(attribute)) {
            Evaluator evaluator = EvaluatorFactory.createEvaluator(attribute, VarDeclaration.class, null, Collections.emptySet(), null);
            if (evaluator instanceof VariableEvaluator) {
                VariableEvaluator variableEvaluator = (VariableEvaluator)evaluator;
                return variableEvaluator.getDependencies();
            }
            throw new UnsupportedOperationException(Messages.VariableOperations_NoEvaluatorForVarDeclaration);
        }
        if (attribute.getAttributeDeclaration() != null) {
            return Set.of(PackageNameHelper.getFullTypeName((LibraryElement)attribute.getAttributeDeclaration()));
        }
        return Set.of(PackageNameHelper.getFullTypeName((LibraryElement)attribute.getType()));
    }

    public static Set<String> getAllDependencies(EObject object) {
        Evaluator evaluator = EvaluatorFactory.createEvaluator(object, object.eClass().getInstanceClass(), null, Collections.emptySet(), null);
        if (evaluator != null) {
            return evaluator.getDependencies();
        }
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(object.eAllContents(), 0), false).map(element -> {
            EObject eObject = element;
            Objects.requireNonNull(eObject);
            EObject eObject2 = eObject;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Attribute.class, VarDeclaration.class}, (Object)eObject2, n)) {
                case 0 -> {
                    Attribute attribute = (Attribute)eObject2;
                    yield VariableOperations.getDependencies(attribute);
                }
                case 1 -> {
                    VarDeclaration varDeclaration = (VarDeclaration)eObject2;
                    yield VariableOperations.getDependencies(varDeclaration);
                }
                default -> Collections.emptySet();
            };
        }).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public static boolean hasValue(Attribute attribute) {
        return attribute.getValue() != null && !attribute.getValue().isEmpty();
    }

    public static boolean hasInitialValue(DirectlyDerivedType type) {
        return type.getInitialValue() != null && !type.getInitialValue().isEmpty();
    }

    public static boolean hasInitialValue(VarDeclaration varDeclaration) {
        return VariableOperations.hasDeclaredInitialValue(varDeclaration) || VariableOperations.hasInheritedInitialValue(varDeclaration);
    }

    public static boolean hasDeclaredInitialValue(VarDeclaration varDeclaration) {
        return varDeclaration.getValue() != null && varDeclaration.getValue().getValue() != null && !varDeclaration.getValue().getValue().isEmpty();
    }

    public static boolean hasInheritedInitialValue(VarDeclaration varDeclaration) {
        VarDeclaration typeVariable = VariableOperations.getTypeVariable(varDeclaration);
        if (typeVariable != null) {
            return VariableOperations.hasDeclaredInitialValue(typeVariable);
        }
        return false;
    }

    public static String getInitialValue(VarDeclaration varDeclaration) {
        String declaredInitialValue = VariableOperations.getDeclaredInitialValue(varDeclaration);
        if (declaredInitialValue != null) {
            return declaredInitialValue;
        }
        return VariableOperations.getInheritedInitialValue(varDeclaration);
    }

    public static String getDeclaredInitialValue(VarDeclaration varDeclaration) {
        if (VariableOperations.hasDeclaredInitialValue(varDeclaration)) {
            return varDeclaration.getValue().getValue();
        }
        return null;
    }

    public static String getInheritedInitialValue(VarDeclaration varDeclaration) {
        VarDeclaration typeVariable = VariableOperations.getTypeVariable(varDeclaration);
        if (typeVariable != null && VariableOperations.hasDeclaredInitialValue(typeVariable)) {
            return typeVariable.getValue().getValue();
        }
        return null;
    }

    private static VarDeclaration getTypeVariable(VarDeclaration varDeclaration) {
        VarDeclaration typeVariable;
        FBType type;
        FBNetworkElement networkElement = varDeclaration.getFBNetworkElement();
        if (networkElement != null && (type = networkElement.getType()) != null && (typeVariable = type.getInterfaceList().getVariable(varDeclaration.getName())) != null) {
            return typeVariable;
        }
        return null;
    }

    private static VarDeclaration withValue(VarDeclaration varDeclaration, String valueString) {
        if (Objects.equals(valueString, VariableOperations.getDeclaredInitialValue(varDeclaration))) {
            return varDeclaration;
        }
        VarDeclaration copy = LibraryElementFactory.eINSTANCE.createVarDeclaration();
        copy.setName(varDeclaration.getName());
        copy.setType(varDeclaration.getType());
        ArraySizeHelper.setArraySize((VarDeclaration)copy, (String)ArraySizeHelper.getArraySize((IInterfaceElement)varDeclaration));
        org.eclipse.fordiac.ide.model.libraryElement.Value value = LibraryElementFactory.eINSTANCE.createValue();
        value.setValue(valueString);
        copy.setValue(value);
        if (varDeclaration.eResource() != null) {
            new ResourceImpl(varDeclaration.eResource().getURI()).getContents().add((Object)copy);
        }
        return copy;
    }

    private static Attribute withValue(Attribute attribute, String valueString) {
        if (Objects.equals(valueString, attribute.getValue())) {
            return attribute;
        }
        Attribute copy = LibraryElementFactory.eINSTANCE.createAttribute();
        copy.setName(attribute.getName());
        copy.setType(attribute.getType());
        copy.setAttributeDeclaration(attribute.getAttributeDeclaration());
        copy.setValue(valueString);
        if (attribute.eResource() != null) {
            new ResourceImpl(attribute.eResource().getURI()).getContents().add((Object)copy);
        }
        return copy;
    }

    private static DirectlyDerivedType withValue(DataType type, String valueString) {
        DirectlyDerivedType directlyDerivedType;
        if (type instanceof DirectlyDerivedType && Objects.equals(valueString, (directlyDerivedType = (DirectlyDerivedType)type).getInitialValue())) {
            return directlyDerivedType;
        }
        DirectlyDerivedType copy = DataFactory.eINSTANCE.createDirectlyDerivedType();
        copy.setName(type.getName());
        copy.setBaseType(type);
        copy.setInitialValue(valueString);
        if (type instanceof AnyDerivedType && type.eResource() != null) {
            new ResourceImpl(type.eResource().getURI()).getContents().add((Object)copy);
        }
        return copy;
    }

    private static boolean isSimpleInitialValue(VarDeclaration varDeclaration) {
        if (varDeclaration.isArray()) {
            return false;
        }
        if (VariableOperations.hasDeclaredInitialValue(varDeclaration)) {
            try {
                new TypedValueConverter(varDeclaration.getType(), true).toValue(VariableOperations.getDeclaredInitialValue(varDeclaration));
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    private static boolean isSimpleAttributeValue(Attribute attribute) {
        DataType dataType;
        if (VariableOperations.hasValue(attribute) && (dataType = attribute.getType()) instanceof AnyType) {
            AnyType type = (AnyType)dataType;
            try {
                new TypedValueConverter((DataType)type, true).toValue(attribute.getValue());
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    private VariableOperations() {
        throw new UnsupportedOperationException();
    }
}

