/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.merge;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.NoMergeBaseException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;

public class RecursiveMerger
extends ResolveMerger {
    public final int MAX_BASES = 200;

    protected RecursiveMerger(Repository local, boolean inCore) {
        super(local, inCore);
    }

    protected RecursiveMerger(Repository local) {
        this(local, false);
    }

    protected RecursiveMerger(ObjectInserter inserter, Config config) {
        super(inserter, config);
    }

    @Override
    protected RevCommit getBaseCommit(RevCommit a, RevCommit b) throws IncorrectObjectTypeException, IOException {
        return this.getBaseCommit(a, b, 0);
    }

    protected RevCommit getBaseCommit(RevCommit a, RevCommit b, int callDepth) throws IOException {
        RevCommit c;
        ArrayList<RevCommit> baseCommits = new ArrayList<RevCommit>();
        this.walk.reset();
        this.walk.setRevFilter(RevFilter.MERGE_BASE);
        this.walk.markStart(a);
        this.walk.markStart(b);
        while ((c = this.walk.next()) != null) {
            baseCommits.add(c);
        }
        if (baseCommits.isEmpty()) {
            return null;
        }
        if (baseCommits.size() == 1) {
            return (RevCommit)baseCommits.get(0);
        }
        if (baseCommits.size() >= 200) {
            throw new NoMergeBaseException(NoMergeBaseException.MergeBaseFailureReason.TOO_MANY_MERGE_BASES, MessageFormat.format(JGitText.get().mergeRecursiveTooManyMergeBasesFor, 200, a.name(), b.name(), baseCommits.size()));
        }
        RevCommit currentBase = (RevCommit)baseCommits.get(0);
        DirCache oldDircache = this.dircache;
        boolean oldIncore = this.inCore;
        WorkingTreeIterator oldWTreeIt = this.workingTreeIterator;
        this.workingTreeIterator = null;
        try {
            this.dircache = DirCache.read(this.reader, currentBase.getTree());
            this.inCore = true;
            ArrayList<RevCommit> parents = new ArrayList<RevCommit>();
            parents.add(currentBase);
            int commitIdx = 1;
            while (commitIdx < baseCommits.size()) {
                AbstractTreeIterator bcTree;
                RevCommit nextBase = (RevCommit)baseCommits.get(commitIdx);
                if (commitIdx >= 200) {
                    throw new NoMergeBaseException(NoMergeBaseException.MergeBaseFailureReason.TOO_MANY_MERGE_BASES, MessageFormat.format(JGitText.get().mergeRecursiveTooManyMergeBasesFor, 200, a.name(), b.name(), baseCommits.size()));
                }
                parents.add(nextBase);
                RevCommit bc = this.getBaseCommit(currentBase, nextBase, callDepth + 1);
                AbstractTreeIterator abstractTreeIterator = bcTree = bc == null ? new EmptyTreeIterator() : this.openTree(bc.getTree());
                if (!this.mergeTrees(bcTree, currentBase.getTree(), nextBase.getTree(), true)) {
                    String failedPaths = this.failingPathsMessage();
                    throw new NoMergeBaseException(NoMergeBaseException.MergeBaseFailureReason.CONFLICTS_DURING_MERGE_BASE_CALCULATION, MessageFormat.format(JGitText.get().mergeRecursiveConflictsWhenMergingCommonAncestors, currentBase.getName(), nextBase.getName(), failedPaths));
                }
                currentBase = this.createCommitForTree(this.resultTree, parents);
                ++commitIdx;
            }
        }
        finally {
            this.inCore = oldIncore;
            this.dircache = oldDircache;
            this.workingTreeIterator = oldWTreeIt;
            this.unmergedPaths.clear();
            this.mergeResults.clear();
            this.failingPaths.clear();
        }
        return currentBase;
    }

    private RevCommit createCommitForTree(ObjectId tree, List<RevCommit> parents) throws IOException {
        CommitBuilder c = new CommitBuilder();
        c.setTreeId(tree);
        c.setParentIds(parents);
        c.setAuthor(RecursiveMerger.mockAuthor(parents));
        c.setCommitter(c.getAuthor());
        return RevCommit.parse(this.walk, c.build());
    }

    private static PersonIdent mockAuthor(List<RevCommit> parents) {
        String name = RecursiveMerger.class.getSimpleName();
        int time = 0;
        for (RevCommit p : parents) {
            time = Math.max(time, p.getCommitTime());
        }
        return new PersonIdent(name, name + "@JGit", new Date((long)(time + 1) * 1000L), TimeZone.getTimeZone("GMT+0000"));
    }

    private String failingPathsMessage() {
        int max = 25;
        String failedPaths = this.failingPaths.entrySet().stream().limit(max).map(entry -> (String)entry.getKey() + ":" + String.valueOf(entry.getValue())).collect(Collectors.joining("\n"));
        if (this.failingPaths.size() > max) {
            failedPaths = String.format("%s\n... (%s failing paths omitted)", failedPaths, this.failingPaths.size() - max);
        }
        return failedPaths;
    }
}

