/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.btree;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.birt.core.btree.BTree;
import org.eclipse.birt.core.btree.BTreeValue;
import org.eclipse.birt.core.btree.BTreeValues;
import org.eclipse.birt.core.btree.LeafEntry;
import org.eclipse.birt.core.btree.LeafNode;
import org.eclipse.birt.core.i18n.CoreMessages;

public class BTreeCursor<K, V> {
    protected BTree<K, V> btree;
    protected LeafEntry<K, V> entry;
    protected boolean beforeFirst;

    BTreeCursor(BTree<K, V> btree) {
        this.btree = btree;
        this.entry = null;
        this.beforeFirst = true;
    }

    public int getTotalKeys() {
        return this.btree.getTotalKeys();
    }

    public int getTotalValues() {
        return this.btree.getTotalValues();
    }

    public void beforeFirst() throws IOException {
        if (this.entry != null) {
            this.btree.unlockEntry(this.entry);
        }
        this.entry = null;
        this.beforeFirst = true;
    }

    public void afterLast() throws IOException {
        if (this.entry != null) {
            this.btree.unlockEntry(this.entry);
        }
        this.entry = null;
        this.beforeFirst = false;
    }

    public boolean isBeforeFirst() throws IOException {
        if (this.entry == null) {
            return this.beforeFirst;
        }
        return false;
    }

    public boolean isAfterLast() throws IOException {
        if (this.entry == null) {
            return !this.beforeFirst;
        }
        return false;
    }

    public boolean first() throws IOException {
        LeafEntry<K, V> tgtEntry = this.btree.getFirstEntry();
        if (tgtEntry != null) {
            this.btree.lockEntry(tgtEntry);
            if (this.entry != null) {
                this.btree.unlockEntry(this.entry);
            }
            this.entry = tgtEntry;
            return true;
        }
        this.entry = null;
        this.beforeFirst = true;
        return false;
    }

    public boolean last() throws IOException {
        LeafEntry<K, V> tgtEntry = this.btree.getLastEntry();
        if (tgtEntry != null) {
            this.btree.lockEntry(tgtEntry);
            if (this.entry != null) {
                this.btree.unlockEntry(this.entry);
            } else {
                this.beforeFirst = false;
            }
            this.entry = tgtEntry;
            return true;
        }
        this.entry = null;
        this.beforeFirst = false;
        return false;
    }

    public boolean moveTo(K key) throws IOException {
        LeafEntry<K, V> tgtEntry = this.btree.findEntry(key);
        if (tgtEntry != null) {
            this.btree.lockEntry(tgtEntry);
            if (this.entry != null) {
                this.btree.unlockEntry(this.entry);
            }
            this.entry = tgtEntry;
            K tgtKey = this.btree.getKey(tgtEntry.getKey());
            return key.equals(tgtKey);
        }
        if (this.entry != null) {
            this.btree.unlockEntry(this.entry);
            this.entry = null;
        }
        this.beforeFirst = true;
        return false;
    }

    private LeafEntry<K, V> getPrevEntry(LeafEntry<K, V> entry) throws IOException {
        LeafEntry<K, V> prevEntry = entry.getPrev();
        if (prevEntry != null) {
            return prevEntry;
        }
        int prevNodeId = entry.getNode().getPrevNodeId();
        if (prevNodeId != -1) {
            LeafNode prevNode = (LeafNode)this.btree.loadBTreeNode(prevNodeId);
            try {
                LeafEntry leafEntry = prevNode.getLastEntry();
                return leafEntry;
            }
            finally {
                prevNode.unlock();
            }
        }
        return null;
    }

    private LeafEntry<K, V> getNextEntry(LeafEntry<K, V> entry) throws IOException {
        LeafEntry<K, V> nextEntry = entry.getNext();
        if (nextEntry != null) {
            return nextEntry;
        }
        int nextNodeId = entry.getNode().getNextNodeId();
        if (nextNodeId != -1) {
            LeafNode nextNode = (LeafNode)this.btree.loadBTreeNode(nextNodeId);
            try {
                LeafEntry leafEntry = nextNode.getFirstEntry();
                return leafEntry;
            }
            finally {
                nextNode.unlock();
            }
        }
        return null;
    }

    public boolean previous() throws IOException {
        if (this.entry == null) {
            if (!this.beforeFirst) {
                if (this.last()) {
                    return true;
                }
                this.beforeFirst = true;
            }
            return false;
        }
        LeafEntry<K, V> tgtEntry = this.getPrevEntry(this.entry);
        if (tgtEntry != null) {
            this.btree.lockEntry(tgtEntry);
            this.btree.unlockEntry(this.entry);
            this.entry = tgtEntry;
            return true;
        }
        this.btree.unlockEntry(this.entry);
        this.entry = null;
        this.beforeFirst = true;
        return false;
    }

    public boolean next() throws IOException {
        if (this.entry == null) {
            if (this.beforeFirst) {
                if (this.first()) {
                    return true;
                }
                this.beforeFirst = false;
            }
            return false;
        }
        LeafEntry<K, V> tgtEntry = this.getNextEntry(this.entry);
        if (tgtEntry != null) {
            this.btree.lockEntry(tgtEntry);
            this.btree.unlockEntry(this.entry);
            this.entry = tgtEntry;
            return true;
        }
        this.btree.unlockEntry(this.entry);
        this.entry = null;
        this.beforeFirst = false;
        return false;
    }

    public K getKey() throws IOException {
        if (this.entry == null) {
            throw new IOException(CoreMessages.getString("error.InvalidCursor"));
        }
        return this.btree.getKey(this.entry.getKey());
    }

    public V getValue() throws IOException {
        if (this.entry == null) {
            throw new IOException(CoreMessages.getString("error.InvalidCursor"));
        }
        BTreeValues<V> values = this.entry.getValues();
        BTreeValues.Value<V> value = values.getFirstValue();
        BTreeValue<V> v = value.getValue();
        return this.btree.getValue(v);
    }

    public Collection<V> getValues() throws IOException {
        if (this.entry == null) {
            throw new IOException(CoreMessages.getString("error.InvalidCursor"));
        }
        BTreeValues<V> values = this.entry.getValues();
        ArrayList<V> list = new ArrayList<V>(values.getValueCount());
        BTreeValues.Value<V> value = values.getFirstValue();
        while (value != null) {
            BTreeValue<V> bv = value.getValue();
            V v = this.btree.getValue(bv);
            list.add(v);
            value = value.getNext();
        }
        return list;
    }

    public void insert(K key, V value) throws IOException {
        LeafEntry<K, V> tgtEntry = this.btree.insertEntry(key, value);
        this.btree.lockEntry(tgtEntry);
        if (this.entry != null) {
            this.btree.unlockEntry(this.entry);
        }
        this.entry = tgtEntry;
    }

    public void insert(K key, V[] values) throws IOException {
        LeafEntry<K, V> tgtEntry = this.btree.insertEntry(key, values);
        this.btree.lockEntry(tgtEntry);
        if (this.entry != null) {
            this.btree.unlockEntry(this.entry);
        }
        this.entry = tgtEntry;
    }

    public void remove() throws IOException {
        throw new UnsupportedOperationException("remove");
    }

    public void setValue(V value) throws IOException {
        throw new UnsupportedOperationException("setValue(V)");
    }

    public void close() {
        if (this.entry != null) {
            this.btree.unlockEntry(this.entry);
            this.entry = null;
        }
    }
}

