/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.btree;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.birt.core.btree.BTreeConstants;
import org.eclipse.birt.core.btree.BTreeUtils;
import org.eclipse.birt.core.btree.NodeFile;

public class NodeInputStream
extends InputStream
implements BTreeConstants {
    private NodeFile file;
    private int offset;
    private byte[] bytes;
    private int blockCount;
    private int[] usedBlocks;

    public NodeInputStream(NodeFile file, int blockId) throws IOException {
        this.file = file;
        this.usedBlocks = new int[4];
        this.usedBlocks[0] = blockId;
        this.blockCount = 0;
        this.bytes = new byte[4096];
        this.offset = 4096;
    }

    @Override
    public int read() throws IOException {
        int remainSize = this.available();
        if (remainSize > 0) {
            return this.bytes[this.offset++] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int readSize = 0;
        while (readSize < len) {
            int copySize = len - readSize;
            int remainSize = this.available();
            if (remainSize == 0) break;
            if (copySize > remainSize) {
                copySize = remainSize;
            }
            System.arraycopy(this.bytes, this.offset, b, off, copySize);
            this.offset += copySize;
            off += copySize;
            readSize += copySize;
        }
        return readSize;
    }

    @Override
    public int available() throws IOException {
        if (this.offset < 4096) {
            return 4096 - this.offset;
        }
        int blockId = this.usedBlocks[this.blockCount];
        if (blockId != -1) {
            this.file.readBlock(blockId, this.bytes);
            this.offset = 4;
            ++this.blockCount;
            int nextBlockId = BTreeUtils.bytesToInteger(this.bytes);
            if (this.blockCount >= this.usedBlocks.length) {
                int[] blocks = new int[this.usedBlocks.length * 2];
                System.arraycopy(this.usedBlocks, 0, blocks, 0, this.usedBlocks.length);
                this.usedBlocks = blocks;
            }
            this.usedBlocks[this.blockCount] = nextBlockId;
            return 4096 - this.offset;
        }
        return 0;
    }

    public int[] getUsedBlocks() {
        int[] blocks = new int[this.blockCount];
        System.arraycopy(this.usedBlocks, 0, blocks, 0, this.blockCount);
        return blocks;
    }
}

