/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.project.generatortasks.restadapter;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Iterator;
import org.eclipse.comma.project.generatortasks.restadapter.VectorDescriptor;
import org.eclipse.comma.signature.interfaceSignature.Signature;
import org.eclipse.comma.types.types.EnumTypeDecl;
import org.eclipse.comma.types.types.RecordField;
import org.eclipse.comma.types.types.RecordTypeDecl;
import org.eclipse.comma.types.types.SimpleTypeDecl;
import org.eclipse.comma.types.types.Type;
import org.eclipse.comma.types.types.TypeDecl;
import org.eclipse.comma.types.types.TypeReference;
import org.eclipse.comma.types.types.VectorTypeConstructor;
import org.eclipse.comma.types.types.VectorTypeDecl;
import org.eclipse.comma.types.utilities.TypeUtilities;

public class SUTToCommaTrace {
    public static JsonObject convertInt(JsonElement value) {
        int number = value.getAsInt();
        JsonObject result = new JsonObject();
        result.addProperty("type", "int");
        result.addProperty("value", (Number)number);
        return result;
    }

    public static JsonObject convertString(JsonElement value) {
        JsonObject result = new JsonObject();
        result.addProperty("type", "string");
        result.addProperty("value", value.getAsString());
        return result;
    }

    public static JsonObject convertReal(JsonElement value) {
        double number = value.getAsDouble();
        JsonObject result = new JsonObject();
        result.addProperty("type", "real");
        result.addProperty("value", (Number)number);
        return result;
    }

    public static JsonObject convertBool(JsonElement value) {
        JsonObject result = new JsonObject();
        result.addProperty("type", "bool");
        result.addProperty("value", Boolean.valueOf(value.getAsBoolean()));
        return result;
    }

    public static JsonObject convertEnum(String typeName, JsonElement value) {
        JsonObject result = new JsonObject();
        result.addProperty("type", "enum");
        result.addProperty("value", String.valueOf(typeName) + "::" + value.getAsString());
        return result;
    }

    public static JsonObject convertRecord(RecordTypeDecl typeDecl, JsonElement value) {
        JsonObject result = new JsonObject();
        result.addProperty("type", "record");
        String typeName = typeDecl.getName();
        if (typeDecl.eContainer() instanceof Signature) {
            typeName = String.valueOf(((Signature)typeDecl.eContainer()).getName()) + "_" + typeName;
        }
        result.addProperty("record", typeName);
        SUTToCommaTrace.convertRecordValue(typeDecl, value.getAsJsonObject());
        result.add("value", value);
        return result;
    }

    private static void convertRecordValue(RecordTypeDecl recordType, JsonObject value) {
        for (RecordField f : TypeUtilities.getAllFields((RecordTypeDecl)recordType)) {
            VectorDescriptor descr;
            Type fieldType = f.getType();
            if (fieldType instanceof TypeReference && ((TypeReference)fieldType).getType() instanceof EnumTypeDecl) {
                value.addProperty(f.getName(), String.valueOf(((TypeReference)fieldType).getType().getName()) + "::" + value.get(f.getName()).getAsString());
            }
            if (fieldType instanceof VectorTypeConstructor) {
                descr = VectorDescriptor.getDescriptor((VectorTypeConstructor)fieldType);
                value.add(f.getName(), (JsonElement)SUTToCommaTrace.convertVector(descr.elementType, descr.dimensions, value.get(f.getName())));
            }
            if (fieldType instanceof TypeReference && ((TypeReference)fieldType).getType() instanceof RecordTypeDecl) {
                value.add(f.getName(), (JsonElement)SUTToCommaTrace.convertRecord((RecordTypeDecl)((TypeReference)fieldType).getType(), (JsonElement)value.get(f.getName()).getAsJsonObject()));
            }
            if (!(fieldType instanceof TypeReference) || !(((TypeReference)fieldType).getType() instanceof VectorTypeDecl)) continue;
            descr = VectorDescriptor.getDescriptor(((VectorTypeDecl)((TypeReference)fieldType).getType()).getConstructor());
            value.add(f.getName(), (JsonElement)SUTToCommaTrace.convertVector(descr.elementType, descr.dimensions, value.get(f.getName())));
        }
    }

    public static JsonObject convertVector(TypeDecl type, int dimension, JsonElement value) {
        Iterator elements;
        JsonArray newElements;
        JsonObject result = new JsonObject();
        result.addProperty("type", "vector");
        if (dimension > 1) {
            result.addProperty("typeElem", "vector");
            JsonArray newElements2 = new JsonArray();
            Iterator elements2 = value.getAsJsonArray().iterator();
            while (elements2.hasNext()) {
                newElements2.add((JsonElement)SUTToCommaTrace.convertVector(type, dimension - 1, (JsonElement)elements2.next()));
            }
            result.add("value", (JsonElement)newElements2);
            return result;
        }
        if (type instanceof SimpleTypeDecl) {
            String typeName = type.getName();
            if (((SimpleTypeDecl)type).getBase() != null) {
                typeName = ((SimpleTypeDecl)type).getBase().getName();
            }
            result.addProperty("typeElem", typeName);
            result.add("value", value);
        }
        if (type instanceof EnumTypeDecl) {
            result.addProperty("typeElem", "enum");
            newElements = new JsonArray();
            elements = value.getAsJsonArray().iterator();
            while (elements.hasNext()) {
                newElements.add(String.valueOf(type.getName()) + "::" + elements.next());
            }
            result.add("value", (JsonElement)newElements);
        }
        if (type instanceof RecordTypeDecl) {
            result.addProperty("typeElem", "record");
            newElements = new JsonArray();
            elements = value.getAsJsonArray().iterator();
            while (elements.hasNext()) {
                newElements.add((JsonElement)SUTToCommaTrace.convertRecord((RecordTypeDecl)type, (JsonElement)elements.next()));
            }
            result.add("value", (JsonElement)newElements);
        }
        return result;
    }
}

