/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.helpgenerator.docletapi;

import com.sun.source.doctree.DeprecatedTree;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.ParamTree;
import com.sun.source.doctree.ReturnTree;
import com.sun.source.doctree.ThrowsTree;
import com.sun.source.doctree.UnknownBlockTagTree;
import com.sun.source.util.SimpleDocTreeVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementScanner9;
import jdk.javadoc.doclet.DocletEnvironment;
import org.eclipse.ease.helpgenerator.model.AbstractClassModel;
import org.eclipse.ease.helpgenerator.model.Description;
import org.eclipse.ease.helpgenerator.model.ExceptionValue;
import org.eclipse.ease.helpgenerator.model.Field;
import org.eclipse.ease.helpgenerator.model.Method;
import org.eclipse.ease.helpgenerator.model.Parameter;
import org.eclipse.ease.helpgenerator.model.ReturnValue;
import org.eclipse.ease.helpgenerator.model.ScriptExample;
import org.eclipse.ease.modules.ScriptParameter;
import org.eclipse.ease.modules.WrapToScript;

public class Jep221ClassModel
extends AbstractClassModel {
    private final DocletEnvironment fEnvironment;
    private final TypeElement fTypeElement;

    public Jep221ClassModel(DocletEnvironment environment, TypeElement typeElement) {
        this.fEnvironment = environment;
        this.fTypeElement = typeElement;
    }

    @Override
    public void populateModel() {
        this.setClassName(this.fTypeElement.getQualifiedName().toString());
        this.setClassDocumentation(new Description(this.getCommentFor(this.fTypeElement)));
        DocCommentTree tree = this.fEnvironment.getDocTrees().getDocCommentTree(this.fTypeElement);
        String deprecationText = (String)new DeprecationMessageScanner().visit(tree, null);
        if (deprecationText == null && this.fTypeElement.getAnnotation(Deprecated.class) != null) {
            deprecationText = "Module deprecated";
        }
        this.setDeprecationMessage(deprecationText);
        boolean hasAnnotation = this.hasWrapToScriptAnnotation();
        this.setExportedFields((List)new FieldScanner().scan(this.fTypeElement, Boolean.valueOf(hasAnnotation)));
        this.setExportedMethods((List)new MethodScanner().scan(this.fTypeElement, Boolean.valueOf(hasAnnotation)));
        this.setImportedClasses(Collections.emptyList());
    }

    private String getCommentFor(Element element) {
        DocCommentTree elementComment = this.fEnvironment.getDocTrees().getDocCommentTree(element);
        if (elementComment != null) {
            List<? extends DocTree> body = elementComment.getFullBody();
            return body.stream().map(e -> e.toString()).collect(Collectors.joining());
        }
        return null;
    }

    private boolean hasWrapToScriptAnnotation() {
        return (Boolean)new WrapToScriptScanner().scan(this.fTypeElement);
    }

    private class DeprecationMessageScanner
    extends SimpleDocTreeVisitor<String, String> {
        String fDocumentation;

        private DeprecationMessageScanner() {
        }

        @Override
        public String visitDocComment(DocCommentTree node, String p) {
            this.visit(node.getBlockTags(), p);
            return this.fDocumentation != null ? this.fDocumentation : p;
        }

        @Override
        public String visitDeprecated(DeprecatedTree node, String p) {
            List<? extends DocTree> body = node.getBody();
            this.fDocumentation = body.stream().map(e -> e.toString()).collect(Collectors.joining());
            return this.fDocumentation;
        }
    }

    private class ReturnTypeMessageScanner
    extends SimpleDocTreeVisitor<String, Void> {
        String fDocumentation;

        private ReturnTypeMessageScanner() {
        }

        @Override
        public String visitDocComment(DocCommentTree node, Void p) {
            this.visit(node.getBlockTags(), p);
            return this.fDocumentation;
        }

        @Override
        public String visitReturn(ReturnTree node, Void p) {
            List<? extends DocTree> body = node.getDescription();
            this.fDocumentation = body.stream().map(e -> e.toString()).collect(Collectors.joining());
            return this.fDocumentation;
        }
    }

    private class ExceptionMessageScanner
    extends SimpleDocTreeVisitor<String, String> {
        private String fComment;

        private ExceptionMessageScanner() {
        }

        @Override
        public String visitDocComment(DocCommentTree node, String p) {
            this.visit(node.getBlockTags(), p);
            return this.fComment;
        }

        @Override
        public String visitThrows(ThrowsTree node, String p) {
            List<? extends DocTree> body = node.getDescription();
            if (p.endsWith(node.getExceptionName().toString())) {
                this.fComment = body.stream().map(e -> e.toString()).collect(Collectors.joining());
            }
            return (String)super.visitThrows(node, p);
        }
    }

    private class ParameterCommentScanner
    extends SimpleDocTreeVisitor<String, String> {
        private String fComment;

        private ParameterCommentScanner() {
        }

        @Override
        public String visitDocComment(DocCommentTree node, String p) {
            this.visit(node.getBlockTags(), p);
            return this.fComment;
        }

        @Override
        public String visitParam(ParamTree node, String p) {
            List<? extends DocTree> body = node.getDescription();
            if (p.equals(node.getName().toString())) {
                this.fComment = body.stream().map(e -> e.toString()).collect(Collectors.joining());
            }
            return (String)super.visitParam(node, p);
        }
    }

    private class ScriptExampleScanner
    extends SimpleDocTreeVisitor<List<ScriptExample>, Void> {
        private final List<ScriptExample> fScriptExamples = new ArrayList<ScriptExample>();

        private ScriptExampleScanner() {
        }

        @Override
        public List<ScriptExample> visitDocComment(DocCommentTree node, Void p) {
            this.visit(node.getBlockTags(), p);
            return this.fScriptExamples;
        }

        @Override
        public List<ScriptExample> visitUnknownBlockTag(UnknownBlockTagTree node, Void p) {
            String content = node.getContent().stream().map(e -> e.toString()).collect(Collectors.joining());
            this.fScriptExamples.add(new ScriptExample(content));
            return this.fScriptExamples;
        }
    }

    private class MethodScanner
    extends RecursiveScanner<List<Method>, Boolean> {
        private final List<Method> fMethods;

        private MethodScanner() {
            this.fMethods = new ArrayList<Method>();
        }

        @Override
        public List<Method> visitExecutable(ExecutableElement e, Boolean hasWrapToScriptAnnotation) {
            Method registeredMethod = this.findRegisteredMethod(e.getSimpleName().toString());
            WrapToScript wrapAnnotation = e.getAnnotation(WrapToScript.class);
            if ((!hasWrapToScriptAnnotation.booleanValue() || wrapAnnotation != null || registeredMethod != null) && e.getModifiers().contains((Object)Modifier.PUBLIC)) {
                DocCommentTree tree = Jep221ClassModel.this.fEnvironment.getDocTrees().getDocCommentTree(e);
                String deprecationText = (String)new DeprecationMessageScanner().visit(tree, Jep221ClassModel.this.getDeprecationMessage());
                if (deprecationText == null && e.getAnnotation(Deprecated.class) != null) {
                    deprecationText = "";
                }
                HashSet<String> aliases = new HashSet<String>();
                if (wrapAnnotation != null) {
                    String candidates = wrapAnnotation.alias();
                    for (String token : candidates.split("[,;]")) {
                        if (token.trim().isEmpty()) continue;
                        aliases.add(token.trim());
                    }
                }
                ReturnValue returnValue = new ReturnValue(e.getReturnType().toString(), (String)new ReturnTypeMessageScanner().visit(tree, null));
                List<Parameter> parameters = e.getParameters().stream().map(param -> {
                    ScriptParameter scriptParameter = param.getAnnotation(ScriptParameter.class);
                    String defaultValue = scriptParameter != null ? scriptParameter.defaultValue() : null;
                    String comment = (String)new ParameterCommentScanner().visit(tree, param.getSimpleName().toString());
                    return new Parameter(param.getSimpleName().toString(), param.asType().toString(), comment, defaultValue);
                }).collect(Collectors.toList());
                List<ExceptionValue> exceptions = e.getThrownTypes().stream().map(type -> new ExceptionValue(type.toString(), (String)new ExceptionMessageScanner().visit(tree, type.toString()))).collect(Collectors.toList());
                List examples = (List)new ScriptExampleScanner().visit(tree, null);
                this.addMethod(new Method(e.getSimpleName().toString(), Jep221ClassModel.this.getCommentFor(e), deprecationText, aliases, returnValue, parameters, exceptions, examples));
            }
            return this.getResult();
        }

        private Method findRegisteredMethod(String methodName) {
            return this.fMethods.stream().filter(m -> methodName.equals(m.getName())).findFirst().orElse(null);
        }

        private void addMethod(Method method) {
            Method existingMethod = this.findRegisteredMethod(method.getName());
            if (existingMethod != null) {
                existingMethod.fetchDetailsFrom(method);
            } else {
                this.fMethods.add(method);
            }
        }

        @Override
        protected List<Method> getResult() {
            return this.fMethods;
        }
    }

    private class FieldScanner
    extends RecursiveScanner<List<Field>, Boolean> {
        private final List<Field> fFields;

        private FieldScanner() {
            this.fFields = new ArrayList<Field>();
        }

        @Override
        public List<Field> visitVariable(VariableElement e, Boolean p) {
            if ((!p.booleanValue() || e.getAnnotation(WrapToScript.class) != null) && e.getModifiers().contains((Object)Modifier.STATIC) && e.getModifiers().contains((Object)Modifier.PUBLIC) && e.getModifiers().contains((Object)Modifier.FINAL)) {
                DocCommentTree tree = Jep221ClassModel.this.fEnvironment.getDocTrees().getDocCommentTree(e);
                String deprecationText = (String)new DeprecationMessageScanner().visit(tree, Jep221ClassModel.this.getDeprecationMessage());
                if (deprecationText == null && e.getAnnotation(Deprecated.class) != null) {
                    deprecationText = "";
                }
                this.fFields.add(new Field(e.getSimpleName().toString(), Jep221ClassModel.this.getCommentFor(e), deprecationText));
            }
            return (List)super.visitVariable(e, p);
        }

        @Override
        protected List<Field> getResult() {
            return this.fFields;
        }
    }

    private class WrapToScriptScanner
    extends RecursiveScanner<Boolean, Void> {
        private boolean fHasAnnotation;

        private WrapToScriptScanner() {
            this.fHasAnnotation = false;
        }

        @Override
        public Boolean visitExecutable(ExecutableElement e, Void p) {
            WrapToScript annotation = e.getAnnotation(WrapToScript.class);
            this.fHasAnnotation |= annotation != null;
            return this.getResult();
        }

        @Override
        public Boolean visitVariable(VariableElement e, Void p) {
            WrapToScript annotation = e.getAnnotation(WrapToScript.class);
            this.fHasAnnotation |= annotation != null;
            return this.getResult();
        }

        @Override
        protected Boolean getResult() {
            return this.fHasAnnotation;
        }
    }

    private abstract class RecursiveScanner<R, P>
    extends ElementScanner9<R, P> {
        private final List<String> fScannedElementsCache = new ArrayList<String>();

        private RecursiveScanner() {
        }

        @Override
        public R scan(Element e, P p) {
            super.scan(e, p);
            if (this.needsScanning(e)) {
                this.addToScanCache((TypeElement)e);
                for (TypeMirror typeMirror : ((TypeElement)e).getInterfaces()) {
                    if (!(typeMirror instanceof DeclaredType)) continue;
                    this.scan(((DeclaredType)typeMirror).asElement(), p);
                }
                TypeMirror superclass = ((TypeElement)e).getSuperclass();
                if (superclass instanceof DeclaredType) {
                    this.scan(((DeclaredType)superclass).asElement(), p);
                }
            }
            return this.getResult();
        }

        private boolean needsScanning(Element e) {
            return e instanceof TypeElement && !this.isContainedInScanCache((TypeElement)e);
        }

        private void addToScanCache(TypeElement classSymbol) {
            this.fScannedElementsCache.add(classSymbol.getQualifiedName().toString());
        }

        private boolean isContainedInScanCache(TypeElement classSymbol) {
            return this.fScannedElementsCache.contains(classSymbol.getQualifiedName().toString());
        }

        protected abstract R getResult();
    }
}

