/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.shoal.gms.client;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.shoal.gms.api.core.ActionException;
import org.glassfish.shoal.gms.api.core.CallBack;
import org.glassfish.shoal.gms.api.core.MessageAction;
import org.glassfish.shoal.gms.api.core.Signal;
import org.glassfish.shoal.gms.api.core.SignalAcquireException;
import org.glassfish.shoal.gms.api.core.SignalReleaseException;
import org.glassfish.shoal.gms.logging.GMSLogDomain;

public class MessageActionImpl
implements MessageAction {
    private Logger logger = GMSLogDomain.getLogger("ShoalLogger");
    private CallBack callback;

    public MessageActionImpl(CallBack callback) {
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeSignal(Signal signal) throws ActionException {
        boolean signalAcquired = false;
        try {
            signal.acquire();
            signalAcquired = true;
            this.processMessage(signal);
        }
        catch (SignalAcquireException e) {
            this.logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        finally {
            if (signalAcquired) {
                try {
                    signal.release();
                }
                catch (SignalReleaseException e) {
                    this.logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
            }
        }
    }

    private void processMessage(Signal signal) throws ActionException {
        try {
            this.callback.processNotification(signal);
        }
        catch (Throwable t) {
            String callbackClassName = this.callback == null ? "<null>" : this.callback.getClass().getName();
            this.logger.log(Level.WARNING, "msg.action.unhandled.exception", new Object[]{t.getClass().getName(), callbackClassName});
            ActionException ae = new ActionException("unhandled exception processing signal " + signal.toString());
            ae.initCause(t);
            throw ae;
        }
    }
}

