/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resources.admin.cli;

import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import jakarta.resource.ResourceException;
import java.beans.PropertyVetoException;
import java.util.Properties;
import org.glassfish.api.I18n;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.resourcebase.resources.admin.cli.ResourceUtil;
import org.glassfish.resourcebase.resources.api.ResourceStatus;
import org.glassfish.resourcebase.resources.util.BindableResourcesHelper;
import org.glassfish.resources.admin.cli.ResourceManager;
import org.glassfish.resources.api.ResourceAttributes;
import org.glassfish.resources.config.ExternalJndiResource;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="external-jndi-resource")
@PerLookup
@I18n(value="create.jndi.resource")
public class JndiResourceManager
implements ResourceManager {
    private static final LocalStringManagerImpl I18N = new LocalStringManagerImpl(JndiResourceManager.class);
    private static final String DESCRIPTION = "description";
    @Inject
    private ResourceUtil resourceUtil;
    @Inject
    private BindableResourcesHelper resourcesHelper;
    private String resType;
    private String factoryClass;
    private String jndiLookupName;
    private String enabled;
    private String enabledValueForTarget;
    private String description;
    private String jndiName;

    @Override
    public String getResourceType() {
        return "external-jndi-resource";
    }

    @Override
    public ResourceStatus create(Resources resources, ResourceAttributes attributes, Properties properties, String target) throws Exception {
        this.setAttributes(attributes, target);
        ResourceStatus validationStatus = this.isValid(resources, true, target);
        if (validationStatus.getStatus() == 1) {
            return validationStatus;
        }
        try {
            SingleConfigCode configCode = param -> this.createResource((Resources)param, properties);
            ConfigSupport.apply((SingleConfigCode)configCode, (ConfigBeanProxy)resources);
            if (!"domain".equals(target)) {
                this.resourceUtil.createResourceRef(this.jndiName, this.enabledValueForTarget, target);
            }
        }
        catch (TransactionFailure tfe) {
            String msg = I18N.getLocalString("create.jndi.resource.fail", "Unable to create jndi resource {0}.", new Object[]{this.jndiName}) + " " + tfe.getLocalizedMessage();
            return new ResourceStatus(1, msg, true);
        }
        String msg = I18N.getLocalString("create.jndi.resource.success", "jndi resource {0} created.", new Object[]{this.jndiName});
        return new ResourceStatus(0, msg, true);
    }

    private ResourceStatus isValid(Resources resources, boolean validateResourceRef, String target) {
        if (this.resType == null) {
            String msg = I18N.getLocalString("create.jndi.resource.noResType", "No type defined for JNDI resource.");
            return new ResourceStatus(1, msg, true);
        }
        if (this.factoryClass == null) {
            String msg = I18N.getLocalString("create.jndi.resource.noFactoryClassName", "No Factory class name defined for JNDI resource.");
            return new ResourceStatus(1, msg, true);
        }
        if (this.jndiLookupName == null) {
            String msg = I18N.getLocalString("create.jndi.resource.noJndiLookupName", "No Jndi Lookup name defined for JNDI resource.");
            return new ResourceStatus(1, msg, true);
        }
        ResourceStatus status = this.resourcesHelper.validateBindableResourceForDuplicates(resources, this.jndiName, validateResourceRef, target, ExternalJndiResource.class);
        if (status.getStatus() == 1) {
            return status;
        }
        return status;
    }

    private void setAttributes(ResourceAttributes attributes, String target) {
        this.jndiName = attributes.getString("jndi-name");
        this.jndiLookupName = attributes.getString("jndi-lookup-name");
        this.resType = attributes.getString("res-type");
        this.factoryClass = attributes.getString("factory-class");
        this.enabled = target == null ? attributes.getString("enabled") : this.resourceUtil.computeEnabledValueForResourceBasedOnTarget(attributes.getString("enabled"), target);
        this.enabledValueForTarget = attributes.getString("enabled");
        this.description = attributes.getString(DESCRIPTION);
    }

    private Object createResource(Resources param, Properties properties) throws PropertyVetoException, TransactionFailure {
        ExternalJndiResource newResource = this.createConfigBean(param, properties);
        param.getResources().add(newResource);
        return newResource;
    }

    private ExternalJndiResource createConfigBean(Resources param, Properties properties) throws PropertyVetoException, TransactionFailure {
        ExternalJndiResource newResource = (ExternalJndiResource)param.createChild(ExternalJndiResource.class);
        newResource.setJndiName(this.jndiName);
        newResource.setFactoryClass(this.factoryClass);
        newResource.setJndiLookupName(this.jndiLookupName);
        newResource.setResType(this.resType);
        newResource.setEnabled(this.enabled);
        if (this.description != null) {
            newResource.setDescription(this.description);
        }
        if (properties != null) {
            for (String propertyName : properties.stringPropertyNames()) {
                Property prop = (Property)newResource.createChild(Property.class);
                prop.setName(propertyName);
                prop.setValue(properties.getProperty(propertyName));
                newResource.getProperty().add(prop);
            }
        }
        return newResource;
    }

    @Override
    public Resource createConfigBean(Resources resources, ResourceAttributes attributes, Properties properties, boolean validate) throws Exception {
        this.setAttributes(attributes, null);
        ResourceStatus status = validate ? this.isValid(resources, false, null) : new ResourceStatus(0, "");
        if (status.getStatus() == 0) {
            return this.createConfigBean(resources, properties);
        }
        throw new ResourceException(status.getMessage(), status.getException());
    }
}

