/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.config.metadata;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import sun.misc.Unsafe;

final class ReflectionHelper {
    private static Unsafe UNSAFE;
    private static long OFFSET;

    private ReflectionHelper() {
    }

    static Method getMethod(Class<?> c, String methodname, Class<?> ... params) {
        try {
            Method m = c.getDeclaredMethod(methodname, params);
            ReflectionHelper.setAccessible(m);
            return m;
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
    }

    private static <T extends AccessibleObject> T setAccessible(T accessor) {
        if (OFFSET != -1L) {
            UNSAFE.putBoolean(accessor, OFFSET, true);
        } else {
            accessor.setAccessible(true);
        }
        return accessor;
    }

    private static Unsafe getUnsafe() {
        try {
            Field f = (Field)PrivilegedAccessHelper.callDoPrivileged(() -> {
                try {
                    return Unsafe.class.getDeclaredField("theUnsafe");
                }
                catch (NoSuchFieldException | SecurityException ex) {
                    return null;
                }
            });
            if (f != null) {
                ReflectionHelper.setAccessible(f);
                return (Unsafe)f.get(null);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    static {
        OFFSET = -1L;
        UNSAFE = ReflectionHelper.getUnsafe();
        if (UNSAFE != null) {
            Field f = (Field)PrivilegedAccessHelper.callDoPrivileged(() -> {
                try {
                    return AccessibleObject.class.getDeclaredField("override");
                }
                catch (NoSuchFieldException | SecurityException ex) {
                    return null;
                }
            });
            if (f == null) {
                try {
                    f = dummy.class.getDeclaredField("override");
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            }
            OFFSET = UNSAFE.objectFieldOffset(f);
        }
    }

    static class dummy {
        boolean override;
        Object other;

        dummy() {
        }
    }
}

