/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.drift;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.tk.Toolkit;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import org.eclipse.fx.drift.impl.DriftDebug;
import org.eclipse.fx.drift.impl.NGDriftFXSurface;
import org.eclipse.fx.drift.internal.Log;
import org.eclipse.fx.drift.internal.ScreenObserver;
import org.eclipse.fx.drift.internal.SurfaceData;
import org.eclipse.fx.drift.internal.frontend.FrontSwapChain;
import org.eclipse.fx.drift.internal.prism.Prism;

public abstract class BaseDriftFXSurface
extends Node {
    private AtomicReference<SurfaceData> surfaceData = new AtomicReference<Object>(null);
    private final ReadOnlyDoubleWrapper screenScaleFactor = new ReadOnlyDoubleWrapper((Object)this, "screenScaleFactor", 1.0);
    private final DoubleProperty userScaleFactor = new SimpleDoubleProperty((Object)this, "userScaleFactor", 1.0);
    private ScreenObserver screenObserver;
    private double _width;
    private ReadOnlyDoubleWrapper width;
    private double _height;
    private ReadOnlyDoubleWrapper height;
    private AtomicReference<FrontSwapChain> swapChainBuf = new AtomicReference();

    protected void init() {
        this.screenObserver = new ScreenObserver(this);
        this.screenScaleFactor.bind((ObservableValue)this.screenObserver.currentRenderScaleProperty());
        this.screenScaleFactor.addListener((x, o, n) -> this.updateSurfaceData());
    }

    public ReadOnlyDoubleProperty screenScaleFactorProperty() {
        return this.screenScaleFactor.getReadOnlyProperty();
    }

    public double getScreenScaleFactor() {
        return this.screenScaleFactorProperty().get();
    }

    public DoubleProperty userScaleFactorProperty() {
        return this.userScaleFactor;
    }

    public double getUserScaleFactor() {
        return this.userScaleFactorProperty().get();
    }

    public void setUserScaleFactor(double value) {
        this.userScaleFactorProperty().set(value);
    }

    public double minHeight(double width) {
        return 0.0;
    }

    public double minWidth(double height) {
        return 0.0;
    }

    public double prefWidth(double height) {
        return 100.0;
    }

    public double prefHeight(double width) {
        return 100.0;
    }

    public double maxWidth(double height) {
        return Double.MAX_VALUE;
    }

    public double maxHeight(double width) {
        return Double.MAX_VALUE;
    }

    private void widthChanged(double value) {
        if (value != this._width) {
            this._width = value;
            this.getHelper().geomChanged();
            this.getHelper().layoutBoundsChanged();
            this.updateSurfaceData();
            this.getHelper().markDirty(DirtyBits.NODE_GEOMETRY);
        }
    }

    public final double getWidth() {
        return this.width == null ? this._width : this.width.get();
    }

    public final ReadOnlyDoubleProperty widthProperty() {
        if (this.width == null) {
            this.width = new ReadOnlyDoubleWrapper(this._width){

                protected void invalidated() {
                    BaseDriftFXSurface.this.widthChanged(this.get());
                }

                public Object getBean() {
                    return BaseDriftFXSurface.this;
                }

                public String getName() {
                    return "width";
                }
            };
        }
        return this.width.getReadOnlyProperty();
    }

    protected void setWidth(double value) {
        if (this.width == null) {
            this.widthChanged(value);
        } else {
            this.width.set(value);
        }
    }

    private void heightChanged(double value) {
        if (this._height != value) {
            this._height = value;
            this.getHelper().geomChanged();
            this.getHelper().layoutBoundsChanged();
            this.updateSurfaceData();
            this.getHelper().markDirty(DirtyBits.NODE_GEOMETRY);
        }
    }

    public final double getHeight() {
        return this.height == null ? this._height : this.height.get();
    }

    public final ReadOnlyDoubleProperty heightProperty() {
        if (this.height == null) {
            this.height = new ReadOnlyDoubleWrapper(this._height){

                protected void invalidated() {
                    BaseDriftFXSurface.this.heightChanged(this.get());
                }

                public Object getBean() {
                    return BaseDriftFXSurface.this;
                }

                public String getName() {
                    return "height";
                }
            };
        }
        return this.height.getReadOnlyProperty();
    }

    protected void setHeight(double value) {
        if (this.height == null) {
            this.heightChanged(value);
        } else {
            this.height.set(value);
        }
    }

    private SurfaceData computeSurfaceData() {
        DriftDebug.outputThread();
        return new SurfaceData((float)this.getWidth(), (float)this.getHeight(), (float)this.getScreenScaleFactor(), (float)this.getScreenScaleFactor(), (float)this.getUserScaleFactor(), (float)this.getUserScaleFactor(), 0);
    }

    protected abstract InnerHelper getHelper();

    public void drift_updatePeer() {
        NGDriftFXSurface peer = this.getHelper().getPeer();
        if (this.getHelper().isDirty(DirtyBits.NODE_GEOMETRY)) {
            SurfaceData data = this.surfaceData.get();
            peer.updateSurface(data);
            peer.markDirty();
        }
        if (this.getHelper().isDirty(DirtyBits.NODE_CONTENTS)) {
            FrontSwapChain swapChain = this.swapChainBuf.getAndSet(null);
            if (swapChain != null) {
                peer.setSwapChain(swapChain);
            }
            peer.markDirty();
        }
    }

    public boolean isResizable() {
        return true;
    }

    public void resize(double width, double height) {
        DriftDebug.outputThread();
        this.setWidth(width);
        this.setHeight(height);
        this.updateSurfaceData();
    }

    private void updateSurfaceData() {
        DriftDebug.outputThread();
        SurfaceData data = this.computeSurfaceData();
        if (!data.equals(this.surfaceData.get())) {
            this.surfaceData.set(data);
            this.getHelper().markDirty(DirtyBits.NODE_GEOMETRY);
        }
    }

    public void dirty() {
        DriftDebug.outputThread();
        Platform.runLater(() -> this.getHelper().markDirty(DirtyBits.NODE_CONTENTS));
    }

    public void setSwapChain(FrontSwapChain swapChain) {
        DriftDebug.outputThread();
        FrontSwapChain leftover = this.swapChainBuf.getAndSet(swapChain);
        if (leftover != null) {
            Log.info("Leftover swapchain!!! This is not good! " + leftover);
        }
        Platform.runLater(() -> this.getHelper().markDirty(DirtyBits.NODE_CONTENTS));
    }

    private static void drift_addShutdownHook(Runnable hook) {
        Toolkit.getToolkit().addShutdownHook(hook);
    }

    protected BaseBounds drift_computeGeomBounds(BaseBounds bounds, BaseTransform tx) {
        RectBounds rv = new RectBounds(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
        rv = tx.transform((BaseBounds)rv, (BaseBounds)rv);
        return rv;
    }

    protected boolean drift_computeContains(double localX, double localY) {
        double w = this.getWidth();
        double h = this.getHeight();
        return w > 0.0 && h > 0.0 && localX >= 0.0 && localY >= 0.0 && localX < w && localY < h;
    }

    protected NGNode drift_createPeer() {
        NGDriftFXSurface peer = new NGDriftFXSurface(this);
        return peer;
    }

    static {
        try {
            Prism.initialize();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected static interface InnerHelper {
        public NGDriftFXSurface getPeer();

        public boolean isDirty(DirtyBits var1);

        public void markDirty(DirtyBits var1);

        public void geomChanged();

        public void layoutBoundsChanged();

        public void beginPeerAccess();

        public void endPeerAccess();
    }
}

