/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.dashboard.ui.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.egerrit.internal.dashboard.ui.views.GerritTableView;
import org.eclipse.egerrit.internal.ui.compare.CompareUpperSectionColumn;
import org.eclipse.egerrit.internal.ui.table.model.ConflictWithTableModel;
import org.eclipse.egerrit.internal.ui.table.model.FilesTableModel;
import org.eclipse.egerrit.internal.ui.table.model.HistoryTableModel;
import org.eclipse.egerrit.internal.ui.table.model.ITableModel;
import org.eclipse.egerrit.internal.ui.table.model.RelatedChangesTableModel;
import org.eclipse.egerrit.internal.ui.table.model.ReviewersTableModel;
import org.eclipse.egerrit.internal.ui.table.model.SameTopicTableModel;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class FixupTableDefaultHandler
extends AbstractHandler {
    private static final String COMPARE_EDITOR_ID = "org.eclipse.compare.CompareEditor";

    public Object execute(ExecutionEvent aEvent) {
        Display disp = Display.getCurrent();
        Control control = disp.getFocusControl();
        if (control instanceof Table && control.getData() != null && control.getData().equals("filesTable")) {
            FilesTableModel[] tableInfo = FilesTableModel.values();
            ((Table)control).setColumnOrder(FilesTableModel.getDefaultOrder());
            this.setTableDefaultWidth(control, (ITableModel[])tableInfo);
            return null;
        }
        IWorkbenchPage wbp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        String id = wbp.getActivePartReference().getId();
        if (id.compareTo("org.eclipse.egerrit.dashboard.ui.views.GerritTableView") == 0) {
            GerritTableView reviewTableView = GerritTableView.getActiveView(true);
            reviewTableView.resetDefault();
        } else {
            Display display = Display.getCurrent();
            Control table = display.getFocusControl();
            if (id.compareTo("org.eclipse.egerrit.ui.editors.ChangeDetailEditor") == 0) {
                this.handleChangeDetailEditor(table);
            } else if (id.compareTo(COMPARE_EDITOR_ID) == 0) {
                this.handleCompareEditor(table);
            }
        }
        return null;
    }

    private void handleCompareEditor(Control table) {
        if (table instanceof Tree) {
            CompareUpperSectionColumn[] tableInfo = CompareUpperSectionColumn.values();
            ((Tree)table).setColumnOrder(CompareUpperSectionColumn.getDefaultOrder());
            this.setTableDefaultWidth(table, (ITableModel[])tableInfo);
        }
    }

    private void handleChangeDetailEditor(Control table) {
        if (table instanceof Table) {
            if (table.getData().toString().compareTo("reviewersTable") == 0) {
                ReviewersTableModel[] tableInfo = ReviewersTableModel.values();
                ((Table)table).setColumnOrder(ReviewersTableModel.getDefaultOrder());
                this.setTableDefaultWidth(table, (ITableModel[])tableInfo);
            } else if (table.getData().toString().compareTo("filesTable") == 0) {
                FilesTableModel[] tableInfo = FilesTableModel.values();
                ((Table)table).setColumnOrder(FilesTableModel.getDefaultOrder());
                this.setTableDefaultWidth(table, (ITableModel[])tableInfo);
            } else if (table.getData().toString().compareTo("historyTable") == 0) {
                HistoryTableModel[] tableInfo = HistoryTableModel.values();
                ((Table)table).setColumnOrder(HistoryTableModel.getDefaultOrder());
                this.setTableDefaultWidth(table, (ITableModel[])tableInfo);
            } else if (table.getData().toString().compareTo("sameTopicTable") == 0) {
                SameTopicTableModel[] tableInfo = SameTopicTableModel.values();
                ((Table)table).setColumnOrder(SameTopicTableModel.getDefaultOrder());
                this.setTableDefaultWidth(table, (ITableModel[])tableInfo);
            } else if (table.getData().toString().compareTo("relatedChangesTable") == 0) {
                RelatedChangesTableModel[] tableInfo = RelatedChangesTableModel.values();
                ((Table)table).setColumnOrder(RelatedChangesTableModel.getDefaultOrder());
                this.setTableDefaultWidth(table, (ITableModel[])tableInfo);
            } else if (table.getData().toString().compareTo("conflictsWithTable") == 0) {
                ConflictWithTableModel[] tableInfo = ConflictWithTableModel.values();
                ((Table)table).setColumnOrder(ConflictWithTableModel.getDefaultOrder());
                this.setTableDefaultWidth(table, (ITableModel[])tableInfo);
            }
        }
    }

    private void setTableDefaultWidth(Control table, ITableModel[] tableInfo) {
        int i = 0;
        while (i < tableInfo.length) {
            if (table instanceof Table) {
                ((Table)table).getColumn(i).setWidth(tableInfo[i].getWidth());
            } else {
                ((Tree)table).getColumn(i).setWidth(tableInfo[i].getWidth());
            }
            ++i;
        }
    }
}

