/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.options;

import java.util.Locale;
import org.eclipse.escet.cif.plcgen.targets.PlcTargetType;
import org.eclipse.escet.common.app.framework.options.EnumOption;
import org.eclipse.escet.common.app.framework.options.Options;

public class PlcTargetTypeOption
extends EnumOption<PlcTargetType> {
    public static final PlcTargetType DEFAULT_TARGET = PlcTargetType.PLC_OPEN_XML;

    public PlcTargetTypeOption() {
        super("PLC code target type", PlcTargetTypeOption.makeDescription(), Character.valueOf('t'), "target-type", "TARGET", (Enum)DEFAULT_TARGET, true, "Specifies the PLC code target type.");
    }

    protected String getDialogText(PlcTargetType type) {
        return type.dialogText;
    }

    private static String makeDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("Specifies the PLC code target type. Specify ");
        int last = PlcTargetType.values().length - 1;
        int i = 0;
        while (i <= last) {
            if (i > 0) {
                sb.append(last > 1 ? ", " : " ");
                if (i == last) {
                    sb.append("or ");
                }
            }
            PlcTargetType targetType = PlcTargetType.values()[i];
            sb.append('\"');
            sb.append(targetType.dialogText.toLowerCase(Locale.US).replace(' ', '-'));
            sb.append('\"');
            sb.append(" for " + targetType.dialogText + " output");
            if (targetType == DEFAULT_TARGET) {
                sb.append(" (default)");
            }
            ++i;
        }
        sb.append(".");
        return sb.toString();
    }

    public static PlcTargetType getPlcTargetType() {
        return (PlcTargetType)((Object)Options.get(PlcTargetTypeOption.class));
    }
}

