/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.setext.runtime;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.TextPosition;
import org.eclipse.escet.common.java.exceptions.InputOutputException;
import org.eclipse.escet.common.java.exceptions.InvalidInputException;
import org.eclipse.escet.setext.runtime.CodePointReader;
import org.eclipse.escet.setext.runtime.DebugMode;
import org.eclipse.escet.setext.runtime.ParserHooksBase;
import org.eclipse.escet.setext.runtime.Scanner;
import org.eclipse.escet.setext.runtime.SyntaxWarning;
import org.eclipse.escet.setext.runtime.Token;
import org.eclipse.escet.setext.runtime.exceptions.ParseException;
import org.eclipse.jface.text.Position;

public abstract class Parser<T> {
    private final Set<SyntaxWarning> warnings = Sets.set();
    protected final Scanner scanner;
    protected int[][] firstTerminals;
    protected int[][][] firstTerminalsReduced;
    protected int[][][] reducibleNonTerminals;
    protected int[][][] reducibleNonTerminalsReduced;
    protected String[] entrySymbolNames;
    protected boolean debugParser;
    protected LinkedList<Integer> stateStack;
    protected LinkedList<Integer> stateStackNonReduced;
    protected int stateStackPrefixCount;
    protected LinkedList<Object> objectStack;
    public List<Position> foldRanges = null;

    public Parser(Scanner scanner) {
        this.scanner = scanner;
    }

    public void addFoldRange(Token start, Token end) {
        this.addFoldRange(start.position, end.position);
    }

    public void addFoldRange(TextPosition start, TextPosition end) {
        if (this.foldRanges == null) {
            return;
        }
        if (start.startOffset >= end.startOffset) {
            throw new IllegalArgumentException("start.start >= end.start");
        }
        if (end.endOffset <= start.endOffset) {
            throw new IllegalArgumentException("end.end <= start.end");
        }
        int first = start.startOffset;
        int last = end.endOffset;
        this.addFoldRange(first, last + 1 - first);
    }

    public void addFoldRange(int start, int length) {
        if (this.foldRanges == null) {
            return;
        }
        if (start < 0) {
            throw new IllegalArgumentException("start < 0");
        }
        if (length <= 0) {
            throw new IllegalArgumentException("length <= 0");
        }
        this.foldRanges.add(new Position(start, length));
    }

    public void addWarning(String message, TextPosition position) {
        this.warnings.add(new SyntaxWarning(message, position));
    }

    public List<SyntaxWarning> getWarnings() {
        return Sets.sortedgeneric(this.warnings);
    }

    public abstract ParserHooksBase getHooks();

    public String getSource() {
        return this.scanner.src;
    }

    public String getLocation() {
        return this.scanner.location;
    }

    public T parseString(String inputText, String location) {
        return this.parseString(inputText, location, null, DebugMode.NONE);
    }

    public T parseString(String inputText, String location, String src) {
        return this.parseString(inputText, location, src, DebugMode.NONE);
    }

    public T parseString(String inputText, String location, DebugMode debug) {
        return this.parseString(inputText, location, null, debug);
    }

    public T parseString(String inputText, String location, String src, DebugMode debug) {
        StringReader strReader = new StringReader(inputText);
        CodePointReader cpReader = new CodePointReader(strReader, false);
        return this.parseReader(cpReader, location, src, debug);
    }

    public T parseFile(String filePath) {
        return this.parseFile(Paths.resolve((String)filePath), filePath, DebugMode.NONE);
    }

    public T parseFile(String filePath, String srcFilePath) {
        return this.parseFile(filePath, srcFilePath, DebugMode.NONE);
    }

    public T parseFile(String filePath, DebugMode debug) {
        return this.parseFile(Paths.resolve((String)filePath), filePath, debug);
    }

    public T parseFile(String filePath, String srcFilePath, DebugMode debug) {
        FileInputStream fileStream;
        try {
            fileStream = new FileInputStream(filePath);
        }
        catch (FileNotFoundException e) {
            String msg = Strings.fmt((String)"Could not open file \"%s\", as the file does not exist, is a directory rather than a regular file, or for some other reason cannot be opened for reading.", (Object[])new Object[]{filePath});
            throw new InvalidInputException(msg, (Throwable)e);
        }
        String src = Strings.fmt((String)"File \"%s\": ", (Object[])new Object[]{srcFilePath});
        return this.parseStream(fileStream, filePath, src, debug);
    }

    public T parseStream(InputStream stream, String location) {
        return this.parseStream(stream, location, null, DebugMode.NONE);
    }

    public T parseStream(InputStream stream, String location, String src) {
        return this.parseStream(stream, location, src, DebugMode.NONE);
    }

    public T parseStream(InputStream stream, String location, DebugMode debug) {
        return this.parseStream(stream, location, null, debug);
    }

    public T parseStream(InputStream stream, String location, String src, DebugMode debug) {
        T t;
        CodePointReader reader = new CodePointReader(stream, true);
        try {
            t = this.parseReader(reader, location, src, debug);
        }
        catch (Throwable throwable) {
            try {
                stream.close();
            }
            catch (IOException e) {
                String msg = Strings.fmt((String)"Could not close \"%s\".", (Object[])new Object[]{location});
                throw new InputOutputException(msg);
            }
            throw throwable;
        }
        try {
            stream.close();
        }
        catch (IOException e) {
            String msg = Strings.fmt((String)"Could not close \"%s\".", (Object[])new Object[]{location});
            throw new InputOutputException(msg);
        }
        return t;
    }

    public T parseReader(CodePointReader reader, String location) {
        return this.parseReader(reader, location, null, DebugMode.NONE);
    }

    public T parseReader(CodePointReader reader, String location, String src) {
        return this.parseReader(reader, location, src, DebugMode.NONE);
    }

    public T parseReader(CodePointReader reader, String location, DebugMode debug) {
        return this.parseReader(reader, location, null, debug);
    }

    public T parseReader(CodePointReader reader, String location, String src, DebugMode debug) {
        T rslt;
        boolean bl = this.debugParser = debug == DebugMode.PARSER || debug == DebugMode.BOTH;
        if (this.debugParser) {
            OutputProvider.out((String)"%s: %sParsing...", (Object[])new Object[]{this.getClass().getSimpleName(), src == null ? "" : src});
        }
        this.scanner.initScanner(reader, location, src, debug, true);
        this.stateStack = new LinkedList();
        this.stateStack.addLast(0);
        this.stateStackNonReduced = new LinkedList();
        this.stateStackPrefixCount = 1;
        this.objectStack = new LinkedList();
        this.getHooks().setParser(this);
        try {
            rslt = this.parse();
        }
        catch (IOException e) {
            String msg = Strings.fmt((String)"%sFailed to read input.", (Object[])new Object[]{src == null ? "" : src});
            throw new InputOutputException(msg, (Throwable)e);
        }
        return rslt;
    }

    protected abstract T parse() throws IOException;

    protected Token nextToken() throws IOException {
        Token token = this.scanner.nextToken();
        String terminalName;
        while ((terminalName = this.scanner.terminalNames[token.id]) == null) {
            if (token.isEof()) {
                return token;
            }
            token = this.scanner.nextToken();
        }
        return token;
    }

    protected int getCurrentState() {
        return this.stateStack.peekLast();
    }

    protected final Token doShift(Token token, int stateId) throws IOException {
        if (this.debugParser) {
            this.debugShift(token);
        }
        this.stateStack.addLast(stateId);
        this.objectStack.addLast(token);
        this.stateStackNonReduced.clear();
        this.stateStackPrefixCount = this.stateStack.size();
        return this.nextToken();
    }

    protected final void doReduce1(Token token, int reduceId) {
        if (this.debugParser) {
            this.debugReduce(token, reduceId);
        }
    }

    protected final Object doReduce2() {
        int size = this.stateStack.size();
        if (size > this.stateStackPrefixCount) {
            this.stateStack.removeLast();
        } else if (size == this.stateStackPrefixCount) {
            int stateId = this.stateStack.removeLast();
            this.stateStackNonReduced.addFirst(stateId);
            --this.stateStackPrefixCount;
        } else {
            String msg = Strings.fmt((String)"Reduced state stack size (%,d) < common prefix count (%,d).", (Object[])new Object[]{size, this.stateStackPrefixCount});
            throw new RuntimeException(msg);
        }
        return this.objectStack.removeLast();
    }

    protected final int doReduce3(Object obj) {
        this.objectStack.addLast(obj);
        return this.getCurrentState();
    }

    protected final void doGoto(int stateId) {
        this.stateStack.addLast(stateId);
    }

    protected final Object doAccept(Token token) {
        if (this.debugParser) {
            this.debugAccept(token);
        }
        Object rslt = this.objectStack.removeLast();
        Assert.check((boolean)this.objectStack.isEmpty());
        this.stateStackNonReduced = null;
        this.stateStackPrefixCount = 0;
        return rslt;
    }

    private Set<Integer> collectExpectedTerminalIds() {
        int stackSize = this.stateStackPrefixCount + this.stateStackNonReduced.size();
        List stateStack = Lists.listc((int)stackSize);
        NonReducedStateStackIterator stateIter = new NonReducedStateStackIterator();
        while (stateIter.hasNext()) {
            stateStack.add((Integer)stateIter.next());
        }
        LinkedList<Pair> todo = new LinkedList<Pair>();
        todo.add(Pair.pair((Object)(stackSize - 1), (Object)-1));
        Set expTermIds = Sets.set();
        while (!todo.isEmpty()) {
            int[][] idsArray;
            int reductionPopCount;
            int i;
            int reductionNonTermId;
            int n;
            int[][] nArray;
            int[][] reductions;
            int n2;
            Pair item = (Pair)todo.remove();
            int stateIdx = (Integer)item.left;
            int stateId = (Integer)stateStack.get(stateIdx);
            int reducedNonTermId = (Integer)item.right;
            if (reducedNonTermId == -1) {
                int[] termIds;
                int[] nArray2 = termIds = this.firstTerminals[stateId];
                n2 = termIds.length;
                int n3 = 0;
                while (n3 < n2) {
                    int termId = nArray2[n3];
                    expTermIds.add(termId);
                    ++n3;
                }
                nArray = reductions = this.reducibleNonTerminals[stateId];
                n = reductions.length;
                n2 = 0;
                while (n2 < n) {
                    int[] reduction = nArray[n2];
                    reductionNonTermId = reduction[0];
                    Assert.check((reductionNonTermId >= 0 ? 1 : 0) != 0);
                    i = 1;
                    while (i < reduction.length) {
                        reductionPopCount = reduction[i];
                        todo.add(Pair.pair((Object)(stateIdx - reductionPopCount), (Object)reductionNonTermId));
                        ++i;
                    }
                    ++n2;
                }
                continue;
            }
            int[][] nArray3 = idsArray = this.firstTerminalsReduced[stateId];
            n2 = idsArray.length;
            int reduction = 0;
            while (reduction < n2) {
                int[] ids = nArray3[reduction];
                if (ids[0] == reducedNonTermId) {
                    int i2 = 1;
                    while (i2 < ids.length) {
                        expTermIds.add(ids[i2]);
                        ++i2;
                    }
                }
                ++reduction;
            }
            nArray = reductions = this.reducibleNonTerminalsReduced[stateId];
            n = reductions.length;
            n2 = 0;
            while (n2 < n) {
                int[] reduction2 = nArray[n2];
                if (reduction2[0] == reducedNonTermId) {
                    reductionNonTermId = reduction2[1];
                    Assert.check((reductionNonTermId >= 0 ? 1 : 0) != 0);
                    i = 2;
                    while (i < reduction2.length) {
                        reductionPopCount = reduction2[i];
                        todo.add(Pair.pair((Object)(stateIdx - reductionPopCount), (Object)reductionNonTermId));
                        ++i;
                    }
                }
                ++n2;
            }
        }
        return expTermIds;
    }

    protected void parsingFailed(Token token) {
        Object expTermsTxt;
        String tokenText;
        if (this.debugParser) {
            this.debugFailed(token, true);
            this.debugFailed(token, false);
        }
        if (token.isEof()) {
            tokenText = null;
        } else {
            tokenText = token.originalText;
            Assert.notNull((Object)tokenText);
            Assert.check((!tokenText.isEmpty() ? 1 : 0) != 0);
        }
        String foundTermTxt = this.scanner.terminalDescriptions[token.id];
        Set<Integer> expTermIds = this.collectExpectedTerminalIds();
        Set expTermsTxtsSet = Sets.setc((int)expTermIds.size());
        for (int termId : expTermIds) {
            expTermsTxtsSet.add(this.scanner.terminalDescriptions[termId]);
        }
        Assert.check((!expTermsTxtsSet.isEmpty() ? 1 : 0) != 0);
        List expTermsTxts = Sets.sortedstrings((Set)expTermsTxtsSet);
        if (expTermsTxts.size() == 1) {
            expTermsTxt = (String)Lists.first((List)expTermsTxts);
        } else if (expTermsTxts.size() == 2) {
            expTermsTxt = (String)Lists.first((List)expTermsTxts) + " or " + (String)Lists.last((List)expTermsTxts);
        } else {
            List ts = expTermsTxts.subList(0, expTermsTxts.size() - 1);
            expTermsTxt = String.join((CharSequence)", ", ts);
            expTermsTxt = (String)expTermsTxt + ", or " + (String)Lists.last((List)expTermsTxts);
        }
        throw new ParseException(tokenText, token.position, foundTermTxt, (String)expTermsTxt);
    }

    protected void debugShift(Token token) {
        String tokenTxt = token.isEof() ? "\u00b6" : this.scanner.terminalNames[token.id];
        OutputProvider.out((String)"%s: %s (shift %s)", (Object[])new Object[]{this.getClass().getSimpleName(), this.getStackTxt(token, true), tokenTxt});
    }

    protected void debugReduce(Token token, int reduceId) {
        String nonterminalName = this.getNonTerminalName(reduceId);
        OutputProvider.out((String)"%s: %s (reduce %s)", (Object[])new Object[]{this.getClass().getSimpleName(), this.getStackTxt(token, true), nonterminalName});
    }

    protected void debugAccept(Token token) {
        Assert.check((boolean)token.isEof());
        OutputProvider.out((String)"%s: %s (accept)", (Object[])new Object[]{this.getClass().getSimpleName(), this.getStackTxt(token, true)});
    }

    protected void debugFailed(Token token, boolean reduced) {
        OutputProvider.out((String)"%s: %s (parsing failed, %sreduced state stack)", (Object[])new Object[]{this.getClass().getSimpleName(), this.getStackTxt(token, reduced), reduced ? "" : "non-"});
    }

    protected abstract String getNonTerminalName(int var1);

    private String getStackTxt(Token token, boolean reduced) {
        StringBuilder builder = new StringBuilder();
        Iterator<Integer> iter = reduced ? this.stateStack.iterator() : new NonReducedStateStackIterator();
        while (iter.hasNext()) {
            int state = iter.next();
            String entrySymbolName = this.entrySymbolNames[state];
            if (entrySymbolName != null) {
                builder.append(entrySymbolName);
            }
            builder.append(Strings.fmt((String)"/%d ", (Object[])new Object[]{state}));
        }
        builder.append(". ");
        String tokenTxt = token.isEof() ? "\u00b6" : this.scanner.terminalNames[token.id];
        builder.append(tokenTxt);
        return builder.toString();
    }

    private class NonReducedStateStackIterator
    implements Iterator<Integer> {
        private final Iterator<Integer> reducedIterator;
        private final Iterator<Integer> nonReducedIterator;
        private int count;

        public NonReducedStateStackIterator() {
            this.reducedIterator = Parser.this.stateStack.iterator();
            this.nonReducedIterator = Parser.this.stateStackNonReduced.iterator();
            this.count = 0;
        }

        @Override
        public boolean hasNext() {
            if (this.count < Parser.this.stateStackPrefixCount) {
                return true;
            }
            return this.nonReducedIterator.hasNext();
        }

        @Override
        public Integer next() {
            if (this.count < Parser.this.stateStackPrefixCount) {
                ++this.count;
                return this.reducedIterator.next();
            }
            return this.nonReducedIterator.next();
        }
    }
}

