/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.appsview.ui.commands;

import java.util.Set;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.ItemType;
import org.eclipse.escet.common.app.framework.appsview.ui.AppsView;
import org.eclipse.escet.common.app.framework.appsview.ui.commands.RemoveCommandBase;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class RemoveAllCommand
extends RemoveCommandBase {
    @Override
    public String getIconUri() {
        return "platform:/plugin/org.eclipse.escet.common.app.framework.appsview.ui/icons/command_remove_all.png";
    }

    @Override
    public String getItemLabel() {
        return "&Remove All";
    }

    @Override
    public String getTooltip() {
        return "Remove all listed applications that have terminated";
    }

    @Override
    public String getContributionUri() {
        return "bundleclass://org.eclipse.escet.common.app.framework.appsview.ui/" + this.getClass().getName();
    }

    @Override
    public ItemType getItemType() {
        return ItemType.PUSH;
    }

    @CanExecute
    public boolean isEnabled(MPart part) {
        return this.canRemove(part);
    }

    private boolean canRemove(MPart part) {
        AppsView view = (AppsView)part.getObject();
        if (view == null) {
            return false;
        }
        Tree tree = view.getTree();
        if (tree == null || tree.isDisposed()) {
            return false;
        }
        TreeItem[] treeItemArray = tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (this.canRemove(view, item)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void execute(MPart part) {
        AppsView view = (AppsView)part.getObject();
        if (view == null) {
            return;
        }
        Tree tree = view.getTree();
        if (tree == null || tree.isDisposed()) {
            return;
        }
        TreeItem[] roots = tree.getItems();
        Set rootsToRemove = Sets.setc((int)roots.length);
        TreeItem[] treeItemArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem root = treeItemArray[n2];
            if (this.canRemove(view, root)) {
                rootsToRemove.add(root);
            }
            ++n2;
        }
        view.removeRootItems(rootsToRemove);
    }
}

