/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.appsview.ui.icons;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import org.eclipse.escet.common.app.framework.management.AppStatus;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class AppStatusIcons {
    private Map<AppStatus, Image> icons = Maps.map();
    private Map<Image, AppStatus> statuses = Maps.map();

    public AppStatusIcons() {
        AppStatus[] appStatusArray = AppStatus.values();
        int n = appStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            AppStatus status = appStatusArray[n2];
            this.loadIcon(status);
            ++n2;
        }
    }

    private void loadIcon(AppStatus status) {
        if (this.icons.containsKey(status)) {
            throw new RuntimeException("Duplicate status: " + String.valueOf(status));
        }
        String statusName = status.toString().toLowerCase(Locale.US);
        Object resName = this.getClass().getPackage().getName().replace('.', '/');
        resName = (String)resName + "/status_" + statusName + ".png";
        ClassLoader loader = this.getClass().getClassLoader();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (InputStream stream = loader.getResourceAsStream((String)resName);){
                if (stream == null) {
                    throw new RuntimeException("Could not find icon: " + (String)resName);
                }
                Image image = new Image((Device)Display.getDefault(), stream);
                this.icons.put(status, image);
                this.statuses.put(image, status);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not load icon: " + (String)resName, ex);
        }
    }

    public Image getIcon(AppStatus status) {
        return this.icons.get(status);
    }

    public AppStatus getStatus(Image icon) {
        return this.statuses.get(icon);
    }

    public void dispose() {
        for (Image image : this.icons.values()) {
            if (image.isDisposed()) continue;
            image.dispose();
        }
        this.icons.clear();
        for (Image image : this.statuses.keySet()) {
            if (image.isDisposed()) continue;
            image.dispose();
        }
        this.statuses.clear();
    }
}

