/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.dsm.app;

import org.eclipse.escet.common.app.framework.options.EnumOption;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.dsm.BusDetectionAlgorithm;
import org.eclipse.escet.common.dsm.ClusterInput;

public class DsmBusDetectionAlgorithmOption
extends EnumOption<BusDetectionAlgorithm> {
    private static final BusDetectionAlgorithm DEFAULT_VALUE = ClusterInput.DEFAULT_BUS_DETECTION;
    private static final String NAME = "Bus detection algorithm";
    private static final String DESCRIPTION = "The bus detection algorithm to use. Use \"no-bus\" to skip bus detection, \"fix-point\" for using the fixed-point algorithm, and \"top-k\" for selecting the K top-nodes. [DEFAULT=" + DsmBusDetectionAlgorithmOption.getOptionValue((Enum)DEFAULT_VALUE) + "].";
    private static final Character CMD_SHORT = null;
    private static final String CMD_LONG = "bus-algorithm";
    private static final String CMD_VALUE = "BUSALG";
    private static final boolean SHOW_IN_DIALOG = true;
    private static final String DIALOG_DESCR = "The bus detection algorithm to use.";

    public DsmBusDetectionAlgorithmOption() {
        super(NAME, DESCRIPTION, CMD_SHORT, CMD_LONG, CMD_VALUE, (Enum)DEFAULT_VALUE, true, DIALOG_DESCR);
    }

    protected String getDialogText(BusDetectionAlgorithm alg) {
        switch (alg) {
            case NO_BUS: {
                return "No bus";
            }
            case FIX_POINT: {
                return "Fixed point";
            }
            case TOP_K: {
                return "Top k nodes";
            }
        }
        throw new RuntimeException("Unknown bus detection algorithm: " + String.valueOf(alg));
    }

    public static BusDetectionAlgorithm getBusAlgorithm() {
        return (BusDetectionAlgorithm)Options.get(DsmBusDetectionAlgorithmOption.class);
    }
}

