/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.java;

import java.util.List;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlUtils {
    private XmlUtils() {
    }

    public static Element getSingleElementByName(Element parent, String tagName) {
        Element result = null;
        Node n = parent.getFirstChild();
        while (n != null) {
            if (n.getNodeType() == 1 && n.getNodeName().equals(tagName)) {
                if (result == null) {
                    result = (Element)n;
                } else {
                    String msg = Strings.fmt("Expected single node '%s', but found more.", tagName);
                    throw new AssertionError((Object)msg);
                }
            }
            n = n.getNextSibling();
        }
        if (result == null) {
            String msg = Strings.fmt("Expected one element named '%s', but didn't find any.", tagName);
            throw new AssertionError((Object)msg);
        }
        return result;
    }

    public static List<Element> getElementsByName(Element parent, String tagName) {
        List<Element> results = Lists.list();
        Node n = parent.getFirstChild();
        while (n != null) {
            if (n.getNodeType() == 1 && n.getNodeName().equals(tagName)) {
                results.add((Element)n);
            }
            n = n.getNextSibling();
        }
        return results;
    }
}

