/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraphNode;
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedActorClass;
import org.eclipse.etrice.core.genmodel.fsm.FsmGenExtensions;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Graph;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.GraphContainer;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Node;
import org.eclipse.etrice.generator.generic.GenericStateMachineGenerator;
import org.eclipse.etrice.generator.java.Main;
import org.eclipse.etrice.generator.java.setup.GeneratorOptionsHelper;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

@Singleton
public class StateMachineGen
extends GenericStateMachineGenerator {
    @Inject
    @Extension
    protected GeneratorOptionsHelper _generatorOptionsHelper;
    private final NodeComparator nodeComparator = new NodeComparator();

    public CharSequence genExtra(GraphContainer gc, boolean generateImplementation) {
        StringConcatenation stringConcatenation = null;
        List orderedStateNodes = IterableExtensions.sortWith((Iterable)IteratorExtensions.toList((Iterator)FsmGenExtensions.getAllStateNodes((Graph)gc.getGraph())), (Comparator)this.nodeComparator);
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        if (this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings()) || this._generatorOptionsHelper.isGenerateWithVerboseOutput(Main.getSettings())) {
            stringConcatenation2.append("// state names");
            stringConcatenation2.newLine();
            stringConcatenation2.append("protected static final String stateStrings[] = {");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\"<no state>\",");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\"<top>\",");
            stringConcatenation2.newLine();
            boolean bl = false;
            for (Node node : orderedStateNodes) {
                if (!bl) {
                    bl = true;
                } else {
                    stringConcatenation2.appendImmediate((Object)",", "\t");
                }
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\"");
                StateGraphNode stateGraphNode = node.getStateGraphNode();
                String string = this._codegenHelpers.getGenStatePathName((State)stateGraphNode);
                stringConcatenation2.append(string, "\t");
                stringConcatenation2.append("\"");
                stringConcatenation2.newLineIfNotEmpty();
            }
            stringConcatenation2.append("};");
            stringConcatenation2.newLine();
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("// history");
        stringConcatenation2.newLine();
        stringConcatenation2.append("protected int history[] = {NO_STATE, NO_STATE");
        Iterator iterator = orderedStateNodes.iterator();
        while (iterator.hasNext()) {
            Node cfr_ignored_0 = (Node)iterator.next();
            stringConcatenation2.append(", NO_STATE");
        }
        stringConcatenation2.append("};");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("private void setState(int new_state) {");
        stringConcatenation2.newLine();
        boolean bl = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (bl) {
            stringConcatenation2.append("\t");
            stringConcatenation2.append("DebuggingService.getInstance().addActorState(this,stateStrings[new_state]);");
            stringConcatenation2.newLine();
        }
        if (bl = this._generatorOptionsHelper.isGenerateWithVerboseOutput(Main.getSettings())) {
            stringConcatenation2.append("\t");
            stringConcatenation2.append("if (stateStrings[new_state]!=\"Idle\") {");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("System.out.println(\"state switch of \"+getInstancePath() + \": \"");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t\t\t");
            stringConcatenation2.append("+ stateStrings[this.state] + \" -> \" + stateStrings[new_state]);");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("\t");
        stringConcatenation2.append("this.state = new_state;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    public CharSequence finalAction() {
        StringConcatenation stringConcatenation = new StringConcatenation();
        boolean bl = this._generatorOptionsHelper.isGenerateStoreDataObj(Main.getSettings());
        if (bl) {
            stringConcatenation.append("finalAction();");
            stringConcatenation.newLine();
        }
        return stringConcatenation;
    }

    public int getHistorySize(ExpandedActorClass xpac) {
        int n = this._fSMHelpers.getAllBaseStates((ModelComponent)xpac.getActorClass()).size();
        return n + 2;
    }

    private static class NodeComparator
    implements Comparator<Node> {
        private NodeComparator() {
        }

        @Override
        public int compare(Node o1, Node o2) {
            int n;
            boolean bl;
            int n2 = o1.getInheritanceLevel();
            boolean bl2 = bl = n2 == (n = o2.getInheritanceLevel());
            if (bl) {
                if (FsmGenExtensions.isLeaf((Node)o1) && FsmGenExtensions.isLeaf((Node)o2)) {
                    return 0;
                }
                boolean bl3 = FsmGenExtensions.isLeaf((Node)o1);
                if (bl3) {
                    return 1;
                }
                boolean bl4 = FsmGenExtensions.isLeaf((Node)o2);
                if (bl4) {
                    return -1;
                }
                return 0;
            }
            return Integer.compare(o1.getInheritanceLevel(), o1.getInheritanceLevel());
        }
    }
}

