/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.model.utils;

import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.Element;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.Block;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.ClassicalExpression;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockConstraintSystem;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.Expression;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.Relation;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.ImportStatement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.NamedElement;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class CCSLKernelUtils {
    public static final String defaultSeparator = "::";

    public static String getName(EObject object) {
        return CCSLKernelUtils.getSimpleName(object);
    }

    public static String getSimpleName(EObject object) {
        if (object instanceof NamedElement) {
            return ((NamedElement)object).getName();
        }
        return null;
    }

    public static String getQualifiedName(EObject object) {
        return CCSLKernelUtils.getQualifiedName(object, defaultSeparator);
    }

    public static String getQualifiedName(EObject object, String separator) {
        if (object == null) {
            return null;
        }
        String name = CCSLKernelUtils.getSimpleName(object);
        String parentQN = CCSLKernelUtils.getQualifiedName(object.eContainer(), separator);
        if (parentQN != null) {
            return name != null ? String.valueOf(parentQN) + separator + name : parentQN;
        }
        return name;
    }

    public static List<String> getQualifiedNameSegments(EObject object) {
        List<Object> result = object.eContainer() == null ? new ArrayList() : CCSLKernelUtils.getQualifiedNameSegments(object.eContainer());
        String name = CCSLKernelUtils.getSimpleName(object);
        result.add(name);
        return result;
    }

    public static EObject findObjectFromQualifiedName(String qualifiedName, ClockConstraintSystem model) {
        return CCSLKernelUtils.findObjectFromQualifiedName(qualifiedName, defaultSeparator, model);
    }

    public static EObject findObjectFromQualifiedName(String qualifiedName, String separator, ClockConstraintSystem model) {
        String[] pathElementNames = qualifiedName.split(separator);
        return CCSLKernelUtils.findObjectFromQualifiedName(pathElementNames, 0, (EObject)model);
    }

    private static EObject findObjectFromQualifiedName(String[] pathElementNames, int index, EObject modelObject) {
        if (index >= pathElementNames.length) {
            return null;
        }
        String elementName = pathElementNames[index];
        if (modelObject instanceof NamedElement) {
            if (((NamedElement)modelObject).getName().compareTo(elementName) == 0) {
                if (index == pathElementNames.length - 1) {
                    return modelObject;
                }
                if (modelObject instanceof Block) {
                    return CCSLKernelUtils.findObjectInBlock(pathElementNames, index, (Block)modelObject);
                }
            } else {
                return null;
            }
        }
        return null;
    }

    private static EObject findObjectInBlock(String[] pathElementNames, int index, Block modelObject) {
        EObject found;
        for (Block subBlock : modelObject.getSubBlock()) {
            found = CCSLKernelUtils.findObjectFromQualifiedName(pathElementNames, index + 1, subBlock);
            if (found == null) continue;
            return found;
        }
        for (Element element : modelObject.getElements()) {
            found = CCSLKernelUtils.findObjectFromQualifiedName(pathElementNames, index + 1, element);
            if (found == null) continue;
            return found;
        }
        for (Expression expr : modelObject.getExpressions()) {
            found = CCSLKernelUtils.findObjectFromQualifiedName(pathElementNames, index + 1, expr);
            if (found == null) continue;
            return found;
        }
        for (Relation relation : modelObject.getRelations()) {
            found = CCSLKernelUtils.findObjectFromQualifiedName(pathElementNames, index + 1, relation);
            if (found == null) continue;
            return found;
        }
        for (ClassicalExpression cexpr : modelObject.getClassicalExpression()) {
            found = CCSLKernelUtils.findObjectFromQualifiedName(pathElementNames, index + 1, cexpr);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public static String getImportAlias(ClockConstraintSystem mainModel, Resource importedResource) {
        ResourceSet resourceSet = mainModel.eResource().getResourceSet();
        if (resourceSet != importedResource.getResourceSet()) {
            return null;
        }
        for (ImportStatement impStatement : mainModel.getImports()) {
            Resource resource;
            String importedURI = impStatement.getImportURI();
            URI uri = resourceSet.getURIConverter().normalize(URI.createURI((String)importedURI));
            if (uri.isRelative()) {
                uri = uri.resolve(mainModel.eResource().getURI());
            }
            if ((resource = resourceSet.getResource(uri, false)) != importedResource) continue;
            String alias = impStatement.getAlias();
            return alias;
        }
        return null;
    }

    public static String getImportAlias(Resource importingResource, Resource importedResource) {
        if (importingResource == importedResource) {
            return "";
        }
        ClockConstraintSystem ccslModelRoot = null;
        if (!(importingResource.getContents().get(0) instanceof ClockConstraintSystem)) {
            return null;
        }
        ccslModelRoot = (ClockConstraintSystem)importingResource.getContents().get(0);
        return CCSLKernelUtils.getImportAlias(ccslModelRoot, importedResource);
    }

    public static String getImportAlias(EObject context, EObject target) {
        EObject root = EcoreUtil.getRootContainer((EObject)context);
        if (root instanceof ClockConstraintSystem) {
            return CCSLKernelUtils.getImportAlias((ClockConstraintSystem)root, target.eResource());
        }
        return null;
    }
}

