/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.graph.gson;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EMap;

public class EMapTypeAdapter<T>
extends TypeAdapter<EMap<?, ?>> {
    protected final Gson gson;

    public EMapTypeAdapter(Gson gson) {
        this.gson = gson;
    }

    public EMap<?, ?> read(JsonReader in) throws IOException {
        JsonToken peek = in.peek();
        if (peek == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        TypeAdapter mapAdapter = this.gson.getAdapter(TypeToken.get(Map.class));
        Map map = (Map)mapAdapter.read(in);
        return new BasicEMap(map);
    }

    public void write(JsonWriter out, EMap<?, ?> value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        Map map = value.map();
        TypeAdapter mapAdapter = this.gson.getAdapter(map.getClass());
        mapAdapter.write(out, (Object)map);
    }

    public static class Factory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            Class rawType = typeToken.getRawType();
            if (!EMap.class.isAssignableFrom(rawType)) {
                return null;
            }
            return new EMapTypeAdapter(gson);
        }
    }
}

