/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.immutables.value.Value;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.ImmutablePortConfig;

@JsonDeserialize(builder=ImmutablePortConfig.Builder.class)
@Value.Immutable
public interface PortConfig {
    public static final String PROTOCOL_TCP = "tcp";
    public static final String PROTOCOL_UDP = "udp";

    @JsonProperty(value="Name")
    @Nullable
    public String name();

    @JsonProperty(value="Protocol")
    @Nullable
    public String protocol();

    @JsonProperty(value="TargetPort")
    @Nullable
    public Integer targetPort();

    @JsonProperty(value="PublishedPort")
    @Nullable
    public Integer publishedPort();

    @JsonProperty(value="PublishMode")
    @Nullable
    public PortConfigPublishMode publishMode();

    public static Builder builder() {
        return ImmutablePortConfig.builder();
    }

    public static enum PortConfigPublishMode {
        INGRESS("ingress"),
        HOST("host");

        private final String name;

        @JsonCreator
        private PortConfigPublishMode(String name) {
            this.name = name;
        }

        @JsonValue
        public String getName() {
            return this.name;
        }
    }

    public static interface Builder {
        public Builder name(String var1);

        public Builder protocol(String var1);

        public Builder targetPort(Integer var1);

        public Builder publishedPort(Integer var1);

        public Builder publishMode(PortConfigPublishMode var1);

        public PortConfig build();
    }
}

