/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import org.eclipse.lsat.common.util.BranchIterable;
import org.eclipse.lsat.common.util.BranchIterator;
import org.eclipse.lsat.common.util.CompoundIterator;
import org.eclipse.lsat.common.util.IteratorUtil;
import org.eclipse.lsat.common.util.LoggableIterable;
import org.eclipse.lsat.common.util.NullSkippingIterable;
import org.eclipse.lsat.common.util.ObjIntFunction;
import org.eclipse.lsat.common.util.SuppliedIterable;
import org.eclipse.lsat.common.util.UniqueIterable;

public final class IterableUtil {
    private IterableUtil() {
    }

    public static <E, T> Iterable<E> iterate(T owner, ObjIntFunction<? super T, E> getter, ToIntFunction<? super T> size) {
        return new SuppliedIterable(() -> IteratorUtil.iterate(owner, getter, size));
    }

    public static <E> Iterable<E> unique(Iterable<E> source) {
        return new UniqueIterable<E>(source);
    }

    public static <E> Iterable<E> notNull(Iterable<E> source) {
        return new NullSkippingIterable<E>(source);
    }

    @SafeVarargs
    public static final <T> Iterable<T> join(Iterable<? extends T> ... iterables) {
        return IterableUtil.wrap(IterableUtil.asList(iterables), i -> {
            Iterator<Iterator> mapped = IteratorUtil.map(i, Iterable::iterator);
            return new CompoundIterator(mapped);
        });
    }

    public static <E> String joinfields(Iterable<E> source, CharSequence separator, CharSequence begin, CharSequence end) {
        StringBuilder result = new StringBuilder(begin);
        Iterator<E> i = source.iterator();
        while (i.hasNext()) {
            result.append(i.next());
            if (!i.hasNext()) continue;
            result.append(separator);
        }
        result.append(end);
        return result.toString();
    }

    public static final boolean contains(Iterable<?> iterable, Object o) {
        return iterable instanceof Collection ? ((Collection)iterable).contains(o) : IteratorUtil.contains(iterable.iterator(), o);
    }

    public static final <T extends Comparable<? super T>> T min(Iterable<? extends T> iterable, T _default) {
        return iterable == null ? _default : IteratorUtil.min(iterable.iterator(), _default);
    }

    public static final <T extends Comparable<? super T>> T max(Iterable<? extends T> iterable, T _default) {
        return iterable == null ? _default : IteratorUtil.max(iterable.iterator(), _default);
    }

    public static int size(Iterable<?> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        int size = 0;
        for (Object o : iterable) {
            ++size;
        }
        return size;
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).isEmpty();
        }
        return !iterable.iterator().hasNext();
    }

    public static <T> T first(Iterable<T> iterable) {
        if (iterable instanceof Queue) {
            return (T)((Queue)iterable).peek();
        }
        return IteratorUtil.safeNext(iterable.iterator());
    }

    public static <T> T last(Iterable<T> iterable) {
        if (iterable instanceof Deque) {
            return (T)((Deque)iterable).peekLast();
        }
        T last2 = null;
        for (T last2 : iterable) {
        }
        return last2;
    }

    public static <T> Iterable<T> drop(Iterable<T> iterable, int amount) {
        return IterableUtil.wrap(iterable, i -> IteratorUtil.drop(i, amount));
    }

    public static <T, C extends Comparable<? super C>> List<T> sortedBy(Iterable<T> source, Function<? super T, C> functor) {
        return IterableUtil.sortedBy(source, functor, new Comparator<C>(){

            @Override
            public int compare(C o1, C o2) {
                return o1.compareTo(o2);
            }
        });
    }

    public static <T, C> List<T> sortedBy(Iterable<T> source, final Function<? super T, C> functor, final Comparator<? super C> comparator) {
        LinkedList<T> result = IterableUtil.asList(source);
        Collections.sort(result, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return Objects.compare(functor.apply(o1), functor.apply(o2), comparator);
            }
        });
        return result;
    }

    public static <Input> Iterable<Input> inReversedOrder(final List<Input> list) {
        return new LoggableIterable<Input>(){

            @Override
            public Iterator<Input> iterator() {
                return new Iterator<Input>(list){
                    private final ListIterator<Input> iterator;
                    {
                        this.iterator = list.listIterator(list.size());
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasPrevious();
                    }

                    @Override
                    public Input next() {
                        return this.iterator.previous();
                    }

                    @Override
                    public void remove() {
                        this.iterator.remove();
                    }
                };
            }
        };
    }

    public static Object[] toArray(Iterable<?> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).toArray();
        }
        return IteratorUtil.toArray(iterable.iterator());
    }

    public static <T> T[] toArray(Iterable<?> iterable, Class<T> type) {
        if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            return collection.toArray((Object[])Array.newInstance(type, collection.size()));
        }
        return IteratorUtil.toArray(iterable.iterator(), type);
    }

    public static <T> LinkedList<T> asList(Iterable<T> iterable) {
        if (iterable instanceof LinkedList) {
            return (LinkedList)iterable;
        }
        return IteratorUtil.asList(iterable.iterator());
    }

    public static <T> ArrayList<T> asList(Iterable<T> iterable, int initialCapacity) {
        if (iterable instanceof ArrayList) {
            return (ArrayList)iterable;
        }
        return IteratorUtil.asList(iterable.iterator(), initialCapacity);
    }

    @SafeVarargs
    public static <T> List<T> asList(T ... array) {
        return array == null ? Collections.emptyList() : Arrays.asList(array);
    }

    public static <T> Set<T> asSet(Iterable<T> iterable) {
        if (iterable instanceof Set) {
            return (Set)iterable;
        }
        return IteratorUtil.asSet(iterable.iterator());
    }

    public static <T> LinkedHashSet<T> asOrderedSet(Iterable<T> iterable) {
        return IteratorUtil.asOrderedSet(iterable.iterator());
    }

    public static <Input, Output> Iterable<Output> wrap(Iterable<Input> iterable, Function<Iterator<Input>, Iterator<Output>> functor) {
        return new SuppliedIterable(() -> (Iterator)functor.apply(iterable.iterator()));
    }

    public static <Input, Output> BranchIterable<Output> branchWrap(Iterable<Input> iterable, Function<Iterator<Input>, BranchIterator<Output>> functor) {
        return new BranchIterableImpl(() -> (BranchIterator)functor.apply(iterable.iterator()));
    }

    private static class BranchIterableImpl<T>
    extends SuppliedIterable<T>
    implements BranchIterable<T> {
        public BranchIterableImpl(Supplier<? extends BranchIterator<T>> supplier) {
            super(supplier);
        }

        @Override
        public BranchIterator<T> iterator() {
            return (BranchIterator)super.iterator();
        }
    }
}

