/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.timinganalysis.ui.launch;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.lsat.common.emf.common.util.URIHelper;
import org.eclipse.lsat.timinganalysis.ui.launch.TimingAnalysisLaunchAttributes;

public class TimingAnalysisUtil {
    private TimingAnalysisUtil() {
    }

    public static String getLaunchName(IFile dispatchFile, IFile settingFile, String showTargetName) {
        String prefix = TimingAnalysisUtil.getPrefix(dispatchFile, settingFile);
        String targetName = TimingAnalysisUtil.getShowTargetName(showTargetName);
        if (targetName.isEmpty()) {
            return prefix;
        }
        return prefix + " (" + targetName + ")";
    }

    public static String getName(IFile file) {
        return file == null ? "Unknown" : URIHelper.baseName((IResource)file);
    }

    private static String getPrefix(IFile dispatchFile, IFile settingFile) {
        return TimingAnalysisUtil.getPrefix(TimingAnalysisUtil.getName(dispatchFile), TimingAnalysisUtil.getName(settingFile));
    }

    private static String getPrefix(String dispatchName, String settingName) {
        if (dispatchName.contains(settingName)) {
            return TimingAnalysisUtil.cap(dispatchName);
        }
        if (settingName.contains(dispatchName)) {
            return TimingAnalysisUtil.cap(settingName);
        }
        return TimingAnalysisUtil.cap(dispatchName) + " " + TimingAnalysisUtil.cap(settingName);
    }

    private static String cap(String str) {
        if (str.length() > 0) {
            return str.substring(0, 1).toUpperCase() + str.substring(1);
        }
        return str;
    }

    private static String getShowTargetName(String target) {
        if (target == null) {
            return "";
        }
        if (TimingAnalysisLaunchAttributes.GANTT_CHART.endsWith(target)) {
            return "";
        }
        if (TimingAnalysisLaunchAttributes.CRITICAL_PATH.endsWith(target)) {
            return "Critical path";
        }
        if (TimingAnalysisLaunchAttributes.STOCHASTIC_IMPACT.endsWith(target)) {
            return "Stochastic impact";
        }
        if (TimingAnalysisLaunchAttributes.NO_GANTT_CHART.endsWith(target)) {
            return "No gantt chart";
        }
        return target;
    }
}

