/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.core.java.codeaction;

import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4mp.jdt.core.java.codeaction.IJavaCodeActionParticipant;
import org.eclipse.lsp4mp.jdt.core.java.codeaction.JavaCodeActionContext;
import org.eclipse.lsp4mp.jdt.core.java.codeaction.JavaCodeActionResolveContext;
import org.eclipse.lsp4mp.jdt.internal.core.java.AbstractJavaFeatureDefinition;

public class JavaCodeActionDefinition
extends AbstractJavaFeatureDefinition<IJavaCodeActionParticipant>
implements IJavaCodeActionParticipant {
    private static final Logger LOGGER = Logger.getLogger(JavaCodeActionDefinition.class.getName());
    private static final String KIND_ATTR = "kind";
    private static final String TARGET_DIAGNOSTIC_ATTR = "targetDiagnostic";
    private final String kind;
    private final String targetDiagnostic;

    public JavaCodeActionDefinition(IConfigurationElement element) {
        super(element);
        this.kind = JavaCodeActionDefinition.getKind(element);
        this.targetDiagnostic = element.getAttribute(TARGET_DIAGNOSTIC_ATTR);
    }

    private static String getKind(IConfigurationElement element) throws InvalidRegistryObjectException {
        String kind = element.getAttribute(KIND_ATTR);
        return !StringUtils.isEmpty((CharSequence)kind) ? kind : "quickfix";
    }

    @Override
    public String getParticipantId() {
        try {
            return ((IJavaCodeActionParticipant)this.getParticipant()).getParticipantId();
        }
        catch (CoreException e) {
            LOGGER.log(Level.WARNING, "Unable to get CodeAction participant", e);
            return "";
        }
    }

    @Override
    public boolean isAdaptedForCodeAction(JavaCodeActionContext context, IProgressMonitor monitor) {
        try {
            return ((IJavaCodeActionParticipant)this.getParticipant()).isAdaptedForCodeAction(context, monitor);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while calling isAdaptedForCodeAction", e);
            return false;
        }
    }

    @Override
    public List<? extends CodeAction> getCodeActions(JavaCodeActionContext context, Diagnostic diagnostic, IProgressMonitor monitor) {
        try {
            List<? extends CodeAction> codeActions = ((IJavaCodeActionParticipant)this.getParticipant()).getCodeActions(context, diagnostic, monitor);
            return codeActions != null ? codeActions : Collections.emptyList();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while calling getCodeActions", e);
            return Collections.emptyList();
        }
    }

    @Override
    public CodeAction resolveCodeAction(JavaCodeActionResolveContext context) {
        try {
            return ((IJavaCodeActionParticipant)this.getParticipant()).resolveCodeAction(context);
        }
        catch (CoreException e) {
            LOGGER.log(Level.WARNING, "Unable to get CodeAction participant", e);
            return context.getUnresolved();
        }
    }

    public String getKind() {
        return this.kind;
    }

    public String getTargetDiagnostic() {
        return this.targetDiagnostic;
    }
}

