/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.core.java.validators.annotations;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.lsp4mp.jdt.internal.core.java.validators.annotations.AnnotationAttributeRule;
import org.eclipse.lsp4mp.jdt.internal.core.java.validators.annotations.AnnotationRule;

public class AnnotationValidator {
    private final Map<String, AnnotationRule> rulesByAnnotation = new HashMap<String, AnnotationRule>();

    public void registerRule(AnnotationRule newRule) {
        String annotation = newRule.getAnnotation();
        AnnotationRule existingRule = this.rulesByAnnotation.get(annotation);
        if (existingRule == null) {
            this.rulesByAnnotation.put(annotation, newRule);
        } else {
            newRule.getRules().forEach(attributeRule -> {
                if (!existingRule.getRules().contains(attributeRule)) {
                    existingRule.getRules().add((AnnotationAttributeRule)attributeRule);
                }
            });
        }
    }

    public void unregisterRule(AnnotationRule rule) {
        String annotation = rule.getAnnotation();
        AnnotationRule existingRule = this.rulesByAnnotation.get(annotation);
        if (existingRule != null) {
            rule.getRules().forEach(attributeRule -> existingRule.getRules().remove(attributeRule));
        }
    }

    public String validate(String value, AnnotationAttributeRule rule) {
        if (rule == null) {
            return null;
        }
        return rule.validate(value);
    }

    public Collection<AnnotationRule> getRules() {
        return this.rulesByAnnotation.values();
    }
}

