/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.provider.spec;

import com.google.common.base.Strings;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.provider.IItemDescriptionProvider;
import org.eclipse.emf.compare.provider.IItemStyledLabelProvider;
import org.eclipse.emf.compare.provider.MatchItemProvider;
import org.eclipse.emf.compare.provider.spec.OverlayImageProvider;
import org.eclipse.emf.compare.provider.utils.ComposedStyledString;
import org.eclipse.emf.compare.provider.utils.IStyledString;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;

public class MatchItemProviderSpec
extends MatchItemProvider
implements IItemStyledLabelProvider,
IItemDescriptionProvider {
    private final OverlayImageProvider overlayProvider;
    private final AdapterFactoryItemDelegator itemDelegator = new AdapterFactoryItemDelegator(this.getRootAdapterFactory());

    public MatchItemProviderSpec(AdapterFactory adapterFactory) {
        super(adapterFactory);
        this.overlayProvider = new OverlayImageProvider(this.getResourceLocator());
    }

    public Object getImage(Object object) {
        Match match = (Match)object;
        Object ret = this.itemDelegator.getImage((Object)match.getLeft());
        if (ret == null) {
            ret = this.itemDelegator.getImage((Object)match.getRight());
        }
        if (ret == null) {
            ret = this.itemDelegator.getImage((Object)match.getOrigin());
        }
        if (ret == null) {
            ret = super.getImage(object);
        }
        Object matchImage = this.overlayProvider.getComposedImage(match, ret);
        ret = this.overlayImage(object, matchImage);
        return ret;
    }

    public String getText(Object object) {
        Match match = (Match)object;
        String ret = this.itemDelegator.getText((Object)match.getLeft());
        if (Strings.isNullOrEmpty((String)ret)) {
            ret = this.itemDelegator.getText((Object)match.getRight());
        }
        if (Strings.isNullOrEmpty((String)ret)) {
            ret = this.itemDelegator.getText((Object)match.getOrigin());
        }
        if (Strings.isNullOrEmpty((String)ret)) {
            ret = super.getText(object);
        }
        return ret;
    }

    public IStyledString.IComposedStyledString getStyledText(Object object) {
        ComposedStyledString styledString = new ComposedStyledString(this.getText(object));
        return styledString;
    }

    public String getDescription(Object object) {
        return this.getText(object);
    }
}

