/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.internal.extension.impl;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.compare.rcp.internal.extension.IItemDescriptor;
import org.eclipse.emf.compare.rcp.internal.extension.IItemRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemRegistry<T>
implements IItemRegistry<T> {
    private final Map<String, IItemDescriptor<T>> registry = new ConcurrentHashMap<String, IItemDescriptor<T>>();

    @Override
    public IItemDescriptor<T> getHighestRankingDescriptor() {
        List<IItemDescriptor<T>> items = this.getItemDescriptors();
        if (items.size() > 0) {
            return Collections.max(items);
        }
        return null;
    }

    @Override
    public List<IItemDescriptor<T>> getItemDescriptors() {
        return Lists.newArrayList(this.registry.values());
    }

    @Override
    public IItemDescriptor<T> add(IItemDescriptor<T> itemDescriptor) {
        return this.registry.put(itemDescriptor.getID(), itemDescriptor);
    }

    @Override
    public IItemDescriptor<T> remove(String className) {
        return this.registry.remove(className);
    }

    @Override
    public void clear() {
        this.registry.clear();
    }

    @Override
    public int size() {
        return this.registry.size();
    }

    @Override
    public IItemDescriptor<T> getItemDescriptor(String qualifiedClassName) {
        return this.registry.get(qualifiedClassName);
    }
}

