/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical.resolver;

import com.google.common.base.Optional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyFoundEvent<T> {
    private final T from;
    private final T to;
    private final Optional<T> parent;

    public DependencyFoundEvent(T from, T to, Optional<T> parent) {
        this.from = from;
        this.to = to;
        this.parent = parent;
    }

    public DependencyFoundEvent(T from, T to) {
        this.from = from;
        this.to = to;
        this.parent = Optional.absent();
    }

    public T getFrom() {
        return this.from;
    }

    public T getTo() {
        return this.to;
    }

    public Optional<T> getParent() {
        return this.parent;
    }

    public boolean hasParent() {
        return this.parent.isPresent();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DependencyFoundEvent)) {
            return false;
        }
        DependencyFoundEvent event = (DependencyFoundEvent)obj;
        if (this.from == null != (event.from == null)) {
            return false;
        }
        if (this.to == null != (event.to == null)) {
            return false;
        }
        if (this.parent == null != (event.parent == null)) {
            return false;
        }
        if (this.from != null && !this.from.equals(event.from)) {
            return false;
        }
        if (this.to != null && !this.to.equals(event.to)) {
            return false;
        }
        return this.parent == null || this.parent.equals(event.parent);
    }

    public int hashCode() {
        int hashCode = this.from == null && this.to == null ? 0 : (this.from == null ? this.to.hashCode() : (this.to == null ? this.from.hashCode() : this.from.hashCode() + this.to.hashCode()));
        if (this.parent != null) {
            hashCode += this.parent.hashCode();
        }
        return hashCode;
    }
}

