/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.jvm;

import java.util.Queue;
import org.eclipse.internal.net4j.connector.Connector;
import org.eclipse.net4j.buffer.IBuffer;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.connector.ConnectorException;
import org.eclipse.net4j.connector.ConnectorLocation;
import org.eclipse.net4j.connector.ConnectorState;
import org.eclipse.net4j.internal.jvm.bundle.OM;
import org.eclipse.net4j.jvm.IJVMConnector;
import org.eclipse.net4j.protocol.IProtocol;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.security.INegotiationContext;
import org.eclipse.spi.net4j.InternalChannel;

public abstract class JVMConnector
extends Connector
implements IJVMConnector {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, JVMConnector.class);
    private JVMConnector peer;
    private String name;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JVMConnector getPeer() {
        return this.peer;
    }

    public void setPeer(JVMConnector peer) {
        this.peer = peer;
    }

    public String getURL() {
        return "jvm://" + this.name;
    }

    public ConnectorLocation getLocation() {
        return null;
    }

    public void setState(ConnectorState newState) throws ConnectorException {
        super.setState(newState);
    }

    public boolean waitForConnection(long timeout) throws ConnectorException {
        return super.waitForConnection(timeout);
    }

    public void multiplexChannel(IChannel localChannel) {
        short channelIndex = localChannel.getChannelIndex();
        InternalChannel peerChannel = this.peer.getChannel(channelIndex);
        if (peerChannel == null) {
            throw new IllegalStateException("peerChannel == null");
        }
        Queue localQueue = ((InternalChannel)localChannel).getSendQueue();
        IBuffer buffer = (IBuffer)localQueue.poll();
        if (TRACER.isEnabled()) {
            TRACER.trace("Multiplexing " + buffer.formatContent(true));
        }
        buffer.flip();
        peerChannel.handleBufferFromMultiplexer(buffer);
    }

    protected INegotiationContext createNegotiationContext() {
        throw new UnsupportedOperationException();
    }

    protected void registerChannelWithPeer(int channelID, short channelIndex, IProtocol protocol, long timeoutIgnored) throws ConnectorException {
        try {
            InternalChannel channel = this.getPeer().createChannel(channelID, channelIndex, protocol.getType());
            if (channel == null) {
                throw new ConnectorException("Failed to register channel with peer");
            }
            channel.activate();
        }
        catch (ConnectorException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConnectorException((Throwable)ex);
        }
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.name, "name");
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.leaveConnecting();
    }
}

