/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOClass;
import org.eclipse.emf.cdo.common.model.CDOFeature;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.impl.CDOResourceImpl;
import org.eclipse.emf.cdo.spi.common.InternalCDORevision;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.BasicEObjectImpl;
import org.eclipse.emf.ecore.impl.EAttributeImpl;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.impl.EDataTypeImpl;
import org.eclipse.emf.ecore.impl.EReferenceImpl;
import org.eclipse.emf.ecore.impl.EStructuralFeatureImpl;
import org.eclipse.emf.ecore.impl.ETypedElementImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.internal.cdo.CDOObjectImpl;
import org.eclipse.emf.internal.cdo.CDORevisionManagerImpl;
import org.eclipse.emf.internal.cdo.CDOStateMachine;
import org.eclipse.emf.internal.cdo.CDOTransactionImpl;
import org.eclipse.emf.internal.cdo.CDOViewImpl;
import org.eclipse.emf.internal.cdo.CDOWrapperImpl;
import org.eclipse.emf.internal.cdo.InternalCDOObject;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.util.GenUtil;
import org.eclipse.emf.internal.cdo.util.ModelUtil;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.collection.MoveableList;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CDOLegacyImpl
extends CDOWrapperImpl
implements Adapter.Internal {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_OBJECT, CDOLegacyImpl.class);
    private CDOState state = CDOState.TRANSIENT;
    private CDOResourceImpl resource;
    private InternalCDORevision revision;

    @Override
    public CDOState cdoState() {
        return this.state;
    }

    public InternalCDORevision cdoRevision() {
        return this.revision;
    }

    @Override
    public CDOResourceImpl cdoResource() {
        return this.resource;
    }

    @Override
    public CDOClass cdoClass() {
        return CDOObjectImpl.getCDOClass(this);
    }

    @Override
    public CDOViewImpl cdoView() {
        if (this.view == null) {
            this.view = CDOObjectImpl.getCDOView(this);
        }
        return this.view;
    }

    @Override
    public void cdoReload() {
        CDOStateMachine.INSTANCE.reload(this);
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }

    @Override
    public CDOState cdoInternalSetState(CDOState state) {
        if (this.state != state) {
            if (TRACER.isEnabled()) {
                TRACER.format("Setting state {0} for {1}", new Object[]{state, this});
            }
            CDOState tmp = this.state;
            this.state = state;
            this.adjustEProxy();
            return tmp;
        }
        return null;
    }

    @Override
    public void cdoInternalSetRevision(CDORevision revision) {
        if (TRACER.isEnabled()) {
            TRACER.format("Setting revision: {0}", new Object[]{revision});
        }
        this.revision = (InternalCDORevision)revision;
    }

    @Override
    public void cdoInternalSetResource(CDOResource resource) {
        if (TRACER.isEnabled()) {
            TRACER.format("Setting resource: {0}", new Object[]{resource});
        }
        this.resource = (CDOResourceImpl)resource;
    }

    @Override
    public void cdoInternalPostAttach() {
    }

    @Override
    public void cdoInternalPostDetach() {
    }

    @Override
    public void cdoInternalPreCommit() {
        this.transferInstanceToRevision();
        CDORevisionManagerImpl revisionManager = this.view.getSession().getRevisionManager();
        InternalCDORevision revision = this.cdoRevision();
        InternalCDORevision originRevision = revisionManager.getRevisionByVersion(revision.getID(), -1, revision.getVersion() - 1, false);
        CDOTransactionImpl transaction = this.cdoView().toTransaction();
        transaction.registerRevisionDelta(this.cdoRevision().compare((CDORevision)originRevision));
    }

    @Override
    public void cdoInternalPostLoad() {
        this.transferRevisionToInstance();
    }

    public String toString() {
        if (this.id == null) {
            return String.valueOf(this.eClass().getName()) + "?";
        }
        return String.valueOf(this.eClass().getName()) + "@" + this.id;
    }

    public InternalEObject getTarget() {
        return this.instance;
    }

    public void setTarget(Notifier newTarget) {
        if (!(newTarget instanceof InternalEObject)) {
            throw new IllegalArgumentException("Not an InternalEObject: " + newTarget.getClass().getName());
        }
        this.instance = (InternalEObject)newTarget;
    }

    public void unsetTarget(Notifier oldTarget) {
        if (oldTarget instanceof InternalEObject) {
            if (this.instance == oldTarget) {
                this.instance = null;
            }
        } else {
            throw new IllegalArgumentException("Not an InternalEObject: " + oldTarget.getClass().getName());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void transferInstanceToRevision() {
        CDOViewImpl view;
        if (TRACER.isEnabled()) {
            TRACER.format("Transfering instance to revision: {0} --> {1}", new Object[]{this.instance, this.revision});
        }
        if ((view = this.cdoView()) == null) {
            throw new ImplementationError("view == null");
        }
        EObject container = this.instance.eContainer();
        if (container != null) {
            if (container instanceof CDOResource) {
                this.revision.setResourceID(((CDOResource)container).cdoID());
                this.revision.setContainerID(CDOID.NULL);
                this.revision.setContainingFeatureID(0);
            } else {
                this.revision.setResourceID(CDOID.NULL);
                CDOID containerID = view.provideCDOID(container);
                if (containerID.isNull()) {
                    throw new ImplementationError("containerID.isNull()");
                }
                int containerFeatureID = this.instance.eContainerFeatureID();
                this.revision.setContainerID(containerID);
                this.revision.setContainingFeatureID(containerFeatureID);
            }
        }
        CDOClass cdoClass = this.revision.getCDOClass();
        CDOFeature[] features = cdoClass.getAllFeatures();
        int i = 0;
        while (i < features.length) {
            CDOFeature feature = features[i];
            Object instanceValue = this.getInstanceValue(this.instance, feature);
            if (feature.isMany()) {
                MoveableList revisionList = this.revision.getList(feature);
                revisionList.clear();
                if (instanceValue != null) {
                    if (!(instanceValue instanceof InternalEList)) throw new ImplementationError("Not an InternalEList: " + instanceValue.getClass().getName());
                    InternalEList instanceList = (InternalEList)instanceValue;
                    if (instanceList != null) {
                        Iterator it = instanceList.basicIterator();
                        while (it.hasNext()) {
                            Object instanceElement = it.next();
                            if (instanceElement != null && feature.isReference()) {
                                instanceElement = view.convertObjectToID(instanceElement);
                            }
                            revisionList.add(instanceElement);
                        }
                    }
                }
            } else {
                if (instanceValue != null && feature.isReference()) {
                    instanceValue = view.convertObjectToID(instanceValue);
                }
                this.revision.setValue(feature, instanceValue);
            }
            ++i;
        }
    }

    protected void transferRevisionToInstance() {
        CDOViewImpl view;
        if (TRACER.isEnabled()) {
            TRACER.format("Transfering revision to instance: {0} --> {1}", new Object[]{this.revision, this.instance});
        }
        if ((view = this.cdoView()) == null) {
            throw new ImplementationError("view == null");
        }
        boolean deliver = this.instance.eDeliver();
        if (deliver) {
            this.instance.eSetDeliver(false);
        }
        try {
            CDOFeature[] features;
            this.transferContainmentToInstance(view);
            CDOClass cdoClass = this.revision.getCDOClass();
            CDOFeature[] cDOFeatureArray = features = cdoClass.getAllFeatures();
            int n = features.length;
            int n2 = 0;
            while (n2 < n) {
                CDOFeature feature = cDOFeatureArray[n2];
                this.transferFeatureToInstance(view, feature);
                ++n2;
            }
        }
        finally {
            if (deliver) {
                this.instance.eSetDeliver(true);
            }
        }
    }

    protected void transferContainmentToInstance(CDOViewImpl view) {
        CDOID containerID = this.revision.getContainerID();
        if (containerID.isNull()) {
            CDOID resourceID = this.revision.getResourceID();
            Resource.Internal resource = (Resource.Internal)view.getObject(resourceID);
            this.transferResourceToInstance(resource);
        } else {
            int containingFeatureID = this.revision.getContainingFeatureID();
            InternalEObject container = this.convertPotentialID(view, containerID);
            ((BasicEObjectImpl)this.instance).eBasicSetContainer(container, containingFeatureID, null);
        }
    }

    public void transferResourceToInstance(Resource.Internal resource) {
        Method method = ReflectUtil.getMethod(BasicEObjectImpl.class, (String)"eSetDirectResource", (Class[])new Class[]{Resource.Internal.class});
        try {
            ReflectUtil.invokeMethod((Method)method, (Object)this.instance, (Object[])new Object[]{resource});
        }
        catch (InvocationTargetException ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }

    protected void transferFeatureToInstance(CDOViewImpl view, CDOFeature feature) {
        Object value = this.revision.getValue(feature);
        if (feature.isMany()) {
            InternalEList instanceList = (InternalEList)this.getInstanceValue(this.instance, feature);
            if (instanceList != null) {
                this.clearEList((InternalEList<Object>)instanceList);
                if (value != null) {
                    List revisionList = (List)value;
                    for (Object element : revisionList) {
                        if (feature.isReference()) {
                            element = this.convertPotentialID(view, element);
                        }
                        instanceList.basicAdd(element, null);
                    }
                }
            }
        } else {
            if (feature.isReference()) {
                value = this.convertPotentialID(view, value);
            }
            this.setInstanceValue(this.instance, feature, value);
        }
    }

    protected InternalEObject convertPotentialID(CDOViewImpl view, Object potentialID) {
        if (potentialID instanceof CDOID) {
            CDOID id = (CDOID)potentialID;
            if (id.isNull()) {
                return null;
            }
            potentialID = view.getObject(id, false);
        }
        if (potentialID instanceof InternalCDOObject) {
            potentialID = ((InternalCDOObject)potentialID).cdoInternalInstance();
        }
        if (potentialID instanceof InternalEObject) {
            return (InternalEObject)potentialID;
        }
        throw new ImplementationError();
    }

    protected Object getInstanceValue(InternalEObject instance, CDOFeature feature) {
        EStructuralFeature eFeature = ModelUtil.getEFeature(feature, this.cdoView().getSession().getPackageRegistry());
        return instance.eGet(eFeature);
    }

    protected void setInstanceValue(InternalEObject instance, CDOFeature feature, Object value) {
        String featureName;
        String fieldName;
        Class<Object> instanceClass = instance.getClass();
        Field field = ReflectUtil.getField(instanceClass, (String)(fieldName = (featureName = feature.getName())));
        if (field == null && feature.getType() == CDOType.BOOLEAN && (instanceClass.isAssignableFrom(EAttributeImpl.class) || instanceClass.isAssignableFrom(EClassImpl.class) || instanceClass.isAssignableFrom(EDataTypeImpl.class) || instanceClass.isAssignableFrom(EReferenceImpl.class) || instanceClass.isAssignableFrom(EStructuralFeatureImpl.class) || instanceClass.isAssignableFrom(ETypedElementImpl.class))) {
            String flagName = String.valueOf(GenUtil.getFeatureUpperName(featureName)) + "_EFLAG";
            int flagsMask = CDOLegacyImpl.getEFlagMask(instanceClass, flagName);
            field = ReflectUtil.getField(instanceClass, (String)"eFlags");
            int flags = (Integer)ReflectUtil.getValue((Field)field, (Object)instance);
            boolean on = (Boolean)value;
            flags = on ? (flags |= flagsMask) : (flags &= ~flagsMask);
            ReflectUtil.setValue((Field)field, (Object)instance, (Object)flags);
            return;
        }
        if (field == null) {
            throw new ImplementationError("Field not found: " + fieldName);
        }
        ReflectUtil.setValue((Field)field, (Object)instance, (Object)value);
    }

    protected void adjustEProxy() {
        if (this.state == CDOState.PROXY) {
            if (!this.instance.eIsProxy()) {
                URI uri = URI.createURI((String)("cdo:proxy#" + this.id));
                if (TRACER.isEnabled()) {
                    TRACER.format("Setting proxyURI {0} for {1}", new Object[]{uri, this.instance});
                }
                this.instance.eSetProxyURI(uri);
            }
        } else if (this.instance.eIsProxy()) {
            if (TRACER.isEnabled()) {
                TRACER.format("Unsetting proxyURI for {0}", new Object[]{this.instance});
            }
            this.instance.eSetProxyURI(null);
        }
    }

    protected void clearEList(InternalEList<Object> list) {
        while (!list.isEmpty()) {
            Object toBeRemoved = list.basicGet(0);
            list.basicRemove(toBeRemoved, null);
        }
    }

    protected static int getEFlagMask(Class<?> instanceClass, String flagName) {
        Field field = ReflectUtil.getField(instanceClass, (String)flagName);
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            return (Integer)field.get(null);
        }
        catch (IllegalAccessException ex) {
            throw new ImplementationError((Throwable)ex);
        }
    }
}

