/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.emf.cdo.CDOSession;
import org.eclipse.emf.internal.cdo.CDOSessionImpl;
import org.eclipse.emf.internal.cdo.util.CDOPackageRegistryImpl;
import org.eclipse.net4j.signal.failover.IFailOverStrategy;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.factory.Factory;

public class CDOSessionFactory
extends Factory {
    public static final String PRODUCT_GROUP = "org.eclipse.emf.cdo.sessions";
    public static final String TYPE = "cdo";
    private static final String TRUE = Boolean.TRUE.toString();

    public CDOSessionFactory() {
        super(PRODUCT_GROUP, TYPE);
    }

    public CDOSession create(String description) {
        try {
            URI uri = new URI(description);
            String query = uri.getQuery();
            if (StringUtil.isEmpty((String)query)) {
                throw new IllegalArgumentException("Query is empty: " + description);
            }
            HashMap<String, String> result = new HashMap<String, String>();
            StringTokenizer tokenizer = new StringTokenizer(query, "&");
            while (tokenizer.hasMoreTokens()) {
                String key;
                String parameter = tokenizer.nextToken();
                if (StringUtil.isEmpty((String)parameter)) continue;
                int pos = parameter.indexOf(61);
                if (pos == -1) {
                    key = parameter.trim();
                    result.put(key, "");
                    continue;
                }
                key = parameter.substring(0, pos).trim();
                String value = parameter.substring(pos + 1);
                result.put(key, value);
            }
            String repositoryName = (String)result.get("repositoryName");
            boolean legacySupportEnabled = TRUE.equals(result.get("legacySupportEnabled"));
            boolean automaticPackageRegistry = TRUE.equals(result.get("automaticPackageRegistry"));
            return CDOSessionFactory.createSession(repositoryName, legacySupportEnabled, automaticPackageRegistry, null);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static CDOSession get(IManagedContainer container, String description) {
        return (CDOSession)container.getElement(PRODUCT_GROUP, TYPE, description);
    }

    public static CDOSessionImpl createSession(String repositoryName, boolean legacySupportEnabled, boolean automaticPackageRegistry, IFailOverStrategy failOverStrategy) {
        CDOSessionImpl session = new CDOSessionImpl();
        if (automaticPackageRegistry) {
            CDOPackageRegistryImpl.SelfPopulating packageRegistry = new CDOPackageRegistryImpl.SelfPopulating();
            packageRegistry.setSession(session);
            session.setPackageRegistry(packageRegistry);
        }
        session.setRepositoryName(repositoryName);
        session.setLegacySupportEnabled(legacySupportEnabled);
        session.setFailOverStrategy(failOverStrategy);
        return session;
    }
}

