/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.protocol;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.emf.cdo.common.id.CDOIDLibraryDescriptor;
import org.eclipse.emf.cdo.common.id.CDOIDMetaRange;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.util.ServerException;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.protocol.OpenSessionResult;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.signal.RequestWithConfirmation;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenSessionRequest
extends RequestWithConfirmation<OpenSessionResult> {
    private static final ContextTracer PROTOCOL = new ContextTracer(OM.DEBUG_PROTOCOL, OpenSessionRequest.class);
    private String repositoryName;
    private boolean legacySupportEnabled;

    public OpenSessionRequest(IChannel channel, String repositoryName, boolean legacySupportEnabled) {
        super(channel);
        this.repositoryName = repositoryName;
        this.legacySupportEnabled = legacySupportEnabled;
    }

    protected short getSignalID() {
        return 1;
    }

    protected void requesting(ExtendedDataOutputStream out) throws IOException {
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Writing repositoryName: {0}", new Object[]{this.repositoryName});
        }
        out.writeString(this.repositoryName);
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Writing legacySupportEnabled: {0}", new Object[]{this.legacySupportEnabled});
        }
        out.writeBoolean(this.legacySupportEnabled);
    }

    protected OpenSessionResult confirming(ExtendedDataInputStream in) throws IOException {
        String packageURI;
        int sessionID = in.readInt();
        if (sessionID == -1) {
            String msg = MessageFormat.format("Repository {0} not found", this.repositoryName);
            throw new ServerException(msg);
        }
        if (sessionID == -2) {
            String msg = MessageFormat.format("Failed to open session for repository {0}", this.repositoryName);
            throw new ServerException(msg);
        }
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Read sessionID: {0}", new Object[]{sessionID});
        }
        String repositoryUUID = in.readString();
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Read repositoryUUID: {0}", new Object[]{repositoryUUID});
        }
        CDOIDLibraryDescriptor libraryDescriptor = CDOIDUtil.readLibraryDescriptor((ExtendedDataInput)in);
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Read libraryDescriptor: {0}", new Object[]{libraryDescriptor});
        }
        OpenSessionResult result = new OpenSessionResult(sessionID, repositoryUUID, libraryDescriptor);
        while ((packageURI = in.readString()) != null) {
            boolean dynamic = in.readBoolean();
            CDOIDMetaRange metaIDRange = CDOIDUtil.readMetaRange((ExtendedDataInput)in);
            String parentURI = in.readString();
            if (PROTOCOL.isEnabled()) {
                PROTOCOL.format("Read package info: uri={0}, dynamic={1}, metaIDRange={2}, parentURI={3}", new Object[]{packageURI, dynamic, metaIDRange, parentURI});
            }
            result.addPackageInfo(packageURI, dynamic, metaIDRange, parentURI);
        }
        return result;
    }
}

