/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.protocol;

import java.io.IOException;
import java.util.List;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOClassRef;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.protocol.CDOClientRequest;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryObjectTypesRequest
extends CDOClientRequest<CDOClassRef[]> {
    private static final ContextTracer PROTOCOL = new ContextTracer(OM.DEBUG_PROTOCOL, QueryObjectTypesRequest.class);
    private List<CDOID> ids;

    public QueryObjectTypesRequest(IChannel channel, List<CDOID> ids) {
        super(channel);
        this.ids = ids;
    }

    protected short getSignalID() {
        return 12;
    }

    protected void requesting(ExtendedDataOutputStream out) throws IOException {
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Writing {0} IDs", new Object[]{this.ids.size()});
        }
        out.writeInt(this.ids.size());
        for (CDOID id : this.ids) {
            if (PROTOCOL.isEnabled()) {
                PROTOCOL.format("Writing ID: {0}", new Object[]{id});
            }
            CDOIDUtil.write((ExtendedDataOutput)out, (CDOID)id);
        }
    }

    protected CDOClassRef[] confirming(ExtendedDataInputStream in) throws IOException {
        CDOClassRef[] types = new CDOClassRef[this.ids.size()];
        int i = 0;
        while (i < types.length) {
            types[i] = CDOModelUtil.readClassRef((ExtendedDataInput)in);
            if (PROTOCOL.isEnabled()) {
                PROTOCOL.format("Read type: {0}", new Object[]{types[i]});
            }
            ++i;
        }
        return types;
    }
}

