/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.buddies.protocol;

import org.eclipse.net4j.buddies.common.ICollaborationProvider;
import org.eclipse.net4j.buddies.common.ISession;
import org.eclipse.net4j.buddies.internal.common.protocol.MessageIndication;
import org.eclipse.net4j.internal.buddies.ClientSession;
import org.eclipse.net4j.internal.buddies.Self;
import org.eclipse.net4j.internal.buddies.protocol.BuddyAddedIndication;
import org.eclipse.net4j.internal.buddies.protocol.BuddyRemovedIndication;
import org.eclipse.net4j.internal.buddies.protocol.ClientBuddyStateIndication;
import org.eclipse.net4j.internal.buddies.protocol.ClientCollaborationLeftIndication;
import org.eclipse.net4j.internal.buddies.protocol.CollaborationInitiatedIndication;
import org.eclipse.net4j.internal.buddies.protocol.FacilityInstalledIndication;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.signal.SignalReactor;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;

public class ClientProtocol
extends SignalProtocol {
    private static final long GET_SESSION_TIMEOUT = 20000L;
    private static final int GET_SESSION_INTERVAL = 100;

    public String getType() {
        return "buddies";
    }

    protected SignalReactor createSignalReactor(short signalID) {
        switch (signalID) {
            case 3: {
                return new BuddyAddedIndication();
            }
            case 4: {
                return new BuddyRemovedIndication();
            }
            case 5: {
                return new ClientBuddyStateIndication();
            }
            case 7: {
                return new CollaborationInitiatedIndication();
            }
            case 8: {
                return new ClientCollaborationLeftIndication(this.getSelf());
            }
            case 12: {
                return new FacilityInstalledIndication();
            }
            case 13: {
                return new MessageIndication((ICollaborationProvider)this.getSelf());
            }
        }
        return null;
    }

    protected Self getSelf() {
        ISession session = (ISession)this.getInfraStructure();
        return (Self)session.getSelf();
    }

    public ClientSession getSession() {
        int max = 200;
        int i = 0;
        while (i < max) {
            ClientSession session = (ClientSession)this.getInfraStructure();
            if (session != null) {
                return session;
            }
            ConcurrencyUtil.sleep((long)100L);
            ++i;
        }
        throw new IllegalStateException("No session after " + max + " milliseconds");
    }
}

