/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.http.internal.common;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.internal.net4j.connector.Connector;
import org.eclipse.net4j.buffer.IBuffer;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.connector.ConnectorException;
import org.eclipse.net4j.http.common.IHTTPConnector;
import org.eclipse.net4j.http.internal.common.HTTPChannel;
import org.eclipse.net4j.http.internal.common.bundle.OM;
import org.eclipse.net4j.protocol.IProtocol;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.security.INegotiationContext;
import org.eclipse.spi.net4j.InternalChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HTTPConnector
extends Connector
implements IHTTPConnector {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, HTTPConnector.class);
    private static final byte OPERATION_NONE = 0;
    private static final byte OPERATION_OPEN = 1;
    private static final byte OPERATION_OPEN_ACK = 2;
    private static final byte OPERATION_CLOSE = 3;
    private static final byte OPERATION_BUFFER = 4;
    private String connectorID;
    private transient Queue<ChannelOperation> outputOperations = new ConcurrentLinkedQueue<ChannelOperation>();
    private transient long lastTraffic;
    public static final int OPCODE_CONNECT = 1;
    public static final int OPCODE_DISCONNECT = 2;
    public static final int OPCODE_OPERATIONS = 3;

    public HTTPConnector() {
        this.markLastTraffic();
    }

    @Override
    public String getConnectorID() {
        return this.connectorID;
    }

    public void setConnectorID(String connectorID) {
        this.connectorID = connectorID;
    }

    public Queue<ChannelOperation> getOutputQueue() {
        return this.outputOperations;
    }

    public long getLastTraffic() {
        return this.lastTraffic;
    }

    private void markLastTraffic() {
        this.lastTraffic = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void multiplexChannel(IChannel channel) {
        long outputOperationCount;
        IBuffer buffer;
        HTTPChannel httpChannel;
        HTTPChannel hTTPChannel = httpChannel = (HTTPChannel)channel;
        synchronized (hTTPChannel) {
            Queue channelQueue = httpChannel.getSendQueue();
            buffer = (IBuffer)channelQueue.poll();
            outputOperationCount = httpChannel.getOutputOperationCount();
            httpChannel.increaseOutputOperationCount();
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Multiplexing {0} (count={1})", new Object[]{buffer.formatContent(true), outputOperationCount});
        }
        this.outputOperations.add(new BufferChannelOperation(httpChannel.getChannelIndex(), outputOperationCount, buffer));
    }

    public boolean writeOutputOperations(ExtendedDataOutputStream out) throws IOException {
        do {
            ChannelOperation operation;
            if ((operation = this.outputOperations.poll()) == null && this.pollAgain()) {
                operation = this.outputOperations.poll();
            }
            if (operation == null) break;
            operation.write(out);
            this.markLastTraffic();
        } while (this.writeMoreOperations());
        out.writeByte(0);
        return !this.outputOperations.isEmpty();
    }

    public void readInputOperations(ExtendedDataInputStream in) throws IOException {
        while (true) {
            ChannelOperation operation;
            byte code = in.readByte();
            switch (code) {
                case 1: {
                    operation = new OpenChannelOperation(in);
                    break;
                }
                case 2: {
                    operation = new OpenAckChannelOperation(in);
                    break;
                }
                case 3: {
                    operation = new CloseChannelOperation(in);
                    break;
                }
                case 4: {
                    operation = new BufferChannelOperation(in);
                    break;
                }
                case 0: {
                    return;
                }
                default: {
                    throw new IOException("Invalid operation code: " + code);
                }
            }
            this.markLastTraffic();
            operation.execute();
        }
    }

    protected INegotiationContext createNegotiationContext() {
        throw new UnsupportedOperationException();
    }

    protected InternalChannel createChannelInstance() {
        return new HTTPChannel();
    }

    protected void registerChannelWithPeer(int channelID, short channelIndex, IProtocol protocol, long timeout) throws ConnectorException {
        OpenChannelOperation operation = new OpenChannelOperation(channelIndex, channelID, protocol.getType());
        this.outputOperations.add(operation);
        HTTPChannel channel = (HTTPChannel)this.getChannel(channelIndex);
        channel.waitForOpenAck(timeout);
    }

    public boolean removeChannel(IChannel channel) {
        if (super.removeChannel(channel)) {
            HTTPChannel httpChannel = (HTTPChannel)channel;
            if (!httpChannel.isInverseRemoved()) {
                CloseChannelOperation operation = new CloseChannelOperation(httpChannel);
                this.outputOperations.add(operation);
            }
            return true;
        }
        return false;
    }

    protected boolean pollAgain() {
        return false;
    }

    protected boolean writeMoreOperations() {
        return true;
    }

    private final class BufferChannelOperation
    extends ChannelOperation {
        private IBuffer buffer;

        public BufferChannelOperation(short channelIndex, long operationCount, IBuffer buffer) {
            super(channelIndex, operationCount);
            this.buffer = buffer;
        }

        public BufferChannelOperation(ExtendedDataInputStream in) throws IOException {
            super(in);
            int length = in.readShort();
            if (TRACER.isEnabled()) {
                TRACER.format("Receiving Buffer operation: operationID={0}, length={1}", new Object[]{this.getOperationCount(), length});
            }
            this.buffer = HTTPConnector.this.getBufferProvider().provideBuffer();
            ByteBuffer byteBuffer = this.buffer.startPutting(this.getChannelIndex());
            int i = 0;
            while (i < length) {
                byte b = in.readByte();
                byteBuffer.put(b);
                ++i;
            }
            this.buffer.flip();
        }

        public void write(ExtendedDataOutputStream out) throws IOException {
            super.write(out);
            this.buffer.flip();
            ByteBuffer byteBuffer = this.buffer.getByteBuffer();
            byteBuffer.position(4);
            int length = byteBuffer.limit() - byteBuffer.position();
            out.writeShort(length);
            if (TRACER.isEnabled()) {
                TRACER.format("Transmitting Buffer operation: operationID={0}, length={1}", new Object[]{this.getOperationCount(), length});
            }
            int i = 0;
            while (i < length) {
                byte b = byteBuffer.get();
                out.writeByte((int)b);
                ++i;
            }
            this.buffer.release();
        }

        public byte getOperation() {
            return 4;
        }

        public IBuffer getBuffer() {
            return this.buffer;
        }

        public void doEexecute(HTTPChannel channel) {
            channel.handleBufferFromMultiplexer(this.buffer);
            this.buffer = null;
        }

        public void dispose() {
            if (this.buffer != null) {
                this.buffer.release();
                this.buffer = null;
            }
            super.dispose();
        }
    }

    public abstract class ChannelOperation {
        private short channelIndex;
        private long operationCount;

        public ChannelOperation(short channelIndex, long operationCount) {
            this.channelIndex = channelIndex;
            this.operationCount = operationCount;
        }

        public ChannelOperation(ExtendedDataInputStream in) throws IOException {
            this.channelIndex = in.readShort();
            this.operationCount = in.readLong();
        }

        public void write(ExtendedDataOutputStream out) throws IOException {
            out.writeByte((int)this.getOperation());
            out.writeShort((int)this.channelIndex);
            out.writeLong(this.operationCount);
        }

        public abstract byte getOperation();

        public short getChannelIndex() {
            return this.channelIndex;
        }

        public long getOperationCount() {
            return this.operationCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            HTTPChannel channel = (HTTPChannel)HTTPConnector.this.getChannel(this.getChannelIndex());
            long operationCount = this.getOperationCount();
            HTTPChannel hTTPChannel = channel;
            synchronized (hTTPChannel) {
                ChannelOperation operation;
                while (operationCount < channel.getInputOperationCount()) {
                    operation = channel.getQuarantinedInputOperation(channel.getInputOperationCount());
                    if (operation == null) break;
                    operation.doEexecute(channel);
                    channel.increaseInputOperationCount();
                }
                if (operationCount == channel.getInputOperationCount()) {
                    this.doEexecute(channel);
                    channel.increaseInputOperationCount();
                    while ((operation = channel.getQuarantinedInputOperation(++operationCount)) != null) {
                        operation.doEexecute(channel);
                        channel.increaseInputOperationCount();
                    }
                } else {
                    channel.quarantineInputOperation(operationCount, this);
                }
            }
        }

        public abstract void doEexecute(HTTPChannel var1);

        public void dispose() {
        }
    }

    private final class CloseChannelOperation
    extends ChannelOperation {
        public CloseChannelOperation(HTTPChannel channel) {
            super(channel.getChannelIndex(), channel.getOutputOperationCount());
            channel.increaseOutputOperationCount();
        }

        public CloseChannelOperation(ExtendedDataInputStream in) throws IOException {
            super(in);
        }

        public byte getOperation() {
            return 3;
        }

        public void doEexecute(HTTPChannel channel) {
            channel.setInverseRemoved();
            HTTPConnector.this.inverseRemoveChannel(channel.getChannelID(), channel.getChannelIndex());
        }
    }

    private final class OpenAckChannelOperation
    extends ChannelOperation {
        private boolean success;

        public OpenAckChannelOperation(short channelIndex, boolean success) {
            super(channelIndex, 0L);
            this.success = success;
        }

        public OpenAckChannelOperation(ExtendedDataInputStream in) throws IOException {
            super(in);
            this.success = in.readBoolean();
        }

        public void write(ExtendedDataOutputStream out) throws IOException {
            super.write(out);
            out.writeBoolean(this.success);
        }

        public byte getOperation() {
            return 2;
        }

        public void doEexecute(HTTPChannel channel) {
            channel.openAck();
        }
    }

    private final class OpenChannelOperation
    extends ChannelOperation {
        private int channelID;
        private String protocolID;

        public OpenChannelOperation(short channelIndex, int channelID, String protocolID) {
            super(channelIndex, 0L);
            this.channelID = channelID;
            this.protocolID = protocolID;
        }

        public OpenChannelOperation(ExtendedDataInputStream in) throws IOException {
            super(in);
            this.channelID = in.readInt();
            this.protocolID = in.readString();
        }

        public void write(ExtendedDataOutputStream out) throws IOException {
            super.write(out);
            out.writeInt(this.channelID);
            out.writeString(this.protocolID);
        }

        public byte getOperation() {
            return 1;
        }

        public int getChannelID() {
            return this.channelID;
        }

        public String getProtocolID() {
            return this.protocolID;
        }

        public void execute() {
            HTTPChannel channel = (HTTPChannel)HTTPConnector.this.createChannel(this.channelID, this.getChannelIndex(), this.protocolID);
            if (channel == null) {
                throw new IllegalStateException("Could not open channel");
            }
            channel.increaseInputOperationCount();
            this.doEexecute(channel);
        }

        public void doEexecute(HTTPChannel channel) {
            boolean success = false;
            try {
                channel.activate();
                success = true;
            }
            finally {
                OpenAckChannelOperation operation = new OpenAckChannelOperation(this.getChannelIndex(), success);
                HTTPConnector.this.outputOperations.add(operation);
            }
        }
    }
}

