/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.signal;

import java.text.MessageFormat;
import org.eclipse.net4j.buffer.IBufferHandler;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.signal.Signal;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SignalActor<RESULT>
extends Signal {
    public static final long NO_TIMEOUT = -1L;
    private boolean terminated;
    private RESULT result;

    protected SignalActor(IChannel channel) {
        SignalProtocol protocol = SignalActor.extractSignalProtocol(channel);
        this.setProtocol(protocol);
        this.setCorrelationID(protocol.getNextCorrelationID());
    }

    public RESULT send() throws Exception {
        return this.send(-1L);
    }

    public RESULT send(long timeout) throws Exception {
        if (this.terminated) {
            throw new IllegalStateException("Terminated");
        }
        this.getProtocol().startSignal(this, timeout);
        this.terminated = true;
        return this.result;
    }

    public String toString() {
        return MessageFormat.format("{0}[{1}, {2}, correlation={3} {4}]", ReflectUtil.getSimpleName(this.getClass()), this.getSignalID(), this.getProtocol(), this.getCorrelationID(), this.terminated ? "SENT" : "UNSENT");
    }

    protected void setResult(RESULT result) {
        this.result = result;
    }

    private static SignalProtocol extractSignalProtocol(IChannel channel) {
        IBufferHandler receiveHandler = channel.getReceiveHandler();
        if (receiveHandler == null) {
            throw new IllegalArgumentException("Channel has no protocol");
        }
        if (receiveHandler instanceof SignalProtocol) {
            return (SignalProtocol)receiveHandler;
        }
        throw new IllegalArgumentException("Channel has no signal protocol");
    }
}

