/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.serializer;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.xtext.serializer.DiagnosticStringBuilder;
import org.eclipse.ocl.examples.xtext.serializer.DynamicRuleMatch;
import org.eclipse.ocl.examples.xtext.serializer.GrammarRuleVector;
import org.eclipse.ocl.examples.xtext.serializer.SerializationMatchTerm;
import org.eclipse.ocl.examples.xtext.serializer.SerializationMetaData;
import org.eclipse.ocl.examples.xtext.serializer.SerializationRule;
import org.eclipse.ocl.examples.xtext.serializer.SerializationStep;
import org.eclipse.ocl.examples.xtext.serializer.SerializationUtils;
import org.eclipse.ocl.examples.xtext.serializer.UserElementAnalysis;
import org.eclipse.ocl.examples.xtext.serializer.UserElementMatcher;
import org.eclipse.ocl.examples.xtext.serializer.UserModelAnalysis;

public abstract class SerializationMatchStep {
    private @Nullable Integer hashCode = null;

    protected int computeHashCode() {
        return this.getClass().hashCode();
    }

    public abstract boolean execute(@NonNull DynamicRuleMatch var1);

    public abstract @NonNull String getFailureReason(@NonNull DynamicRuleMatch var1);

    public abstract @NonNull Set<@NonNull SerializationMatchTerm> getMatchTermClosure();

    public final int hashCode() {
        Integer hashCode2 = this.hashCode;
        if (hashCode2 == null) {
            this.hashCode = hashCode2 = Integer.valueOf(this.computeHashCode());
        }
        return hashCode2;
    }

    public boolean isAssignTo(int variableIndex) {
        return false;
    }

    public @NonNull String toString() {
        DiagnosticStringBuilder s = new DiagnosticStringBuilder();
        this.toString(s);
        return s.toString();
    }

    public abstract void toString(@NonNull DiagnosticStringBuilder var1);

    public static class MatchStep_Assert
    extends SerializationMatchStep {
        protected final @NonNull SerializationMatchTerm matchTerm;

        public MatchStep_Assert(@NonNull SerializationMatchTerm matchTerm) {
            this.matchTerm = matchTerm;
        }

        @Override
        public int computeHashCode() {
            return super.computeHashCode() + 5 * this.matchTerm.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof MatchStep_Assert)) {
                return false;
            }
            MatchStep_Assert that = (MatchStep_Assert)obj;
            return this.matchTerm.equals(that.matchTerm);
        }

        @Override
        public boolean execute(@NonNull DynamicRuleMatch dynamicRuleMatch) {
            Integer newIntegerSolution = this.matchTerm.basicGetIntegerSolution(dynamicRuleMatch);
            if (newIntegerSolution == null) {
                dynamicRuleMatch.setFailedMatch(this);
                return false;
            }
            boolean isOk = newIntegerSolution.equals(0);
            if (!isOk) {
                dynamicRuleMatch.setFailedMatch(this);
            }
            return isOk;
        }

        @Override
        public @NonNull String getFailureReason(@NonNull DynamicRuleMatch dynamicRuleMatch) {
            Integer newIntegerSolution = this.matchTerm.basicGetIntegerSolution(dynamicRuleMatch);
            if (newIntegerSolution == null) {
                return "Failed to solve for " + this.matchTerm;
            }
            return newIntegerSolution + " rather than 0 for " + this.matchTerm;
        }

        public @NonNull SerializationMatchTerm getMatchTerm() {
            return this.matchTerm;
        }

        @Override
        public @NonNull Set<@NonNull SerializationMatchTerm> getMatchTermClosure() {
            return this.matchTerm.getChildClosure();
        }

        @Override
        public void toString(@NonNull DiagnosticStringBuilder s) {
            s.append("assert ");
            this.matchTerm.toString(s);
            s.append(" == 0");
        }
    }

    public static class MatchStep_Assign
    extends SerializationMatchStep {
        protected final int variableIndex;
        protected final @NonNull SerializationMatchTerm matchTerm;

        public MatchStep_Assign(int variableIndex, @NonNull SerializationMatchTerm matchTerm) {
            this.variableIndex = variableIndex;
            this.matchTerm = matchTerm;
        }

        @Override
        public int computeHashCode() {
            return super.computeHashCode() + 5 * this.matchTerm.hashCode() + 7 * this.variableIndex;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof MatchStep_Assign)) {
                return false;
            }
            MatchStep_Assign that = (MatchStep_Assign)obj;
            return this.matchTerm.equals(that.matchTerm) && this.variableIndex == that.variableIndex;
        }

        @Override
        public boolean execute(@NonNull DynamicRuleMatch dynamicRuleMatch) {
            Integer newIntegerSolution = this.matchTerm.basicGetIntegerSolution(dynamicRuleMatch);
            if (newIntegerSolution == null) {
                dynamicRuleMatch.setFailedMatch(this);
                return false;
            }
            assert (this.variableIndex >= 0);
            dynamicRuleMatch.putValue(this.variableIndex, newIntegerSolution);
            return true;
        }

        @Override
        public @NonNull String getFailureReason(@NonNull DynamicRuleMatch dynamicRuleMatch) {
            return "Failed to solve for " + this.matchTerm;
        }

        public @NonNull SerializationMatchTerm getMatchTerm() {
            return this.matchTerm;
        }

        @Override
        public @NonNull Set<@NonNull SerializationMatchTerm> getMatchTermClosure() {
            return this.matchTerm.getChildClosure();
        }

        public int getVariableIndex() {
            return this.variableIndex;
        }

        @Override
        public boolean isAssignTo(int variableIndex) {
            return this.variableIndex == variableIndex;
        }

        @Override
        public void toString(@NonNull DiagnosticStringBuilder s) {
            s.append("assign ");
            s.appendVariableName(this.variableIndex);
            s.append(" = ");
            this.matchTerm.toString(s);
        }
    }

    public static class MatchStep_RuleCheck
    extends SerializationMatchStep {
        protected final @NonNull EReference eReference;
        protected final @NonNull GrammarRuleVector ruleValueIndexes;

        public MatchStep_RuleCheck(EReference eReference, @NonNull GrammarRuleVector ruleValueIndexes) {
            assert (eReference != null);
            this.eReference = eReference;
            this.ruleValueIndexes = ruleValueIndexes;
            assert (eReference.isContainment());
        }

        @Override
        public int computeHashCode() {
            return super.computeHashCode() + 5 * this.eReference.hashCode() + 7 * this.ruleValueIndexes.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof MatchStep_RuleCheck)) {
                return false;
            }
            MatchStep_RuleCheck that = (MatchStep_RuleCheck)obj;
            return this.eReference == that.eReference && this.ruleValueIndexes.equals(that.ruleValueIndexes);
        }

        @Override
        public boolean execute(@NonNull DynamicRuleMatch dynamicRuleMatch) {
            UserElementAnalysis elementAnalysis = dynamicRuleMatch.getElementAnalysis();
            UserModelAnalysis modelAnalysis = elementAnalysis.getModelAnalysis();
            EObject eObject = elementAnalysis.getEObject();
            if (!this.eReference.getEContainingClass().isInstance((Object)eObject)) {
                dynamicRuleMatch.setFailedMatch(this);
                return false;
            }
            Object slotContent = eObject.eGet((EStructuralFeature)this.eReference);
            if (this.eReference.isMany()) {
                for (Object element : (List)slotContent) {
                    @NonNull EObject castElement = (EObject)element;
                    if (this.isInstance(modelAnalysis, castElement)) continue;
                    dynamicRuleMatch.setFailedMatch(this);
                    return false;
                }
            } else if (slotContent != null && !this.isInstance(modelAnalysis, (EObject)slotContent)) {
                dynamicRuleMatch.setFailedMatch(this);
                return false;
            }
            return true;
        }

        public @NonNull EReference getEReference() {
            return this.eReference;
        }

        @Override
        public @NonNull String getFailureReason(@NonNull DynamicRuleMatch dynamicRuleMatch) {
            String failureReason;
            UserElementAnalysis elementAnalysis = dynamicRuleMatch.getElementAnalysis();
            UserModelAnalysis modelAnalysis = elementAnalysis.getModelAnalysis();
            EObject eObject = elementAnalysis.getEObject();
            if (!this.eReference.getEContainingClass().isInstance((Object)eObject)) {
                return String.valueOf(this.eReference.getName()) + " container is " + eObject.eClass().getName() + " rather than " + this.eReference.getEContainingClass().getName();
            }
            Object slotContent = eObject.eGet((EStructuralFeature)this.eReference);
            if (this.eReference.isMany()) {
                for (Object element : (List)slotContent) {
                    @NonNull EObject castElement = (EObject)element;
                    String failureReason2 = this.isInstanceWithReason(modelAnalysis, castElement);
                    if (failureReason2 == null) continue;
                    return failureReason2;
                }
            } else if (slotContent != null && (failureReason = this.isInstanceWithReason(modelAnalysis, (EObject)slotContent)) != null) {
                return failureReason;
            }
            return "BUG - no reason available";
        }

        protected @Nullable String isInstanceWithReason(@NonNull UserModelAnalysis modelAnalysis, @NonNull EObject slotContent) {
            UserElementAnalysis childElementAnalysis = modelAnalysis.getElementAnalysis(slotContent);
            for (Integer ruleValueIndex : this.ruleValueIndexes) {
                DynamicRuleMatch dynamicRuleMatch = childElementAnalysis.basicCreateDynamicRuleMatch(ruleValueIndex);
                if (dynamicRuleMatch == null) continue;
                return null;
            }
            SerializationMetaData serializationMetaData = modelAnalysis.getSerializationMetaData();
            DiagnosticStringBuilder.SerializationMetaDataDiagnosticStringBuilder s = new DiagnosticStringBuilder.SerializationMetaDataDiagnosticStringBuilder(serializationMetaData);
            s.append("is not any of");
            for (Integer ruleValueIndex : this.ruleValueIndexes) {
                s.append(" ");
                ((DiagnosticStringBuilder)s).appendRuleName(ruleValueIndex);
            }
            return s.toString();
        }

        @Override
        public @NonNull Set<@NonNull SerializationMatchTerm> getMatchTermClosure() {
            @NonNull Set<@NonNull SerializationMatchTerm> emptySet = Collections.emptySet();
            return emptySet;
        }

        public @NonNull GrammarRuleVector getRuleValueIndexes() {
            return this.ruleValueIndexes;
        }

        protected boolean isInstance(@NonNull UserModelAnalysis modelAnalysis, @NonNull EObject slotContent) {
            UserElementAnalysis elementAnalysis = modelAnalysis.getElementAnalysis(slotContent);
            GrammarRuleVector elementGrammarRuleVector = elementAnalysis.getGrammarRuleVector();
            GrammarRuleVector targetRuleValueIndexes = this.ruleValueIndexes;
            GrammarRuleVector compatibleRuleValueIndexes = targetRuleValueIndexes.intersection(elementGrammarRuleVector);
            for (int ruleValueIndex : compatibleRuleValueIndexes) {
                DynamicRuleMatch dynamicRuleMatch = elementAnalysis.basicCreateDynamicRuleMatch(ruleValueIndex);
                if (dynamicRuleMatch == null) continue;
                return true;
            }
            return false;
        }

        @Override
        public void toString(@NonNull DiagnosticStringBuilder s) {
            s.append("check-rule ");
            s.append(SerializationUtils.getName((ENamedElement)SerializationUtils.getEPackage((EClassifier)SerializationUtils.getEContainingClass((EStructuralFeature)this.eReference))));
            s.append("::");
            s.append(SerializationUtils.getName((ENamedElement)SerializationUtils.getEContainingClass((EStructuralFeature)this.eReference)));
            s.append(".");
            s.append(SerializationUtils.getName((ENamedElement)this.eReference));
            s.append(" : ");
            boolean isFirst = true;
            for (Integer ruleValueIndex : this.ruleValueIndexes) {
                if (!isFirst) {
                    s.append("|");
                }
                s.appendRuleName(ruleValueIndex);
                isFirst = false;
            }
        }
    }

    public static class MatchStep_Runtime
    extends SerializationMatchStep {
        @Override
        public int computeHashCode() {
            return super.computeHashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            return obj instanceof MatchStep_Runtime;
        }

        @Override
        public boolean execute(@NonNull DynamicRuleMatch dynamicRuleMatch) {
            SerializationRule serializationRule = dynamicRuleMatch.getSerializationRule();
            UserElementAnalysis elementAnalysis = dynamicRuleMatch.getElementAnalysis();
            UserElementMatcher matcher = new UserElementMatcher(dynamicRuleMatch, elementAnalysis.getModelAnalysis(), elementAnalysis.getEObject());
            @NonNull SerializationStep @NonNull [] serializationSteps = serializationRule.getSerializationSteps();
            int index = 0;
            while (index < serializationSteps.length) {
                SerializationStep serializationStep = serializationSteps[index];
                if ((index = serializationStep.matchOuterValue(index, matcher)) >= 0) continue;
                matcher.setFailureStep(serializationStep);
                assert (matcher.hasFailed()) : "No failure for a " + serializationStep.getClass().getSimpleName();
                matcher.addFailedMatchTo(dynamicRuleMatch);
                assert (dynamicRuleMatch.matchFailed());
                return false;
            }
            if (!dynamicRuleMatch.checkNoUnusedFeatureUsage(matcher)) {
                assert (matcher.hasFailed()) : "No checkNoUnusedFeatureUsage failure";
                assert (dynamicRuleMatch.matchFailed());
                return false;
            }
            assert (!matcher.hasFailed());
            return true;
        }

        @Override
        public @NonNull String getFailureReason(@NonNull DynamicRuleMatch dynamicRuleMatch) {
            return "BUG --  missing reason";
        }

        @Override
        public @NonNull Set<@NonNull SerializationMatchTerm> getMatchTermClosure() {
            @NonNull Set<@NonNull SerializationMatchTerm> emptySet = Collections.emptySet();
            return emptySet;
        }

        @Override
        public void toString(@NonNull DiagnosticStringBuilder s) {
            s.append("runtime");
        }
    }

    public static class MatchStep_ValueCheck
    extends SerializationMatchStep {
        protected final int variableIndex;
        protected final @NonNull SerializationMatchTerm matchTerm;

        public MatchStep_ValueCheck(int variableIndex, @NonNull SerializationMatchTerm matchTerm) {
            this.variableIndex = variableIndex;
            this.matchTerm = matchTerm;
        }

        @Override
        public int computeHashCode() {
            return super.computeHashCode() + 5 * this.matchTerm.hashCode() + 7 * this.variableIndex;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof MatchStep_ValueCheck)) {
                return false;
            }
            MatchStep_ValueCheck that = (MatchStep_ValueCheck)obj;
            return this.matchTerm.equals(that.matchTerm) && this.variableIndex == that.variableIndex;
        }

        @Override
        public boolean execute(@NonNull DynamicRuleMatch dynamicRuleMatch) {
            Integer newIntegerSolution = this.matchTerm.basicGetIntegerSolution(dynamicRuleMatch);
            if (newIntegerSolution == null) {
                dynamicRuleMatch.setFailedMatch(this);
                return false;
            }
            Integer integer = dynamicRuleMatch.getValue(this.variableIndex);
            boolean isOk = newIntegerSolution.equals(integer);
            if (!isOk) {
                dynamicRuleMatch.setFailedMatch(this);
            }
            return isOk;
        }

        @Override
        public @NonNull String getFailureReason(@NonNull DynamicRuleMatch dynamicRuleMatch) {
            Integer newIntegerSolution = this.matchTerm.basicGetIntegerSolution(dynamicRuleMatch);
            if (newIntegerSolution == null) {
                return "Failed to solve for " + this.matchTerm;
            }
            Integer integer = dynamicRuleMatch.getValue(this.variableIndex);
            return newIntegerSolution + " rather than " + integer + " for " + this.matchTerm;
        }

        public @NonNull SerializationMatchTerm getMatchTerm() {
            return this.matchTerm;
        }

        @Override
        public @NonNull Set<@NonNull SerializationMatchTerm> getMatchTermClosure() {
            return this.matchTerm.getChildClosure();
        }

        public int getVariableIndex() {
            return this.variableIndex;
        }

        @Override
        public void toString(@NonNull DiagnosticStringBuilder s) {
            s.append("check-value ");
            s.appendVariableName(this.variableIndex);
            s.append(" = ");
            this.matchTerm.toString(s);
        }
    }
}

