/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.exporter.ui.contribution.base;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.provider.GenModelEditPlugin;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.converter.ui.contribution.base.ModelConverterWizard;
import org.eclipse.emf.exporter.ExporterPlugin;
import org.eclipse.emf.exporter.ModelExporter;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.osgi.service.prefs.BackingStoreException;

public abstract class ModelExporterWizard
extends ModelConverterWizard {
    protected static final String PREFERENCE_SAVE_EXPORTER = "ModelExporterWizard.SaveExporter";
    protected static final String PREFERENCE_SAVE_PACKAGE_URI = "ModelExporterWizard.SavePackageURI";
    private static final InstanceScope INSTANCE_SCOPE = new InstanceScope();

    public ModelExporter getModelExporter() {
        return (ModelExporter)this.getModelConverter();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        GenModel genModel;
        super.init(workbench, selection);
        Object object = selection.getFirstElement();
        try {
            if (object instanceof IFile) {
                URI uri = URI.createPlatformResourceURI((String)((IFile)object).getFullPath().toString(), (boolean)true);
                this.getModelExporter().loadGenModel(uri);
            } else if (object instanceof GenModel) {
                this.getModelExporter().setGenModel((GenModel)object);
            }
        }
        catch (DiagnosticException exception) {
            Diagnostic diagnostic = exception.getDiagnostic();
            DiagnosticDialog.openProblem((Shell)this.getShell(), (String)GenModelEditPlugin.INSTANCE.getString("_UI_ModelProblems_title"), (String)ExporterPlugin.INSTANCE.getString("_UI_InvalidModel_message"), (Diagnostic)diagnostic);
        }
        this.readPreferencesSettings();
        if (this.getModelExporter().getDirectoryURI() == null && (genModel = this.getModelExporter().getGenModel()) != null && genModel.eResource() != null) {
            URI uri = genModel.eResource().getURI().trimSegments(1);
            this.getModelExporter().setDirectoryURI(String.valueOf(uri.toString()) + "/");
        }
    }

    protected void readPreferencesSettings() {
        IPreferencesService preferencesService = Platform.getPreferencesService();
        ModelExporter modelExporter = this.getModelExporter();
        modelExporter.setSaveEPackageArtifactURI(preferencesService.getBoolean("org.eclipse.emf.exporter", PREFERENCE_SAVE_PACKAGE_URI, false, null));
        modelExporter.setSaveExporter(preferencesService.getBoolean("org.eclipse.emf.exporter", PREFERENCE_SAVE_EXPORTER, false, null));
    }

    protected void writePreferencesSettings() {
        IEclipsePreferences node = INSTANCE_SCOPE.getNode("org.eclipse.emf.exporter");
        ModelExporter modelExporter = this.getModelExporter();
        node.putBoolean(PREFERENCE_SAVE_PACKAGE_URI, modelExporter.isSaveEPackageArtifactURI());
        node.putBoolean(PREFERENCE_SAVE_EXPORTER, modelExporter.isSaveExporter());
        try {
            node.flush();
        }
        catch (BackingStoreException exception) {
            ExporterPlugin.INSTANCE.log((Object)exception);
        }
    }

    protected Diagnostic doPerformFinish(Monitor monitor) throws Exception {
        Diagnostic diagnostic = this.getModelExporter().export(monitor);
        this.getModelExporter().save();
        this.writePreferencesSettings();
        return diagnostic;
    }
}

