/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mapping.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ListIterator;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingPackage;
import org.eclipse.emf.mapping.MappingRoot;
import org.eclipse.emf.mapping.command.RemoveMappingCommand;
import org.eclipse.emf.mapping.domain.MappingDomain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveOverrideCommand
extends AbstractCommand {
    protected MappingDomain mappingDomain;
    protected RemoveCommand removeCommand;
    protected Command mapCommand;

    public RemoveOverrideCommand(MappingDomain domain, RemoveCommand removeCommand) {
        super(removeCommand.doGetLabel(), removeCommand.doGetDescription());
        this.mappingDomain = domain;
        this.removeCommand = removeCommand;
    }

    protected boolean prepare() {
        return this.removeCommand.doCanExecute();
    }

    public void execute() {
        MappingRoot mappingRoot = this.mappingDomain.getMappingRoot();
        CompoundCommand subcommands = new CompoundCommand();
        for (Object removal : this.removeCommand.getCollection()) {
            ArrayList<Command> commandList = new ArrayList<Command>();
            TreeIterator objects = this.mappingDomain.treeIterator(removal);
            while (objects.hasNext()) {
                Object object = objects.next();
                for (Mapping mapping : mappingRoot.getMappings(object)) {
                    EList<EObject> outputs = mapping.getOutputs();
                    if (outputs.size() == 1 && outputs.iterator().next() == object) {
                        commandList.add(RemoveMappingCommand.create(this.mappingDomain, mapping));
                        continue;
                    }
                    commandList.add(RemoveCommand.create((EditingDomain)this.mappingDomain, (Object)mapping, (Object)MappingPackage.eINSTANCE.getMapping_Outputs(), object));
                }
            }
            ListIterator commands = commandList.listIterator(commandList.size());
            while (commands.hasPrevious()) {
                subcommands.appendAndExecute((Command)commands.previous());
            }
        }
        this.mapCommand = !subcommands.isEmpty() ? subcommands.unwrap() : null;
        this.removeCommand.doExecute();
    }

    public void undo() {
        this.removeCommand.doUndo();
        if (this.mapCommand != null) {
            this.mapCommand.undo();
        }
    }

    public void redo() {
        if (this.mapCommand != null) {
            this.mapCommand.redo();
        }
        this.removeCommand.doRedo();
    }

    public void dispose() {
        if (this.mapCommand != null) {
            this.mapCommand.dispose();
        }
        this.removeCommand.doDispose();
    }

    public Collection<?> getResult() {
        return this.removeCommand.doGetResult();
    }

    public Collection<?> getAffectedObjects() {
        return this.removeCommand.doGetAffectedObjects();
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (mappingDomain: " + this.mappingDomain + ")");
        result.append(" (mapCommand: " + this.mapCommand + ")");
        return result.toString();
    }
}

