/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.utilities;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.impl.BasicEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.dynamic.JavaClasspath;
import org.eclipse.ocl.examples.codegen.dynamic.JavaFileUtil;
import org.eclipse.ocl.examples.codegen.generator.CodeGenerator;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.LabelUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.CompilerProblem;
import org.eclipse.qvtd.compiler.ProblemHandler;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ConnectionProblem;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.PartitionProblem;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.RegionProblem;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.RuleProblem;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.TransformationProblem;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.Concurrency;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionClassAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionPropertyAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionsAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.CompositePartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionsAnalysis;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtcore.QVTcorePackage;
import org.eclipse.qvtd.pivot.qvtcore.VariableAssignment;
import org.eclipse.qvtd.pivot.qvtschedule.CastEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Connection;
import org.eclipse.qvtd.pivot.qvtschedule.DispatchRegion;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Partition;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.RuleRegion;
import org.eclipse.qvtd.pivot.qvtschedule.VerdictRegion;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;
import org.eclipse.qvtd.runtime.evaluation.Invocation;
import org.eclipse.qvtd.runtime.qvtruntimelibrary.Extent;

public class CompilerUtil
extends QVTscheduleUtil {
    public static final @NonNull Map<Object, Object> defaultSavingOptions = new HashMap<Object, Object>();

    static {
        defaultSavingOptions.put("ENCODING", "UTF-8");
        defaultSavingOptions.put("LINE_DELIMITER", "\n");
        defaultSavingOptions.put("SCHEMA_LOCATION", Boolean.TRUE);
        defaultSavingOptions.put("SCHEMA_LOCATION_IMPLEMENTATION", Boolean.TRUE);
        defaultSavingOptions.put("LINE_WIDTH", 132);
    }

    public static void addConnectionError(@NonNull ProblemHandler problemHandler, @NonNull Connection connection, @NonNull String messageTemplate, Object ... bindings) {
        String boundMessage = StringUtil.bind((String)messageTemplate, (Object[])bindings);
        problemHandler.addProblem(new ConnectionProblem(CompilerProblem.Severity.ERROR, connection, boundMessage));
    }

    public static void addConnectionWarning(@NonNull ProblemHandler problemHandler, @NonNull Connection connection, @NonNull String messageTemplate, Object ... bindings) {
        String boundMessage = StringUtil.bind((String)messageTemplate, (Object[])bindings);
        problemHandler.addProblem(new ConnectionProblem(CompilerProblem.Severity.WARNING, connection, boundMessage));
    }

    public static void addPartitionError(@NonNull ProblemHandler problemHandler, @NonNull Partition partition, @NonNull String messageTemplate, Object ... bindings) {
        String boundMessage = StringUtil.bind((String)messageTemplate, (Object[])bindings);
        problemHandler.addProblem(new PartitionProblem(CompilerProblem.Severity.ERROR, partition, boundMessage));
    }

    public static void addPartitionWarning(@NonNull ProblemHandler problemHandler, @NonNull Partition partition, @NonNull String messageTemplate, Object ... bindings) {
        String boundMessage = StringUtil.bind((String)messageTemplate, (Object[])bindings);
        problemHandler.addProblem(new PartitionProblem(CompilerProblem.Severity.WARNING, partition, boundMessage));
    }

    public static void addRegionError(@NonNull ProblemHandler problemHandler, @NonNull Region region, @NonNull String messageTemplate, Object ... bindings) {
        String boundMessage = StringUtil.bind((String)messageTemplate, (Object[])bindings);
        problemHandler.addProblem(new RegionProblem(CompilerProblem.Severity.ERROR, region, boundMessage));
    }

    public static void addRegionWarning(@NonNull ProblemHandler problemHandler, @NonNull Region region, @NonNull String messageTemplate, Object ... bindings) {
        String boundMessage = StringUtil.bind((String)messageTemplate, (Object[])bindings);
        problemHandler.addProblem(new RegionProblem(CompilerProblem.Severity.WARNING, region, boundMessage));
    }

    public static void addRuleError(@NonNull ProblemHandler problemHandler, @NonNull Rule rule, @NonNull String messageTemplate, Object ... bindings) {
        String boundMessage = StringUtil.bind((String)messageTemplate, (Object[])bindings);
        problemHandler.addProblem(new RuleProblem(CompilerProblem.Severity.ERROR, rule, boundMessage));
    }

    public static void addRuleWarning(@NonNull ProblemHandler problemHandler, @NonNull Rule rule, @NonNull String messageTemplate, Object ... bindings) {
        String boundMessage = StringUtil.bind((String)messageTemplate, (Object[])bindings);
        problemHandler.addProblem(new RuleProblem(CompilerProblem.Severity.WARNING, rule, boundMessage));
    }

    public static void addTransformationError(@NonNull ProblemHandler problemHandler, @NonNull Transformation transformation, @NonNull String messageTemplate, Object ... bindings) {
        String boundMessage = StringUtil.bind((String)messageTemplate, (Object[])bindings);
        problemHandler.addProblem(new TransformationProblem(CompilerProblem.Severity.ERROR, transformation, boundMessage));
    }

    @Deprecated
    public static void addURI(@NonNull JavaClasspath classpath, @NonNull URI uri) throws MalformedURLException {
        classpath.addURL(new URL(uri.isFile() ? uri.toString() : uri.toFileString()));
    }

    public static void assertNoResourceErrors(@NonNull String prefix, @NonNull Resource resource) {
        String message = PivotUtil.formatResourceDiagnostics((List)resource.getErrors(), (String)prefix, (String)"\n\t");
        if (message != null) assert (false) : message;
    }

    public static void assertNoResourceSetErrors(@NonNull String prefix, @NonNull Resource resource) {
        ResourceSet resourceSet = resource.getResourceSet();
        assert (resourceSet != null) : String.valueOf(prefix) + " no ResourceSet for " + resource;
        for (Resource aResource : resourceSet.getResources()) {
            if (aResource == null) continue;
            CompilerUtil.assertNoResourceErrors(prefix, aResource);
        }
    }

    public static void assertNoUnresolvedProxies(String message, Resource resource) {
        Map unresolvedProxies = EcoreUtil.UnresolvedProxyCrossReferencer.find((Resource)resource);
        if (unresolvedProxies.size() > 0) {
            StringBuilder s = new StringBuilder();
            s.append(unresolvedProxies.size());
            s.append(" unresolved proxies in '" + resource.getURI() + "' ");
            s.append(message);
            for (Map.Entry unresolvedProxy : unresolvedProxies.entrySet()) {
                s.append("\n");
                BasicEObjectImpl key = (BasicEObjectImpl)unresolvedProxy.getKey();
                s.append(key.eProxyURI());
                for (EStructuralFeature.Setting setting : (Collection)unresolvedProxy.getValue()) {
                    s.append("\n\t");
                    EObject eObject = setting.getEObject();
                    s.append(eObject.toString());
                }
            }
            assert (false) : s.toString();
        }
    }

    public static void assertNoValidationErrors(@NonNull String prefix, @NonNull Resource resource) {
        for (EObject eObject : resource.getContents()) {
            CompilerUtil.assertNoValidationErrors(String.valueOf(prefix) + " of '" + resource.getURI() + "'", eObject);
        }
    }

    public static void assertNoValidationErrors(@NonNull String string, EObject eObject) {
        Map validationContext = LabelUtil.createDefaultContext((EValidator)Diagnostician.INSTANCE);
        Diagnostic diagnostic = Diagnostician.INSTANCE.validate(eObject, validationContext);
        List children = diagnostic.getChildren();
        if (children.size() <= 0) {
            return;
        }
        StringBuilder s = new StringBuilder();
        s.append(String.valueOf(string) + ": " + children.size() + " validation errors");
        for (Diagnostic child : children) {
            Object data;
            s.append("\n\t");
            if (child.getData().size() > 0 && (data = child.getData().get(0)) instanceof Element) {
                Element eScope = (Element)data;
                while (eScope instanceof Element) {
                    eScope = eScope.eContainer();
                }
            }
            s.append(child.getMessage());
        }
        assert (false) : s.toString();
    }

    public static @NonNull JavaClasspath createDefaultQVTiClasspath() {
        JavaClasspath classpath = JavaFileUtil.createDefaultOCLClasspath();
        classpath.addClass(Invocation.class);
        classpath.addClass(Extent.class);
        return classpath;
    }

    public static <T> @NonNull Map<T, @NonNull Set<T>> computeClosure(@NonNull Map<T, @NonNull Set<T>> from2tos) {
        Set<T> tos = from2tos.keySet();
        HashMap<T, @NonNull HashSet<E>> from2tosClosure = new HashMap();
        for (Object from : tos) {
            from2tosClosure.put(from, new HashSet(from2tos.get(from)));
        }
        boolean isChanged = true;
        while (isChanged) {
            isChanged = false;
            for (T from : from2tos.keySet()) {
                Set fromTos = (Set)from2tosClosure.get(from);
                assert (fromTos != null);
                for (Object fromTo : new ArrayList(fromTos)) {
                    Set fromToTos = (Set)from2tosClosure.get(fromTo);
                    assert (fromToTos != null);
                    if (!fromTos.addAll(fromToTos)) continue;
                    isChanged = true;
                }
            }
        }
        return from2tosClosure;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static <PRA extends PartialRegionsAnalysis<PRA>> @NonNull Map<@NonNull PartialRegionAnalysis<@NonNull PRA>, @NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PRA>>> computeImmediatePredecessors(@NonNull Iterable<? extends @NonNull PartialRegionAnalysis<@NonNull PRA>> partialRegionAnalyses, @Nullable TracingOption immediatePredecessorTraceOption) {
        HashMap<@NonNull PartialRegionAnalysis<@NonNull PRA>, @NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PRA>>> consumer2producers = new HashMap<PartialRegionAnalysis<PRA>, Set<PartialRegionAnalysis<PRA>>>();
        HashMap<@NonNull PartialRegionAnalysis<@NonNull PRA>, @NonNull HashMap<@NonNull K, @NonNull @NonNull @NonNull V>> consumer2consumedElement2producers = new HashMap();
        for (PartialRegionAnalysis<PRA> partialRegionAnalysis : partialRegionAnalyses) {
            consumer2producers.put(partialRegionAnalysis, new HashSet());
        }
        for (PartialRegionAnalysis<PRA> consumer : partialRegionAnalyses) {
            Iterable<PartialRegionPropertyAnalysis<PRA>> consumedPropertyAnalyses;
            Iterable<PartialRegionClassAnalysis<PRA>> consumedClassAnalyses;
            Iterable<PartialRegionAnalysis<PRA>> explicitPredecessors;
            HashMap consumedElement2producers = null;
            if (Iterables.contains(partialRegionAnalyses, consumer)) {
                consumedElement2producers = new HashMap();
                consumer2consumedElement2producers.put(consumer, consumedElement2producers);
            }
            if ((explicitPredecessors = consumer.getExplicitPredecessors()) != null) {
                for (PartialRegionAnalysis<PRA> explicitPredecessor : explicitPredecessors) {
                    Set producers = (Set)consumer2producers.get(consumer);
                    assert (producers != null);
                    producers.add(explicitPredecessor);
                }
            }
            if ((consumedClassAnalyses = consumer.getConsumedClassAnalyses()) != null) {
                for (PartialRegionClassAnalysis<PRA> consumedClassAnalysis : consumedClassAnalyses) {
                    for (PartialRegionClassAnalysis<PRA> subConsumedClass : consumedClassAnalysis.getSubClassAnalyses()) {
                        for (PartialRegionAnalysis producer : subConsumedClass.getExactProducers()) {
                            @NonNull @NonNull Set producers = (Set)consumer2producers.get(consumer);
                            assert (producers != null);
                            producers.add(producer);
                            if (consumedElement2producers == null || !Iterables.contains(partialRegionAnalyses, producer)) continue;
                            HashSet<@NonNull PartialRegionAnalysis<@NonNull PRA>> producers2 = (HashSet)consumedElement2producers.get(subConsumedClass);
                            if (producers2 == null) {
                                producers2 = new HashSet();
                                consumedElement2producers.put(subConsumedClass, producers2);
                            }
                            producers2.add(producer);
                        }
                    }
                }
            }
            if ((consumedPropertyAnalyses = consumer.getConsumedPropertyAnalyses()) == null) continue;
            for (PartialRegionPropertyAnalysis<PRA> consumedPropertyAnalysis : consumedPropertyAnalyses) {
                for (PartialRegionAnalysis producer : consumedPropertyAnalysis.getCompatibleProducers()) {
                    @NonNull @NonNull Set producers = (Set)consumer2producers.get(consumer);
                    assert (producers != null);
                    producers.add(producer);
                    if (consumedElement2producers == null || !Iterables.contains(partialRegionAnalyses, producer)) continue;
                    HashSet<@NonNull PartialRegionAnalysis<@NonNull PRA>> producers2 = (HashSet)consumedElement2producers.get(consumedPropertyAnalysis);
                    if (producers2 == null) {
                        producers2 = new HashSet();
                        consumedElement2producers.put(consumedPropertyAnalysis, producers2);
                    }
                    producers2.add(producer);
                }
            }
        }
        if (immediatePredecessorTraceOption != null) {
            CompilerUtil.tracePredecessorsAndSuccessors(immediatePredecessorTraceOption, consumer2producers);
        }
        return consumer2producers;
    }

    public static <T> @NonNull Map<T, @NonNull Set<T>> computeInverseClosure(@NonNull Map<T, @NonNull Set<T>> from2tos) {
        HashMap<T, @NonNull HashSet<E>> to2froms = new HashMap();
        Set<T> froms = from2tos.keySet();
        for (T to : froms) {
            to2froms.put(to, new HashSet());
        }
        for (T from : froms) {
            Set<T> fromTos = from2tos.get(from);
            assert (fromTos != null);
            for (T fromTo : fromTos) {
                Set fromToFroms = (Set)to2froms.get(fromTo);
                assert (fromToFroms != null);
                fromToFroms.add(from);
            }
        }
        return to2froms;
    }

    /*
     * WARNING - void declaration
     * Issues handling annotations - annotations may be inaccurate
     */
    public static @NonNull List<@NonNull Concurrency> computeParallelSchedule(@NonNull Map<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>, @NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>>> partitionAnalysis2predecessors, @Nullable TracingOption transitiveSuccessorTraceOption) {
        Map<@NonNull PartialRegionAnalysis<@NonNull PRA>, @NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PRA>>> partition2successors = CompilerUtil.computeTransitiveSuccessors(partitionAnalysis2predecessors, transitiveSuccessorTraceOption);
        ArrayList<@NonNull Concurrency> parallelSchedule = new ArrayList<Concurrency>();
        HashSet<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>> scheduledPartitionAnalyses = new HashSet<PartialRegionAnalysis<PartitionsAnalysis>>();
        HashSet<@NonNull PartialRegionAnalysis<@NonNull PRA>> scheduleCandidates = new HashSet(partitionAnalysis2predecessors.keySet());
        while (!scheduleCandidates.isEmpty()) {
            void var8_8;
            void var9_17;
            Concurrency nextConcurrency = new Concurrency();
            HashSet<@NonNull PartialRegionAnalysis<@NonNull PRA>> nextScheduleCandidates = new HashSet();
            for (PartialRegionAnalysis partialRegionAnalysis : scheduleCandidates) {
                Iterator predecessors = partitionAnalysis2predecessors.get(partialRegionAnalysis);
                assert (predecessors != null);
                HashSet<@NonNull @NonNull E> unscheduledPredecessors = new HashSet(predecessors);
                unscheduledPredecessors.remove(partialRegionAnalysis);
                unscheduledPredecessors.removeAll(scheduledPartitionAnalyses);
                if (!unscheduledPredecessors.isEmpty()) continue;
                nextConcurrency.add(partialRegionAnalysis);
                Set<@NonNull PartialRegionAnalysis<@NonNull PRA>> unscheduledSuccessors = partition2successors.get(partialRegionAnalysis);
                assert (unscheduledSuccessors != null);
                nextScheduleCandidates.addAll(unscheduledSuccessors);
            }
            if (nextConcurrency.size() <= 0) {
                void var8_12;
                Object var8_11 = null;
                for (PartialRegionAnalysis partialRegionAnalysis : scheduleCandidates) {
                    Set<@NonNull PartialRegionAnalysis<@NonNull PRA>> predecessors = partitionAnalysis2predecessors.get(partialRegionAnalysis);
                    assert (predecessors != null);
                    HashSet<@NonNull PartialRegionAnalysis<@NonNull PRA>> unscheduledPredecessors = new HashSet(predecessors);
                    unscheduledPredecessors.removeAll(scheduledPartitionAnalyses);
                    if (var8_12 != null && unscheduledPredecessors.size() >= var8_12.size()) continue;
                    HashSet<@NonNull PartialRegionAnalysis<@NonNull PRA>> hashSet = unscheduledPredecessors;
                }
                assert (var8_12 != null);
                for (PartialRegionAnalysis partialRegionAnalysis : var8_12) {
                    nextConcurrency.add(partialRegionAnalysis);
                }
            }
            assert (nextConcurrency.size() > 0);
            Object var8_15 = null;
            Object var9_23 = null;
            for (PartialRegionAnalysis<PartitionsAnalysis> partitionAnalysis : nextConcurrency) {
                nextScheduleCandidates.remove(partitionAnalysis);
                scheduledPartitionAnalyses.add(partitionAnalysis);
                if (partitionAnalysis instanceof CompositePartitionAnalysis) {
                    if (var9_17 == null) {
                        ArrayList<@NonNull E> arrayList = new ArrayList();
                    }
                    var9_17.add((CompositePartitionAnalysis)partitionAnalysis);
                    continue;
                }
                if (var8_8 == null) {
                    Concurrency concurrency = new Concurrency();
                }
                var8_8.add(partitionAnalysis);
            }
            if (var8_8 != null) {
                parallelSchedule.add((Concurrency)var8_8);
            }
            if (var9_17 != null) {
                Collections.sort(var9_17, NameUtil.NAMEABLE_COMPARATOR);
                for (CompositePartitionAnalysis compositePartitionAnalysis : var9_17) {
                    Concurrency nextCompositeConcurrency = new Concurrency();
                    nextCompositeConcurrency.add(compositePartitionAnalysis);
                    parallelSchedule.add(nextCompositeConcurrency);
                }
            }
            scheduleCandidates = nextScheduleCandidates;
        }
        return parallelSchedule;
    }

    public static <PRA extends PartialRegionsAnalysis<PRA>> @NonNull Map<@NonNull PartialRegionAnalysis<@NonNull PRA>, @NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PRA>>> computeTransitivePredecessors(@NonNull Iterable<? extends @NonNull PartialRegionAnalysis<@NonNull PRA>> partialRegionAnalyses, @Nullable TracingOption immediatePredecessorTraceOption, @Nullable TracingOption transitivePredecessorTraceOption) {
        Map<@NonNull PartialRegionAnalysis<@NonNull PRA>, @NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PRA>>> consumer2producers = CompilerUtil.computeImmediatePredecessors(partialRegionAnalyses, immediatePredecessorTraceOption);
        Map<@NonNull PartialRegionAnalysis<@NonNull PRA>, @NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PRA>>> consumer2producersClosure = CompilerUtil.computeClosure(consumer2producers);
        if (transitivePredecessorTraceOption != null) {
            CompilerUtil.tracePredecessorsAndSuccessors(transitivePredecessorTraceOption, consumer2producersClosure);
        }
        return consumer2producersClosure;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static <PRA extends PartialRegionsAnalysis<PRA>> @NonNull Map<@NonNull PartialRegionAnalysis<@NonNull PRA>, @NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PRA>>> computeTransitiveSuccessors(@NonNull Map<@NonNull PartialRegionAnalysis<@NonNull PRA>, @NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PRA>>> partialRegion2predecessors, @Nullable TracingOption transitiveSuccessorTraceOption) {
        HashMap<@NonNull PartialRegionAnalysis<@NonNull PRA>, @NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PRA>>> producer2consumersClosure = new HashMap<PartialRegionAnalysis<PRA>, Set<PartialRegionAnalysis<PRA>>>();
        Set<@NonNull PartialRegionAnalysis<@NonNull PRA>> partialRegions = partialRegion2predecessors.keySet();
        for (PartialRegionAnalysis partialRegionAnalysis : partialRegions) {
            producer2consumersClosure.put(partialRegionAnalysis, new HashSet());
        }
        for (PartialRegionAnalysis partialRegionAnalysis : partialRegions) {
            @NonNull @NonNull Iterable predecessors = partialRegion2predecessors.get(partialRegionAnalysis);
            assert (predecessors != null);
            for (PartialRegionAnalysis predecessor : predecessors) {
                @NonNull @NonNull Set successors = (Set)producer2consumersClosure.get(predecessor);
                assert (successors != null);
                successors.add(partialRegionAnalysis);
            }
        }
        if (transitiveSuccessorTraceOption != null) {
            CompilerUtil.tracePredecessorsAndSuccessors(transitiveSuccessorTraceOption, producer2consumersClosure);
        }
        return producer2consumersClosure;
    }

    public static @NonNull List<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>> gatherPartitionAnalyses(@NonNull CompositePartitionAnalysis rootPartitionAnalysis, @NonNull List<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>> allPartitionAnalyses) {
        for (PartialRegionAnalysis<PartitionsAnalysis> partitionAnalysis : rootPartitionAnalysis.getPartitionAnalyses()) {
            assert (!allPartitionAnalyses.contains(partitionAnalysis));
            if (partitionAnalysis instanceof CompositePartitionAnalysis) {
                CompilerUtil.gatherPartitionAnalyses((CompositePartitionAnalysis)partitionAnalysis, allPartitionAnalyses);
                continue;
            }
            allPartitionAnalyses.add(partitionAnalysis);
        }
        return allPartitionAnalyses;
    }

    public static @NonNull GenPackage getGenPackage(@NonNull ResourceSet resourceSet, @NonNull String resourcePath, @Nullable String fragment) {
        URI uri = URI.createPlatformResourceURI((String)resourcePath, (boolean)false);
        if (fragment != null) {
            uri = uri.appendFragment(fragment);
        }
        return (GenPackage)ClassUtil.nonNullState((Object)((GenPackage)resourceSet.getEObject(uri, true)));
    }

    public static void indent(@NonNull StringBuilder s, int depth) {
        int i = 0;
        while (i < depth) {
            s.append("    ");
            ++i;
        }
    }

    public static boolean isAbstract(@NonNull Partition partition) {
        Region originalRegion = partition.getRegion();
        if (originalRegion instanceof RuleRegion) {
            if (originalRegion instanceof DispatchRegion) {
                return false;
            }
            if (originalRegion instanceof VerdictRegion) {
                return false;
            }
            return ((RuleRegion)originalRegion).getReferredRule().isIsAbstract();
        }
        if (originalRegion instanceof DispatchRegion) {
            return false;
        }
        return false;
    }

    public static void migrateCastEdgeTargetContents(@NonNull CastEdge oldEdge, @NonNull Node newTarget) {
        Node fromNode = QVTscheduleUtil.getTargetNode((Edge)oldEdge);
        oldEdge.destroy();
        List operationOutgoingEdgesList = newTarget.getOutgoingEdges();
        for (Element element : fromNode.getOriginatingElements()) {
            if (element instanceof VariableDeclaration) {
                newTarget.setOriginatingVariable((VariableDeclaration)element);
                continue;
            }
            newTarget.addOriginatingElement(element);
        }
        for (Edge targetOutgoingEdge : Lists.newArrayList((Iterable)fromNode.getOutgoingEdges())) {
            operationOutgoingEdgesList.add(targetOutgoingEdge);
        }
        newTarget.getIncomingEdges().addAll(fromNode.getIncomingEdges());
        fromNode.destroy();
    }

    public static void normalizeNameables(@NonNull List<@NonNull ? extends Nameable> nameables) {
        if (nameables instanceof EList) {
            ECollections.sort((EList)((EList)nameables), (Comparator)NameUtil.NAMEABLE_COMPARATOR);
        } else {
            Collections.sort(nameables, NameUtil.NAMEABLE_COMPARATOR);
        }
    }

    public static @Nullable String recoverVariableName(@NonNull NamedElement namedElement) {
        OCLExpression source;
        OperationCallExp operationCallExp;
        EObject eContainer = namedElement.eContainer();
        EReference eContainmentFeature = namedElement.eContainmentFeature();
        if (eContainmentFeature == PivotPackage.Literals.VARIABLE__OWNED_INIT && eContainer instanceof Variable) {
            return ((Variable)eContainer).getName();
        }
        if (eContainmentFeature == QVTcorePackage.Literals.ASSIGNMENT__VALUE && eContainer instanceof VariableAssignment) {
            return ((VariableAssignment)eContainer).getTargetVariable().getName();
        }
        if (eContainmentFeature == PivotPackage.Literals.CALL_EXP__OWNED_SOURCE && eContainer instanceof OperationCallExp) {
            OCLExpression argument;
            OperationCallExp operationCallExp2 = (OperationCallExp)eContainer;
            if (PivotUtil.isSameOperation((OperationId)operationCallExp2.getReferredOperation().getOperationId(), (OperationId)OperationId.OCLANY_EQUALS) && (argument = PivotUtil.getOwnedArgument((OperationCallExp)operationCallExp2, (int)0)) instanceof VariableExp) {
                return PivotUtil.getReferredVariable((VariableExp)((VariableExp)argument)).getName();
            }
        } else if (eContainmentFeature == PivotPackage.Literals.OPERATION_CALL_EXP__OWNED_ARGUMENTS && eContainer instanceof OperationCallExp && PivotUtil.isSameOperation((OperationId)(operationCallExp = (OperationCallExp)eContainer).getReferredOperation().getOperationId(), (OperationId)OperationId.OCLANY_EQUALS) && (source = PivotUtil.getOwnedSource((CallExp)operationCallExp)) instanceof VariableExp) {
            return PivotUtil.getReferredVariable((VariableExp)((VariableExp)source)).getName();
        }
        return null;
    }

    public static <T> void removeAll(@NonNull Collection<T> removeFrom, @NonNull Iterable<T> elementsToTemove) {
        for (T element : elementsToTemove) {
            removeFrom.remove(element);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void throwExceptionWithProblems(@NonNull CodeGenerator codeGenerator, @NonNull Exception e) throws Exception {
        @NonNull List problems = codeGenerator.getProblems();
        if (problems != null) {
            StringBuilder s = new StringBuilder();
            for (Exception ex : problems) {
                s.append(String.valueOf(ex.toString()) + "\n");
            }
            s.append(e.toString());
            throw new CompilerChainException(e, s.toString(), new Object[0]);
        }
        throw e;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static <PRA extends PartialRegionsAnalysis<PRA>> void tracePredecessorsAndSuccessors(@NonNull TracingOption immediatePredecessorTraceOption, @NonNull Map<@NonNull PartialRegionAnalysis<@NonNull PRA>, @NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PRA>>> consumer2producers) {
        if (immediatePredecessorTraceOption.isActive()) {
            @NonNull @NonNull ArrayList consumers = Lists.newArrayList(consumer2producers.keySet());
            Collections.sort(consumers, NameUtil.NAMEABLE_COMPARATOR);
            for (PartialRegionAnalysis consumer : consumers) {
                StringBuilder s = new StringBuilder();
                s.append(consumer + ":");
                ArrayList<@NonNull @NonNull E> producers = new ArrayList(consumer2producers.get(consumer));
                Collections.sort(producers, NameUtil.NAMEABLE_COMPARATOR);
                for (PartialRegionAnalysis producer : producers) {
                    s.append(" " + producer);
                }
                immediatePredecessorTraceOption.println(s.toString());
            }
        }
    }

    public static void traceSchedule(@NonNull TracingOption traceOption, @Nullable String scheduleName, @NonNull Iterable<@NonNull Concurrency> parallelSchedule) {
        if (traceOption.isActive()) {
            StringBuilder s = new StringBuilder();
            int passNumber = 0;
            if (scheduleName != null) {
                s.append(scheduleName);
            }
            for (Concurrency concurrency : parallelSchedule) {
                s.append("\n  [");
                if (scheduleName != null) {
                    s.append("+");
                }
                s.append(passNumber);
                s.append("]");
                concurrency.toString(s);
                ++passNumber;
            }
            traceOption.println(s.toString());
        }
    }
}

