/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.project;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.m2m.internal.qvt.oml.ast.env.ModelExtentContents;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtEvaluationResult;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnvFactory;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalFileEnv;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.common.launch.SafeRunner;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledModule;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompiler;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.library.IContext;
import org.eclipse.m2m.internal.qvt.oml.runtime.generator.TransformationRunner;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtModule;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtTransformation;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.WorkspaceQvtModule;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.config.QvtConfigurationProperty;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.EvaluationVisitor;
import org.eclipse.ocl.utilities.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtInterpretedTransformation
implements QvtTransformation {
    private final QvtModule myModule;

    public QvtInterpretedTransformation(IFile transformationFile) {
        this.myModule = new WorkspaceQvtModule(transformationFile);
    }

    public QvtInterpretedTransformation(QvtModule qvtModule) {
        if (qvtModule == null) {
            throw new IllegalArgumentException("Null QvtModule");
        }
        this.myModule = qvtModule;
    }

    @Override
    public EObject loadInput(URI inputObjectURI) throws MdaException {
        return EmfUtil.loadModel((URI)inputObjectURI, (ResourceSet)this.myModule.getCompiler().getResourceSet());
    }

    public void setQvtCompilerOptions(QvtCompilerOptions options) {
        this.myModule.setQvtCompilerOptions(options);
    }

    @Override
    public TransformationRunner.Out run(TransformationRunner.In in) throws MdaException {
        CompiledModule module = this.myModule.getModule();
        Iterator<QvtTransformation.TransformationParameter> itrParam = this.getParameters().iterator();
        ArrayList<Object> inputs = new ArrayList<Object>(in.getSources().length);
        EObject[] eObjectArray = in.getSources();
        int n = eObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            EObject inObject = eObjectArray[n2];
            QvtTransformation.TransformationParameter transfParam = null;
            while (itrParam.hasNext()) {
                transfParam = itrParam.next();
                if (transfParam.getDirectionKind() != QvtTransformation.TransformationParameter.DirectionKind.OUT) break;
                transfParam = null;
            }
            EClass mmClass = this.myModule.getIn();
            if (transfParam != null) {
                if (transfParam.getEntryType() != null) {
                    mmClass = transfParam.getEntryType();
                } else if (!transfParam.getMetamodels().isEmpty()) {
                    mmClass = (EObject)transfParam.getMetamodels().get(0);
                }
            }
            try {
                EObject input = EmfUtil.resolveSource((EObject)inObject, (EObject)mmClass);
                inputs.add(input);
            }
            catch (WrappedException e) {
                throw new MdaException(e.getCause());
            }
            ++n2;
        }
        Object outObj = this.evaluate(this.myModule.getCompiler(), module, inputs, in.getContext());
        if (!(outObj instanceof QvtEvaluationResult)) {
            return new TransformationRunner.Out(Collections.<ModelExtentContents>emptyList(), Collections.<Object>emptyList(), in.getContext().getTrace());
        }
        return new TransformationRunner.Out(((QvtEvaluationResult)outObj).getModelExtents(), ((QvtEvaluationResult)outObj).getOutParamValues(), in.getContext().getTrace());
    }

    @Override
    public String getModuleName() throws MdaException {
        return this.myModule.getModuleName();
    }

    @Override
    public EClass getIn() throws MdaException {
        return this.myModule.getIn();
    }

    @Override
    public EClass getOut() throws MdaException {
        return this.myModule.getOut();
    }

    @Override
    public List<QvtTransformation.TransformationParameter> getParameters() throws MdaException {
        return this.myModule.getParameters();
    }

    @Override
    public Set<QvtConfigurationProperty> getConfigurationProperties() throws MdaException {
        return this.myModule.getConfigurationProperties();
    }

    public static SafeRunner.IRunner getSafeRunner(CompiledModule module) throws CoreException {
        EClass[] classes = new EClass[]{QvtModule.getInType(module), QvtModule.getReturnType(module)};
        return SafeRunner.getSafeRunner((EClass[])classes);
    }

    protected QvtOperationalEnvFactory getEnvironmentFactory() {
        return new QvtOperationalEnvFactory();
    }

    private Object evaluate(QvtCompiler compiler, CompiledModule module, List<Object> args, IContext context) {
        QvtOperationalEnvFactory factory = this.getEnvironmentFactory();
        QvtOperationalEvaluationEnv evaluationEnv = factory.createEvaluationEnvironment(context, null);
        evaluationEnv.getOperationArgs().addAll(args);
        QvtOperationalFileEnv rootEnv = factory.createEnvironment(null, module.getSource(), compiler.getKernel());
        EvaluationVisitor evaluator = factory.createEvaluationVisitor((Environment)rootEnv, (EvaluationEnvironment)evaluationEnv, null);
        return module.getModule().accept((Visitor)evaluator);
    }

    public String toString() {
        try {
            return this.getModuleName();
        }
        catch (MdaException mdaException) {
            return super.toString();
        }
    }
}

