/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.clustering;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Queue;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.builder.MonitorBasedCancelIndicator;
import org.eclipse.xtext.builder.builderState.AbstractBuilderState;
import org.eclipse.xtext.builder.builderState.BuilderStateUtil;
import org.eclipse.xtext.builder.builderState.impl.ResourceDescriptionImpl;
import org.eclipse.xtext.builder.clustering.CopiedResourceDescription;
import org.eclipse.xtext.builder.clustering.CurrentDescriptions;
import org.eclipse.xtext.builder.debug.IBuildLogger;
import org.eclipse.xtext.builder.impl.BuildData;
import org.eclipse.xtext.builder.resourceloader.IResourceLoader;
import org.eclipse.xtext.resource.CompilerPhases;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.clustering.IResourceClusteringPolicy;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionDelta;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.resource.persistence.SourceLevelURIsAdapter;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.Strings;

public class ClusteringBuilderState
extends AbstractBuilderState {
    public static final String RESOURCELOADER_CROSS_LINKING = "org.eclipse.xtext.builder.resourceloader.crossLinking";
    public static final String RESOURCELOADER_GLOBAL_INDEX = "org.eclipse.xtext.builder.resourceloader.globalIndex";
    private static final Logger LOGGER = Logger.getLogger(ClusteringBuilderState.class);
    @Inject
    private IResourceServiceProvider.Registry managerRegistry;
    @Inject
    private IResourceClusteringPolicy clusteringPolicy;
    @Inject
    @Named(value="org.eclipse.xtext.builder.resourceloader.globalIndex")
    private IResourceLoader globalIndexResourceLoader;
    @Inject
    @Named(value="org.eclipse.xtext.builder.resourceloader.crossLinking")
    private IResourceLoader crossLinkingResourceLoader;
    @Inject
    private IWorkspace workspace;
    @Inject
    private IResourceServiceProvider.Registry resourceServiceProviderRegistry;
    @Inject
    private CompilerPhases compilerPhases;
    @Inject
    private IBuildLogger buildLogger;

    @Override
    protected Collection<IResourceDescription.Delta> doUpdate(BuildData buildData, ResourceDescriptionsData newData, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)101);
        Set<URI> toBeDeleted = buildData.getAndRemoveToBeDeleted();
        ResourceSet resourceSet = buildData.getResourceSet();
        CurrentDescriptions newState = new CurrentDescriptions(resourceSet, newData, buildData);
        buildData.getSourceLevelURICache().cacheAsSourceURIs(toBeDeleted);
        this.installSourceLevelURIs(buildData);
        this.writeNewResourceDescriptions(buildData, this, newState, (IProgressMonitor)progress.split(20));
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        for (URI uri : toBeDeleted) {
            newData.removeDescription(uri);
        }
        LinkedHashSet allRemainingURIs = Sets.newLinkedHashSet((Iterable)newData.getAllURIs());
        allRemainingURIs.removeAll(buildData.getToBeUpdated());
        for (URI remainingURI : buildData.getAllRemainingURIs()) {
            allRemainingURIs.remove(remainingURI);
        }
        HashSet allDeltas = Sets.newHashSet();
        if (!toBeDeleted.isEmpty()) {
            for (URI uri : toBeDeleted) {
                IResourceDescription oldDescription = this.getResourceDescription(uri);
                if (oldDescription == null) continue;
                allDeltas.add(new DefaultResourceDescriptionDelta(oldDescription, null));
            }
        }
        Collection<IResourceDescription.Delta> pendingDeltas = buildData.getAndRemovePendingDeltas();
        allDeltas.addAll(pendingDeltas);
        this.queueAffectedResources(allRemainingURIs, this, newState, allDeltas, allDeltas, buildData, (IProgressMonitor)progress.split(1));
        this.installSourceLevelURIs(buildData);
        IProject currentProject = this.getBuiltProject(buildData);
        IResourceLoader.LoadOperation loadOperation = null;
        try {
            Queue<URI> queue = buildData.getURIQueue();
            loadOperation = this.crossLinkingResourceLoader.create(resourceSet, currentProject);
            loadOperation.load(queue);
            SubMonitor subProgress = progress.split(80);
            MonitorBasedCancelIndicator cancelMonitor = new MonitorBasedCancelIndicator((IProgressMonitor)progress);
            while (!queue.isEmpty()) {
                subProgress.setWorkRemaining((queue.size() + 1) * 3);
                int clusterIndex = 0;
                ArrayList changedDeltas = Lists.newArrayList();
                while (!queue.isEmpty()) {
                    DefaultResourceDescriptionDelta newDelta;
                    block32: {
                        if (subProgress.isCanceled()) {
                            loadOperation.cancel();
                            throw new OperationCanceledException();
                        }
                        if (!this.clusteringPolicy.continueProcessing(resourceSet, null, clusterIndex)) break;
                        URI changedURI = null;
                        URI actualResourceURI = null;
                        Resource resource = null;
                        newDelta = null;
                        try {
                            IResourceLoader.LoadResult loadResult = loadOperation.next();
                            changedURI = loadResult.getUri();
                            actualResourceURI = loadResult.getResource().getURI();
                            resource = this.addResource(loadResult.getResource(), resourceSet);
                            subProgress.subTask("Updating resource " + resource.getURI().lastSegment());
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug((Object)("Update resource description " + String.valueOf(actualResourceURI)));
                            }
                            queue.remove(changedURI);
                            if (toBeDeleted.contains(changedURI)) break;
                            this.buildLogger.log("indexing " + String.valueOf(changedURI));
                            IResourceDescription.Manager manager = this.getResourceDescriptionManager(actualResourceURI);
                            if (manager == null) break block32;
                            try {
                                EcoreUtil2.resolveLazyCrossReferences((Resource)resource, (CancelIndicator)cancelMonitor);
                                IResourceDescription description = manager.getResourceDescription(resource);
                                ResourceDescriptionImpl copiedDescription = BuilderStateUtil.create(description);
                                newDelta = manager.createDelta(this.getResourceDescription(actualResourceURI), (IResourceDescription)copiedDescription);
                            }
                            catch (OperationCanceledException e) {
                                loadOperation.cancel();
                                throw e;
                            }
                            catch (WrappedException e) {
                                throw e;
                            }
                            catch (RuntimeException e) {
                                LOGGER.error((Object)("Error resolving cross references on resource '" + String.valueOf(actualResourceURI) + "'"), (Throwable)e);
                                throw new IResourceLoader.LoadOperationException(actualResourceURI, e);
                            }
                        }
                        catch (WrappedException ex) {
                            ResourceDescriptionImpl indexReadyDescription;
                            if (ex instanceof IResourceLoader.LoadOperationException) {
                                changedURI = ((IResourceLoader.LoadOperationException)ex).getUri();
                            }
                            Throwable cause = ex.getCause();
                            boolean wasResourceNotFound = false;
                            if (cause instanceof CoreException && 368 == ((CoreException)cause).getStatus().getCode()) {
                                wasResourceNotFound = true;
                            }
                            if (changedURI == null) {
                                LOGGER.error((Object)"Error loading resource", (Throwable)ex);
                            }
                            queue.remove(changedURI);
                            if (toBeDeleted.contains(changedURI)) break;
                            if (!wasResourceNotFound) {
                                LOGGER.error((Object)("Error loading resource from: " + changedURI.toString()), (Throwable)ex);
                            }
                            if (resource != null) {
                                resourceSet.getResources().remove((Object)resource);
                            }
                            IResourceDescription oldDescription = this.getResourceDescription(changedURI);
                            IResourceDescription newDesc = newState.getResourceDescription(changedURI);
                            ResourceDescriptionImpl resourceDescriptionImpl = indexReadyDescription = newDesc != null ? BuilderStateUtil.create(newDesc) : null;
                            if (oldDescription == null && indexReadyDescription == null || oldDescription == indexReadyDescription) break block32;
                            newDelta = new DefaultResourceDescriptionDelta(oldDescription, (IResourceDescription)indexReadyDescription);
                        }
                    }
                    if (newDelta != null) {
                        allDeltas.add(newDelta);
                        ++clusterIndex;
                        if (newDelta.haveEObjectDescriptionsChanged()) {
                            changedDeltas.add(newDelta);
                        }
                        newState.register((IResourceDescription.Delta)newDelta);
                        if (!buildData.isIndexingOnly()) {
                            try {
                                this.updateMarkers((IResourceDescription.Delta)newDelta, resourceSet, (IProgressMonitor)subProgress);
                            }
                            catch (OperationCanceledException e) {
                                loadOperation.cancel();
                                throw e;
                            }
                            catch (Exception e) {
                                LOGGER.error((Object)("Error validating " + String.valueOf(newDelta.getUri())), (Throwable)e);
                            }
                        }
                    }
                    subProgress.split(2);
                }
                loadOperation.cancel();
                this.queueAffectedResources(allRemainingURIs, this, newState, changedDeltas, allDeltas, buildData, (IProgressMonitor)subProgress.split(1));
                this.installSourceLevelURIs(buildData);
                if (queue.size() > 0) {
                    loadOperation = this.crossLinkingResourceLoader.create(resourceSet, currentProject);
                    loadOperation.load(queue);
                }
                if (queue.isEmpty() || this.clusteringPolicy.continueProcessing(resourceSet, null, clusterIndex)) continue;
                this.clearResourceSet(resourceSet);
            }
        }
        finally {
            if (loadOperation != null) {
                loadOperation.cancel();
            }
            if (!progress.isCanceled()) {
                progress.done();
            }
        }
        return allDeltas;
    }

    protected void installSourceLevelURIs(BuildData buildData) {
        ResourceSet resourceSet = buildData.getResourceSet();
        Iterable sourceLevelUris = Iterables.concat(buildData.getToBeUpdated(), buildData.getURIQueue());
        HashSet sourceUris = Sets.newHashSet();
        for (URI uri : sourceLevelUris) {
            if (!buildData.getSourceLevelURICache().getOrComputeIsSource(uri, this.resourceServiceProviderRegistry)) continue;
            sourceUris.add(uri);
            Resource resource = resourceSet.getResource(uri, false);
            if (!(resource instanceof StorageAwareResource) || !((StorageAwareResource)resource).isLoadedFromStorage()) continue;
            resource.unload();
        }
        SourceLevelURIsAdapter.setSourceLevelUris((ResourceSet)resourceSet, (Collection)sourceUris);
    }

    protected void writeNewResourceDescriptions(BuildData buildData, IResourceDescriptions oldState, CurrentDescriptions newState, IProgressMonitor monitor) {
        int index = 0;
        ResourceSet resourceSet = buildData.getResourceSet();
        Set<URI> toBeUpdated = buildData.getToBeUpdated();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Write new resource descriptions", (int)(toBeUpdated.size() + 1));
        IProject currentProject = this.getBuiltProject(buildData);
        IResourceLoader.LoadOperation loadOperation = null;
        try {
            this.compilerPhases.setIndexing((Notifier)resourceSet, true);
            loadOperation = this.globalIndexResourceLoader.create(resourceSet, currentProject);
            loadOperation.load(toBeUpdated);
            while (loadOperation.hasNext()) {
                block15: {
                    if (subMonitor.isCanceled()) {
                        loadOperation.cancel();
                        throw new OperationCanceledException();
                    }
                    if (!this.clusteringPolicy.continueProcessing(resourceSet, null, index)) {
                        this.clearResourceSet(resourceSet);
                    }
                    URI uri = null;
                    Resource resource = null;
                    try {
                        IResourceDescription.Manager manager;
                        IResourceLoader.LoadResult loadResult = loadOperation.next();
                        uri = loadResult.getUri();
                        resource = this.addResource(loadResult.getResource(), resourceSet);
                        subMonitor.subTask("Writing new resource description " + resource.getURI().lastSegment());
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)("Writing new resource description " + String.valueOf(uri)));
                        }
                        if ((manager = this.getResourceDescriptionManager(uri)) != null) {
                            IResourceDescription description = manager.getResourceDescription(resource);
                            CopiedResourceDescription copiedDescription = new CopiedResourceDescription(description);
                            newState.register((IResourceDescription.Delta)new DefaultResourceDescriptionDelta(oldState.getResourceDescription(uri), (IResourceDescription)copiedDescription));
                            buildData.queueURI(uri);
                        }
                    }
                    catch (RuntimeException ex) {
                        IResourceDescription oldDescription;
                        if (ex instanceof IResourceLoader.LoadOperationException) {
                            uri = ((IResourceLoader.LoadOperationException)((Object)ex)).getUri();
                        }
                        if (uri == null) {
                            LOGGER.error((Object)"Error loading resource", (Throwable)ex);
                        }
                        if (resourceSet.getURIConverter().exists(uri, Collections.emptyMap())) {
                            LOGGER.error((Object)("Error loading resource from: " + uri.toString()), (Throwable)ex);
                        }
                        if (resource != null) {
                            resourceSet.getResources().remove((Object)resource);
                        }
                        if ((oldDescription = oldState.getResourceDescription(uri)) == null) break block15;
                        newState.register((IResourceDescription.Delta)new DefaultResourceDescriptionDelta(oldDescription, null));
                    }
                }
                ++index;
                subMonitor.split(1);
            }
        }
        finally {
            this.compilerPhases.setIndexing((Notifier)resourceSet, false);
            if (loadOperation != null) {
                loadOperation.cancel();
            }
        }
    }

    protected IProject getBuiltProject(BuildData buildData) {
        if (Strings.isEmpty((String)buildData.getProjectName())) {
            return null;
        }
        return this.workspace.getRoot().getProject(buildData.getProjectName());
    }

    protected void clearResourceSet(ResourceSet resourceSet) {
        boolean wasDeliver = resourceSet.eDeliver();
        try {
            resourceSet.eSetDeliver(false);
            for (Resource resource : resourceSet.getResources()) {
                resource.eSetDeliver(false);
            }
            resourceSet.getResources().clear();
        }
        finally {
            resourceSet.eSetDeliver(wasDeliver);
        }
    }

    protected Resource addResource(Resource resource, ResourceSet resourceSet) {
        URI uri = resource.getURI();
        Resource r = resourceSet.getResource(uri, false);
        if (r == null) {
            resourceSet.getResources().add((Object)resource);
            return resource;
        }
        return r;
    }

    protected void queueAffectedResources(Set<URI> allRemainingURIs, IResourceDescriptions oldState, CurrentDescriptions newState, Collection<IResourceDescription.Delta> changedDeltas, Collection<IResourceDescription.Delta> allDeltas, BuildData buildData, IProgressMonitor monitor) {
        if (allDeltas.isEmpty()) {
            return;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(allRemainingURIs.size() + 1));
        Iterator<URI> iter = allRemainingURIs.iterator();
        while (iter.hasNext()) {
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            URI candidateURI = iter.next();
            progress.subTask("Checking if " + candidateURI.lastSegment() + " is affected by changes");
            IResourceDescription candidateDescription = oldState.getResourceDescription(candidateURI);
            IResourceDescription.Manager manager = this.getResourceDescriptionManager(candidateURI);
            if (candidateDescription == null || manager == null) {
                iter.remove();
            } else {
                boolean affected = manager instanceof IResourceDescription.Manager.AllChangeAware ? ((IResourceDescription.Manager.AllChangeAware)manager).isAffectedByAny(allDeltas, candidateDescription, (IResourceDescriptions)newState) : (changedDeltas.isEmpty() ? false : manager.isAffected(changedDeltas, candidateDescription, (IResourceDescriptions)newState));
                if (affected) {
                    buildData.queueURI(candidateURI);
                    iter.remove();
                }
            }
            progress.split(1);
        }
    }

    protected IResourceDescription.Manager getResourceDescriptionManager(URI uri) {
        IResourceServiceProvider resourceServiceProvider = this.managerRegistry.getResourceServiceProvider(uri);
        if (resourceServiceProvider == null) {
            return null;
        }
        return resourceServiceProvider.getResourceDescriptionManager();
    }
}

